/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.threadpool;

import java.util.TimerTask;
import java.util.concurrent.ThreadPoolExecutor;
import org.voovan.tools.TEnv;
import org.voovan.tools.TPerformance;
import org.voovan.tools.log.Logger;
import org.voovan.tools.threadpool.ThreadPool;

public class ThreadPoolTask
extends TimerTask {
    private ThreadPoolExecutor threadPoolInstance;
    private int cpuCoreCount = Runtime.getRuntime().availableProcessors();
    private int count = 0;

    public ThreadPoolTask(ThreadPoolExecutor threadPoolInstance) {
        this.threadPoolInstance = threadPoolInstance;
    }

    @Override
    public void run() {
        try {
            if (this.threadPoolInstance.isShutdown()) {
                this.cancel();
            }
            if (this.count * 1000 % ThreadPool.getStatusInterval() == 0) {
                String threadPoolInfo = "[PoolInfo]: A:" + this.threadPoolInstance.getActiveCount() + "/ S:" + this.threadPoolInstance.getCorePoolSize() + "/ L:" + this.threadPoolInstance.getLargestPoolSize() + "/ M:" + this.threadPoolInstance.getMaximumPoolSize() + " \t[TaskCount]: " + this.threadPoolInstance.getCompletedTaskCount() + "/" + this.threadPoolInstance.getTaskCount() + " \t[QueueSize]: " + this.threadPoolInstance.getQueue().size() + " \t[PerCoreLoadAvg]: " + TPerformance.cpuPerCoreLoadAvg();
                if (this.threadPoolInstance.getActiveCount() != 0) {
                    Logger.fremawork("[ShutDown]: " + this.threadPoolInstance.isShutdown() + " \t" + threadPoolInfo);
                }
            }
            ++this.count;
            int poolSize = this.threadPoolInstance.getPoolSize();
            if (this.threadPoolInstance.getQueue().size() > 0) {
                int newPoolSize = (int)((double)this.threadPoolInstance.getCorePoolSize() * 1.2);
                if (newPoolSize > ThreadPool.MAX_POOL_SIZE) {
                    newPoolSize = ThreadPool.MAX_POOL_SIZE;
                }
                if (newPoolSize != poolSize) {
                    this.threadPoolInstance.setCorePoolSize(newPoolSize);
                    Logger.fremawork("PoolSizeChange: " + poolSize + "->" + this.threadPoolInstance.getCorePoolSize());
                }
            } else if (this.threadPoolInstance.getActiveCount() <= this.threadPoolInstance.getPoolSize() / 2 && this.threadPoolInstance.getCorePoolSize() > ThreadPool.MIN_POOL_SIZE) {
                int newPoolsize = (int)((double)this.threadPoolInstance.getCorePoolSize() * 0.8);
                if (newPoolsize < ThreadPool.MIN_POOL_SIZE) {
                    newPoolsize = ThreadPool.MIN_POOL_SIZE;
                }
                if (newPoolsize != poolSize) {
                    this.threadPoolInstance.setCorePoolSize(newPoolsize);
                    Logger.fremawork("PoolSizeChange: " + poolSize + "->" + this.threadPoolInstance.getCorePoolSize());
                }
            }
            if (TEnv.IS_SHUTDOWN) {
                this.threadPoolInstance.shutdown();
            }
        }
        catch (Exception e) {
            Logger.error("Threadpooltask error: ", e);
        }
    }
}

