/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.threadpool;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.voovan.tools.FastThread;

public class DefaultThreadFactory
implements ThreadFactory {
    private String name;
    private AtomicInteger threadCount = new AtomicInteger(0);
    private boolean daemon;
    private int priority;

    public DefaultThreadFactory(String name) {
        this(name, false, 5);
    }

    public DefaultThreadFactory(String name, boolean daemon) {
        this(name, daemon, 5);
    }

    public DefaultThreadFactory(String name, boolean daemon, int priority) {
        this.name = name;
        this.daemon = daemon;
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable r) {
        FastThread fastThread = new FastThread(r, this.name + "-" + this.threadCount.getAndIncrement());
        try {
            if (fastThread.isDaemon()) {
                if (!this.daemon) {
                    fastThread.setDaemon(false);
                }
            } else if (this.daemon) {
                fastThread.setDaemon(true);
            }
            if (fastThread.getPriority() != this.priority) {
                fastThread.setPriority(this.priority);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fastThread;
    }
}

