/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.security;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.voovan.tools.log.Logger;
import org.voovan.tools.security.TBase64;

public class THash {
    public static String decryptBASE64(String key) {
        return new String(TBase64.decode(key));
    }

    public static String encryptBASE64(String key) {
        return TBase64.encode(key.getBytes());
    }

    public static String encryptMD5(String str) {
        return THash.digest("MD5", str);
    }

    public static String encryptSHA(String str) {
        return THash.digest("SHA", str);
    }

    public static String digest(String code, String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(code);
            messageDigest.reset();
            messageDigest.update(str.getBytes());
            byte[] byteArray = messageDigest.digest();
            StringBuffer md5StrBuff = new StringBuffer();
            for (int i = 0; i < byteArray.length; ++i) {
                if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                    md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                    continue;
                }
                md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
            }
            return md5StrBuff.toString();
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error("No such algorithm", e);
            return null;
        }
    }

    public static int hashTime31(byte[] source, int offset, int length) {
        int hash = 0;
        for (int i = offset; i < length; ++i) {
            hash = (hash << 5) - hash + source[i];
        }
        return hash;
    }

    public static int hashTime31(ByteBuffer byteBuffer, int offset, int length) {
        int hash = 0;
        for (int i = offset; i < length; ++i) {
            hash = (hash << 5) - hash + byteBuffer.get(i);
        }
        return hash;
    }

    public static int hashTime31(String str, int offset, int length, int seed) {
        int hash = seed;
        for (int i = offset; i < length; ++i) {
            hash = (hash << 5) - hash + str.charAt(i);
        }
        return hash;
    }

    public static int hashTime31(String str, int offset, int length) {
        return THash.hashTime31(str, offset, length, 0);
    }

    public static int hashTime31(String ... strs) {
        int hash = 0;
        for (int i = 0; i < strs.length; ++i) {
            String val = strs[i];
            if (val == null) continue;
            hash += THash.hashTime31(val, 0, val.length(), hash);
        }
        return hash;
    }
}

