/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.security;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.voovan.tools.TObject;

public class TBase58 {
    public static final BigInteger BASE = BigInteger.valueOf(58L);
    public static final int BLOCK_LENGTH_BYTES = 29;
    public static final int BLOCK_LENGTH_DIGITS = 128;
    public static final List<Character> ALPHABET = TObject.asList(Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));

    public static String encode(byte[] source) {
        BigInteger dividend;
        if (source.length == 0) {
            return "";
        }
        if (source[0] >= 0) {
            dividend = new BigInteger(source);
        } else {
            byte[] paddedSource = new byte[source.length + 1];
            System.arraycopy(source, 0, paddedSource, 1, source.length);
            dividend = new BigInteger(paddedSource);
        }
        if (dividend.equals(BigInteger.ZERO)) {
            return "1";
        }
        StringBuilder sb = new StringBuilder();
        while (dividend.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] qr = dividend.divideAndRemainder(BASE);
            int base58DigitValue = qr[1].intValue();
            sb.append(ALPHABET.get(base58DigitValue));
            dividend = qr[0];
        }
        return sb.reverse().toString();
    }

    public static byte[] decode(String source) {
        BigInteger value = BigInteger.ZERO;
        Iterator<Character> it = TBase58.stringIterator(source);
        while (it.hasNext()) {
            value = value.add(BigInteger.valueOf(ALPHABET.indexOf(it.next())));
            if (!it.hasNext()) continue;
            value = value.multiply(BASE);
        }
        return value.toByteArray();
    }

    private static Iterator<Character> stringIterator(final String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Iterator<Character>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < string.length();
            }

            @Override
            public Character next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Character.valueOf(string.charAt(this.index++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

