/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.security;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class Cipher {
    private String algorithm;
    private String mode;
    private String fillMode;
    private SecretKey secretKey;
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public Cipher(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("algorithm may be null");
        }
        this.algorithm = algorithm;
    }

    public Cipher(String algorithm, String mode, String fillMode) throws NoSuchAlgorithmException {
        if (algorithm == null || mode == null || fillMode == null) {
            throw new NoSuchAlgorithmException("algorithm / mode / fillMode may be null");
        }
        this.algorithm = algorithm;
        this.mode = mode;
        this.fillMode = fillMode;
    }

    public byte[] generateSymmetryKey() throws NoSuchAlgorithmException {
        this.secretKey = KeyGenerator.getInstance(this.algorithm).generateKey();
        return this.secretKey.getEncoded();
    }

    public KeyPairStore generatPairKey() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.algorithm);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        KeyPairStore keyPairStore = new KeyPairStore(keyPair.getPublic().getEncoded(), keyPair.getPrivate().getEncoded());
        return keyPairStore;
    }

    public SecretKey loadSymmetryKey(byte[] keyBytes) {
        this.secretKey = new SecretKeySpec(keyBytes, this.algorithm);
        return this.secretKey;
    }

    public PublicKey loadPublicKey(byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm);
        this.publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        return this.publicKey;
    }

    public PrivateKey loadPrivateKey(byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm);
        this.privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        return this.privateKey;
    }

    public byte[] encrypt(byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        String tmp = this.algorithm + (this.mode != null ? "/" + this.mode : "") + (this.fillMode != null ? "/" + this.fillMode : "");
        javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(tmp);
        Key key = null;
        if (this.secretKey != null) {
            key = this.secretKey;
        } else if (this.publicKey != null) {
            key = this.publicKey;
        }
        if (key == null) {
            throw new InvalidKeyException("Avaliable key is not found");
        }
        cipher.init(1, key);
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        String tmp = this.algorithm + (this.mode != null ? "/" + this.mode : "") + (this.fillMode != null ? "/" + this.fillMode : "");
        javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(tmp);
        Key key = null;
        if (this.secretKey != null) {
            key = this.secretKey;
        } else if (this.privateKey != null) {
            key = this.privateKey;
        }
        if (key == null) {
            throw new InvalidKeyException("Avaliable key is not found");
        }
        cipher.init(2, key);
        return cipher.doFinal(data);
    }

    public class KeyPairStore {
        private byte[] publicKey;
        private byte[] privateKey;

        public KeyPairStore(byte[] publicKey, byte[] privateKey) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        public byte[] getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(byte[] publicKey) {
            this.publicKey = publicKey;
        }

        public byte[] getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(byte[] privateKey) {
            this.privateKey = privateKey;
        }
    }
}

