/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.voovan.tools.TDateTime;
import org.voovan.tools.TEnv;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.TUnsafe;
import org.voovan.tools.json.JSON;
import org.voovan.tools.json.annotation.NotJSON;
import org.voovan.tools.reflect.annotation.NotSerialization;

public class TReflect {
    private static Map<String, Field> FIELDS = new ConcurrentHashMap<String, Field>();
    private static Map<String, Method> METHODS = new ConcurrentHashMap<String, Method>();
    private static Map<String, Constructor> CONSTRUCTORS = new ConcurrentHashMap<String, Constructor>();
    private static Map<String, Field[]> FIELD_ARRAYS = new ConcurrentHashMap<String, Field[]>();
    private static Map<String, Method[]> METHOD_ARRAYS = new ConcurrentHashMap<String, Method[]>();
    private static Map<String, Constructor[]> CONSTRUCTOR_ARRAYS = new ConcurrentHashMap<String, Constructor[]>();
    private static Map<String, Boolean> CLASS_HIERARCHY = new ConcurrentHashMap<String, Boolean>();
    public static final Object SINGLE_VALUE_KEY = new Object();
    private static List<String> systemPackages = TObject.asList("java.", "jdk.", "sun.", "javax.", "com.sun", "com.oracle", "javassist");

    public static Field[] getFields(Class<?> clazz) {
        String marker = clazz.getCanonicalName();
        Field[] fields = FIELD_ARRAYS.get(marker);
        if (fields == null) {
            LinkedHashSet<Field> fieldArray = new LinkedHashSet<Field>();
            while (clazz != null && clazz != Object.class) {
                Field[] tmpFields = clazz.getDeclaredFields();
                fieldArray.addAll(Arrays.asList(tmpFields));
                clazz = clazz.getSuperclass();
            }
            fields = fieldArray.toArray(new Field[0]);
            if (marker != null && fields != null) {
                FIELD_ARRAYS.put(marker, fields);
                fieldArray.clear();
            }
        }
        return fields;
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        String mark = clazz.getCanonicalName() + '#' + fieldName;
        Field field = FIELDS.get(mark);
        if (field == null) {
            while (clazz != null && clazz != Object.class) {
                try {
                    field = clazz.getDeclaredField(fieldName);
                    break;
                }
                catch (ReflectiveOperationException e) {
                    field = null;
                    clazz = clazz.getSuperclass();
                }
            }
            if (mark != null && field != null) {
                FIELDS.put(mark, field);
            }
        }
        return field;
    }

    public static Field findFieldIgnoreCase(Class<?> clazz, String fieldName) throws ReflectiveOperationException {
        String marker = clazz.getCanonicalName() + '#' + fieldName;
        Field field = FIELDS.get(marker);
        if (field == null) {
            for (Field fieldItem : TReflect.getFields(clazz)) {
                if (!fieldItem.getName().equalsIgnoreCase(fieldName) && !fieldItem.getName().equalsIgnoreCase(TString.underlineToCamel(fieldName)) || marker == null || fieldItem == null) continue;
                FIELDS.put(marker, fieldItem);
                field = fieldItem;
                break;
            }
        }
        return field;
    }

    public static Class[] getGenericClass(Type type) {
        ParameterizedType parameterizedType = null;
        if (type instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)type;
        }
        if (parameterizedType == null) {
            return null;
        }
        Class[] result = null;
        Type[] actualType = parameterizedType.getActualTypeArguments();
        result = new Class[actualType.length];
        for (int i = 0; i < actualType.length; ++i) {
            if (actualType[i] instanceof Class) {
                result[i] = (Class)actualType[i];
                continue;
            }
            if (actualType[i] instanceof Type) {
                String classStr = actualType[i].toString();
                classStr = TString.fastReplaceAll(classStr, "<.*>", "");
                try {
                    result[i] = Class.forName(classStr);
                }
                catch (Exception e) {
                    result[i] = Object.class;
                }
                continue;
            }
            result[i] = Object.class;
        }
        return result;
    }

    public static Class[] getGenericClass(Object object) {
        Class[] genericClazzs = TReflect.getGenericClass(object.getClass());
        if (genericClazzs == null) {
            if (object instanceof Map) {
                if (((Map)object).size() > 0) {
                    Map.Entry entry = ((Map)object).entrySet().iterator().next();
                    genericClazzs = new Class[]{entry.getKey().getClass(), entry.getValue().getClass()};
                }
            } else if (object instanceof Collection && ((Collection)object).size() > 0) {
                Object obj = ((Collection)object).iterator().next();
                genericClazzs = new Class[]{obj.getClass()};
            }
        }
        return genericClazzs;
    }

    public static Class[] getFieldGenericType(Field field) {
        Type fieldType = field.getGenericType();
        return TReflect.getGenericClass((ParameterizedType)fieldType);
    }

    public static <T> T getFieldValue(Object obj, String fieldName) throws ReflectiveOperationException {
        Field field = TReflect.findField(obj.getClass(), fieldName);
        field.setAccessible(true);
        return (T)field.get(obj);
    }

    public static void setFieldValue(Object obj, Field field, Object fieldValue) throws ReflectiveOperationException {
        field.setAccessible(true);
        field.set(obj, fieldValue);
    }

    public static void setFieldValue(Object obj, String fieldName, Object fieldValue) throws ReflectiveOperationException {
        Field field = TReflect.findField(obj.getClass(), fieldName);
        TReflect.setFieldValue(obj, field, fieldValue);
    }

    public static Map<Field, Object> getFieldValues(Object obj) throws ReflectiveOperationException {
        Field[] fields;
        LinkedHashMap<Field, Object> result = new LinkedHashMap<Field, Object>();
        for (Field field : fields = TReflect.getFields(obj.getClass())) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Object value = field.get(obj);
            result.put(field, value);
        }
        return result;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        StringBuilder markBuilder = new StringBuilder(clazz.getCanonicalName()).append('#').append(name);
        for (Class<?> paramType : paramTypes) {
            markBuilder.append("$").append(paramType.getCanonicalName());
        }
        String marker = markBuilder.toString();
        Method method = METHODS.get(marker);
        if (method == null) {
            while (clazz != null && clazz != Object.class) {
                try {
                    method = clazz.getDeclaredMethod(name, paramTypes);
                    break;
                }
                catch (ReflectiveOperationException e) {
                    method = null;
                    clazz = clazz.getSuperclass();
                }
            }
            if (marker != null && method != null) {
                METHODS.put(marker, method);
            }
        }
        return method;
    }

    public static Method[] findMethod(Class<?> clazz, String name, int paramCount) {
        String marker = clazz.getCanonicalName() + '#' + name + '@' + paramCount;
        Method[] methods = METHOD_ARRAYS.get(marker);
        if (methods == null) {
            Method[] allMethods;
            LinkedHashSet<Method> methodList = new LinkedHashSet<Method>();
            for (Method method : allMethods = TReflect.getMethods(clazz, name)) {
                if (method.getParameterTypes().length != paramCount) continue;
                methodList.add(method);
            }
            methods = methodList.toArray(new Method[0]);
            if (marker != null && methods != null) {
                METHOD_ARRAYS.put(marker, methods);
                methodList.clear();
            }
        }
        return methods;
    }

    public static Method[] getMethods(Class<?> clazz) {
        Method[] methods = null;
        String marker = clazz.getCanonicalName();
        methods = METHOD_ARRAYS.get(marker);
        if (methods == null) {
            LinkedHashSet<Method> methodList = new LinkedHashSet<Method>();
            while (clazz != null && clazz != Object.class) {
                Method[] tmpMethods = clazz.getDeclaredMethods();
                methodList.addAll(Arrays.asList(tmpMethods));
                clazz = clazz.getSuperclass();
            }
            methods = methodList.toArray(new Method[0]);
            if (marker != null && methods != null) {
                METHOD_ARRAYS.put(marker, methods);
                methodList.clear();
            }
        }
        return methods;
    }

    public static Method[] getMethods(Class<?> clazz, String name) {
        Method[] methods = null;
        String marker = clazz.getCanonicalName() + '#' + name;
        methods = METHOD_ARRAYS.get(marker);
        if (methods == null) {
            Method[] allMethods;
            LinkedHashSet<Method> methodList = new LinkedHashSet<Method>();
            for (Method method : allMethods = TReflect.getMethods(clazz)) {
                if (!method.getName().equals(name)) continue;
                methodList.add(method);
            }
            methods = methodList.toArray(new Method[0]);
            if (marker != null && methods != null) {
                METHOD_ARRAYS.put(marker, methods);
                methodList.clear();
            }
        }
        return methods;
    }

    public static Class[] getMethodParameterGenericType(Method method, int parameterIndex) {
        Object result = null;
        Type parameterType = parameterIndex == -1 ? method.getGenericReturnType() : method.getGenericParameterTypes()[parameterIndex];
        return TReflect.getGenericClass(parameterType);
    }

    public static <T> T invokeMethod(Object obj, Method method, Object ... parameters) throws ReflectiveOperationException {
        method.setAccessible(true);
        return (T)method.invoke(obj, parameters);
    }

    public static <T> T invokeMethod(Object obj, String name, Object ... args) throws ReflectiveOperationException {
        if (args == null) {
            args = new Object[]{};
        }
        Class<?>[] parameterTypes = TReflect.getArrayClasses(args);
        Method method = null;
        Class<?> objClass = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        try {
            method = TReflect.findMethod(objClass, name, parameterTypes);
            method.setAccessible(true);
            return (T)method.invoke(obj, args);
        }
        catch (Exception e) {
            Exception lastExecption = e;
            if (e instanceof NoSuchMethodException || method == null) {
                Method[] methods;
                for (Method similarMethod : methods = TReflect.findMethod(objClass, name, parameterTypes.length)) {
                    Type[] methodParamTypes = similarMethod.getGenericParameterTypes();
                    if (methodParamTypes.length != args.length) continue;
                    try {
                        return (T)similarMethod.invoke(obj, args);
                    }
                    catch (Exception exception) {
                        try {
                            Object[] convertedParams = new Object[args.length];
                            for (int i = 0; i < methodParamTypes.length; ++i) {
                                Object parameterType = methodParamTypes[i];
                                if (parameterType instanceof TypeVariable) {
                                    parameterType = Object.class;
                                }
                                String value = "";
                                if (parameterType != Object.class && args[i] != null) {
                                    Class<?> argClass = args[i].getClass();
                                    if (args[i] instanceof Collection || args[i] instanceof Map || argClass.isArray() || !TReflect.isBasicType(argClass)) {
                                        if (argClass.isArray() && TReflect.isBasicType(argClass.getComponentType())) {
                                            convertedParams[i] = args[i];
                                            continue;
                                        }
                                        value = JSON.toJSON(args[i]);
                                    } else {
                                        value = args[i].toString();
                                    }
                                    convertedParams[i] = TString.toObject(value, (Type)parameterType);
                                    continue;
                                }
                                convertedParams[i] = args[i];
                            }
                            method = similarMethod;
                            method.setAccessible(true);
                            return (T)method.invoke(obj, convertedParams);
                        }
                        catch (Exception ex) {
                            lastExecption = ex;
                        }
                    }
                }
            }
            if (!(lastExecption instanceof ReflectiveOperationException)) {
                lastExecption = new ReflectiveOperationException(lastExecption.getMessage(), lastExecption);
            }
            throw (ReflectiveOperationException)lastExecption;
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) throws ReflectiveOperationException {
        if (args == null) {
            args = new Object[]{};
        }
        Class<Object> targetClazz = clazz;
        if (TReflect.isImpByInterface(clazz, List.class) && (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()))) {
            targetClazz = ArrayList.class;
        }
        if (TReflect.isImpByInterface(clazz, Set.class) && (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()))) {
            targetClazz = LinkedHashSet.class;
        }
        if (TReflect.isImpByInterface(clazz, Map.class) && Modifier.isAbstract(clazz.getModifiers()) && Modifier.isInterface(clazz.getModifiers())) {
            targetClazz = LinkedHashMap.class;
        }
        Class<?>[] parameterTypes = TReflect.getArrayClasses(args);
        StringBuilder markBuilder = new StringBuilder(targetClazz.getCanonicalName());
        for (Class<?> paramType : parameterTypes) {
            markBuilder.append("$").append(paramType.getCanonicalName());
        }
        String mark = markBuilder.toString();
        Constructor constructor = CONSTRUCTORS.get(mark);
        try {
            if (constructor == null) {
                if (args.length == 0) {
                    try {
                        constructor = targetClazz.getConstructor(new Class[0]);
                    }
                    catch (Exception e) {
                        return (T)TUnsafe.getUnsafe().allocateInstance(targetClazz);
                    }
                } else {
                    constructor = targetClazz.getConstructor(parameterTypes);
                }
                if (mark != null && constructor != null) {
                    CONSTRUCTORS.put(mark, constructor);
                }
            }
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            Exception lastExecption = e;
            if (constructor == null) {
                mark = targetClazz.getCanonicalName();
                Constructor[] constructors = CONSTRUCTOR_ARRAYS.get(mark);
                if (constructors == null) {
                    constructors = targetClazz.getConstructors();
                    if (mark != null && constructor != null) {
                        CONSTRUCTOR_ARRAYS.put(mark, constructors);
                    }
                }
                for (Constructor similarConstructor : constructors) {
                    Class<?>[] methodParamTypes = similarConstructor.getParameterTypes();
                    if (methodParamTypes.length != args.length) continue;
                    try {
                        return similarConstructor.newInstance(args);
                    }
                    catch (Exception exception) {
                        try {
                            Object[] convertedParams = new Object[args.length];
                            for (int i = 0; i < methodParamTypes.length; ++i) {
                                Class<?> parameterType = methodParamTypes[i];
                                String value = "";
                                Class<?> parameterClass = args[i].getClass();
                                value = args[i] instanceof Collection || args[i] instanceof Map || parameterClass.isArray() || !TReflect.isBasicType(parameterClass) ? JSON.toJSON(args[i]) : args[i].toString();
                                convertedParams[i] = TString.toObject(value, parameterType);
                            }
                            constructor = similarConstructor;
                            return constructor.newInstance(convertedParams);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
            }
            if (!(lastExecption instanceof ReflectiveOperationException)) {
                lastExecption = new ReflectiveOperationException(lastExecption.getMessage(), lastExecption);
            }
            try {
                return (T)TReflect.allocateInstance(targetClazz);
            }
            catch (Exception ex) {
                throw e;
            }
        }
    }

    public static <T> T newInstance(String className, Object ... parameters) throws ReflectiveOperationException {
        Class<?> clazz = Class.forName(className);
        return (T)TReflect.newInstance(clazz, parameters);
    }

    public static <T> T allocateInstance(Class<T> clazz) throws InstantiationException {
        return (T)TUnsafe.getUnsafe().allocateInstance(clazz);
    }

    public static Class<?>[] getArrayClasses(Object[] objs) {
        if (objs == null) {
            return new Class[0];
        }
        Class[] parameterTypes = new Class[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            parameterTypes[i] = objs[i] == null ? Object.class : objs[i].getClass();
        }
        return parameterTypes;
    }

    public static <T> T getObjectFromMap(Type type, Map<String, ?> mapArg, boolean ignoreCase) throws ParseException, ReflectiveOperationException {
        Class[] genericType = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            genericType = TReflect.getGenericClass(parameterizedType);
        }
        return TReflect.getObjectFromMap(type, mapArg, genericType, ignoreCase);
    }

    public static <T> T getObjectFromMap(Type type, Map<String, ?> mapArg, Class[] genericType, boolean ignoreCase) throws ReflectiveOperationException, ParseException {
        Map<String, Object> obj = null;
        Class clazz = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            clazz = (Class)parameterizedType.getRawType();
        } else if (type instanceof Class) {
            clazz = (Class)type;
        }
        if (mapArg == null) {
            return null;
        }
        Map<String, Object> singleValue = mapArg;
        if (mapArg.containsKey(SINGLE_VALUE_KEY)) {
            singleValue = mapArg.get(SINGLE_VALUE_KEY);
        } else if (mapArg.size() == 1) {
            singleValue = mapArg.values().iterator().next();
        }
        if (clazz == Object.class) {
            obj = mapArg.containsKey(SINGLE_VALUE_KEY) ? singleValue : mapArg;
        } else if (clazz.isPrimitive()) {
            obj = singleValue != null && singleValue.getClass() != clazz ? TString.toObject(singleValue.toString(), clazz) : singleValue;
        } else if (TReflect.isBasicType(clazz)) {
            obj = singleValue == null ? null : TReflect.newInstance(clazz, singleValue.toString());
        } else if (clazz == BigDecimal.class) {
            String value = singleValue == null ? null : singleValue.toString();
            obj = singleValue == null ? null : new BigDecimal(value);
        } else if (clazz == AtomicLong.class || clazz == AtomicInteger.class || clazz == AtomicBoolean.class) {
            obj = singleValue == null ? null : TReflect.newInstance(clazz, singleValue);
        } else if (TReflect.isExtendsByClass(clazz, Date.class)) {
            String value = singleValue == null ? null : singleValue.toString();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date dateObj = singleValue != null ? dateFormat.parse(value.toString()) : null;
            obj = TReflect.newInstance(clazz, dateObj.getTime());
        } else if (TReflect.isImpByInterface(clazz, Map.class)) {
            Map mapObject = (Map)TReflect.newInstance(clazz, new Object[0]);
            if (genericType != null) {
                for (Map.Entry<String, ?> entry : mapArg.entrySet()) {
                    Map keyOfMap = null;
                    Map valueOfMap = null;
                    keyOfMap = entry.getKey() instanceof Map ? (Map)((Object)entry.getKey()) : TObject.asMap(SINGLE_VALUE_KEY, entry.getKey());
                    valueOfMap = entry.getValue() instanceof Map ? (Map)entry.getValue() : TObject.asMap(SINGLE_VALUE_KEY, entry.getValue());
                    T keyObj = TReflect.getObjectFromMap(genericType[0], keyOfMap, ignoreCase);
                    T valueObj = TReflect.getObjectFromMap(genericType[1], valueOfMap, ignoreCase);
                    mapObject.put(keyObj, valueObj);
                }
            } else {
                mapObject.putAll(mapArg);
            }
            obj = mapObject;
        } else if (TReflect.isImpByInterface(clazz, Collection.class)) {
            Collection collectionObject = (Collection)TReflect.newInstance(clazz, new Object[0]);
            if (singleValue != null) {
                if (genericType != null) {
                    for (Object listItem : (Collection)((Object)singleValue)) {
                        Map valueOfMap = null;
                        valueOfMap = listItem instanceof Map ? (Map)listItem : TObject.asMap(SINGLE_VALUE_KEY, listItem);
                        T item = TReflect.getObjectFromMap(genericType[0], valueOfMap, ignoreCase);
                        collectionObject.add(item);
                    }
                } else {
                    collectionObject.addAll((Collection)((Object)singleValue));
                }
            }
            obj = collectionObject;
        } else {
            if (clazz.isArray()) {
                Class<?> arrayClass = clazz.getComponentType();
                Object tempArrayObj = Array.newInstance(arrayClass, 0);
                return (T)((Collection)((Object)singleValue)).toArray((Object[])tempArrayObj);
            }
            try {
                obj = TReflect.newInstance(clazz, new Object[0]);
            }
            catch (InstantiationException e) {
                return null;
            }
            for (Map.Entry<String, ?> argEntry : mapArg.entrySet()) {
                String key = argEntry.getKey();
                Object value = argEntry.getValue();
                Field field = null;
                field = ignoreCase ? TReflect.findFieldIgnoreCase(clazz, key) : TReflect.findField(clazz, key);
                if (field == null || Modifier.isFinal(field.getModifiers())) continue;
                String fieldName = field.getName();
                Class<?> fieldType = field.getType();
                Type fieldGenericType = field.getGenericType();
                try {
                    if (value != null && fieldType != value.getClass()) {
                        if (value instanceof String && (TReflect.isImpByInterface(fieldType, Map.class) || TReflect.isImpByInterface(fieldType, Collection.class) || !TReflect.isBasicType(fieldType))) {
                            value = TString.toObject(value.toString(), fieldType);
                        } else if (TReflect.isImpByInterface(fieldType, Map.class) && value instanceof Map) {
                            value = TReflect.getObjectFromMap(fieldGenericType, (Map)value, ignoreCase);
                        } else if (TReflect.isImpByInterface(fieldType, Collection.class) && value instanceof Collection) {
                            value = TReflect.getObjectFromMap(fieldGenericType, TObject.asMap(SINGLE_VALUE_KEY, value), ignoreCase);
                        } else if (!TReflect.isImpByInterface(fieldType, Map.class)) {
                            value = value instanceof Map ? TReflect.getObjectFromMap(fieldType, (Map)value, ignoreCase) : TReflect.getObjectFromMap(fieldType, TObject.asMap(SINGLE_VALUE_KEY, value), ignoreCase);
                        } else {
                            throw new ReflectiveOperationException("Conver field object error! Exception type: " + fieldType.getName() + ", Object type: " + value.getClass().getName());
                        }
                    }
                    TReflect.setFieldValue((Object)obj, fieldName, value);
                }
                catch (Exception e) {
                    throw new ReflectiveOperationException("Fill object " + obj.getClass().getCanonicalName() + '#' + fieldName + " failed", e);
                }
            }
        }
        return (T)obj;
    }

    public static Map<String, Object> getMapfromObject(Object obj) throws ReflectiveOperationException {
        return TReflect.getMapfromObject(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getMapfromObject(Object obj, boolean allField) throws ReflectiveOperationException {
        LinkedHashMap<String, Object> mapResult = new LinkedHashMap<String, Object>();
        if (obj == null || TReflect.isBasicType(obj.getClass())) {
            mapResult.put(null, obj);
        } else if (TReflect.isExtendsByClass(obj.getClass(), Date.class)) {
            mapResult.put(null, TDateTime.format((Date)obj, "yyyy-MM-dd HH:mm:ss"));
        } else if (obj instanceof Collection) {
            ArrayList<Object> collection = new ArrayList<Object>();
            Object object = obj;
            synchronized (object) {
                Object[] objectArray;
                for (Object collectionItem : objectArray = ((Collection)obj).toArray(new Object[0])) {
                    Map<String, Object> item = TReflect.getMapfromObject(collectionItem, allField);
                    collection.add(item.size() == 1 && item.containsKey(null) ? item.get(null) : item);
                }
            }
            mapResult.put(null, collection);
        } else if (obj.getClass().isArray()) {
            Class<?> arrayClass = obj.getClass().getComponentType();
            Object targetArray = Array.newInstance(arrayClass, Array.getLength(obj));
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Object arrayItem = Array.get(obj, i);
                Map<String, Object> item = TReflect.getMapfromObject(arrayItem, allField);
                Array.set(targetArray, i, item.size() == 1 && item.containsKey(null) ? item.get(null) : item);
            }
            mapResult.put(null, targetArray);
        } else if (obj instanceof AtomicLong || obj instanceof AtomicInteger || obj instanceof AtomicBoolean) {
            mapResult.put(null, TReflect.invokeMethod(obj, "getThread", new Object[0]));
        } else if (obj instanceof BigDecimal) {
            if (BigDecimal.ZERO.compareTo((BigDecimal)obj) == 0) {
                obj = BigDecimal.ZERO;
            }
            mapResult.put(null, ((BigDecimal)obj).toPlainString());
        } else if (obj instanceof Map) {
            Map mapObject = (Map)obj;
            LinkedHashMap<Map<String, Object>, Map<String, Object>> map = new LinkedHashMap<Map<String, Object>, Map<String, Object>>();
            Object i = obj;
            synchronized (i) {
                for (Map.Entry entry : mapObject.entrySet()) {
                    Map<String, Object> keyItem = TReflect.getMapfromObject(entry.getKey(), allField);
                    Map<String, Object> valueItem = TReflect.getMapfromObject(entry.getValue(), allField);
                    Map<String, Object> key = keyItem.size() == 1 && keyItem.containsKey(null) ? keyItem.get(null) : keyItem;
                    Map<String, Object> value = valueItem.size() == 1 && valueItem.containsKey(null) ? valueItem.get(null) : valueItem;
                    map.put(key, value);
                }
            }
            mapResult.put(null, map);
        } else {
            Map<Field, Object> fieldValues = TReflect.getFieldValues(obj);
            for (Map.Entry<Field, Object> entry : fieldValues.entrySet()) {
                Field field = entry.getKey();
                if (!allField && (field.getAnnotation(NotSerialization.class) != null || field.getAnnotation(NotJSON.class) != null && TEnv.classInCurrentStack(".tools.json.", null))) continue;
                String key = entry.getKey().getName();
                Object value = entry.getValue();
                if (value == null) {
                    if (mapResult.get(key) != null) continue;
                    mapResult.put(key, value);
                    continue;
                }
                if (key.contains("$")) continue;
                Class<?> valueClass = entry.getValue().getClass();
                if (TReflect.isBasicType(valueClass)) {
                    if (mapResult.get(key) != null) continue;
                    mapResult.put(key, value);
                    continue;
                }
                Map<String, Object> resultMap = TReflect.getMapfromObject(value, allField);
                if (resultMap.size() == 1 && resultMap.containsKey(null)) {
                    mapResult.put(key, resultMap.get(null));
                    continue;
                }
                mapResult.put(key, resultMap);
            }
        }
        return mapResult;
    }

    public static boolean isImpByInterface(Class<?> type, Class<?> interfaceClass) {
        if (type == interfaceClass && interfaceClass.isInterface()) {
            return true;
        }
        return interfaceClass.isAssignableFrom(type);
    }

    public static boolean isExtendsByClass(Class<?> type, Class<?> extendsClass) {
        if (type == extendsClass && !extendsClass.isInterface()) {
            return true;
        }
        return extendsClass.isAssignableFrom(type);
    }

    public static boolean classChecker(Class clazz, Class[] filters) {
        int matchCount = 0;
        List annotations = TObject.asList(clazz.getAnnotations());
        if (clazz.isAnonymousClass()) {
            return false;
        }
        for (Class filterClazz : filters) {
            if (clazz == filterClazz) break;
            if (filterClazz.isAnnotation() && clazz.isAnnotationPresent(filterClazz)) {
                ++matchCount;
                continue;
            }
            if (filterClazz.isInterface() && TReflect.isImpByInterface(clazz, filterClazz)) {
                ++matchCount;
                continue;
            }
            if (!TReflect.isExtendsByClass(clazz, filterClazz)) continue;
            ++matchCount;
        }
        return matchCount >= filters.length;
    }

    public static Class[] getAllExtendAndInterfaceClass(Class<?> type) {
        if (type == null) {
            return null;
        }
        LinkedHashSet classes = new LinkedHashSet();
        Class<?> superClass = type;
        do {
            superClass = superClass.getSuperclass();
            classes.addAll(Arrays.asList(superClass.getInterfaces()));
            classes.add(superClass);
        } while (superClass != null && Object.class != superClass);
        return classes.toArray(new Class[0]);
    }

    public static String getClazzJSONModel(Class clazz) {
        StringBuilder jsonStrBuilder = new StringBuilder();
        if (TReflect.isBasicType(clazz)) {
            jsonStrBuilder.append(clazz.getName());
        } else if (clazz.isArray()) {
            String clazzName = clazz.getCanonicalName();
            clazzName = clazzName.substring(clazzName.lastIndexOf(".") + 1, clazzName.length() - 2) + "[]";
            jsonStrBuilder.append(clazzName);
        } else {
            jsonStrBuilder.append("{");
            for (Field field : TReflect.getFields(clazz)) {
                jsonStrBuilder.append("\"");
                jsonStrBuilder.append(field.getName());
                jsonStrBuilder.append("\"").append(":");
                String filedValueModel = TReflect.getClazzJSONModel(field.getType());
                if (filedValueModel.startsWith("{") && filedValueModel.endsWith("}")) {
                    jsonStrBuilder.append(filedValueModel);
                    jsonStrBuilder.append(",");
                    continue;
                }
                if (filedValueModel.startsWith("[") && filedValueModel.endsWith("]")) {
                    jsonStrBuilder.append(filedValueModel);
                    jsonStrBuilder.append(",");
                    continue;
                }
                jsonStrBuilder.append("\"");
                jsonStrBuilder.append(filedValueModel);
                jsonStrBuilder.append("\"").append(",");
            }
            jsonStrBuilder.deleteCharAt(jsonStrBuilder.length() - 1);
            jsonStrBuilder.append("}");
        }
        return jsonStrBuilder.toString();
    }

    public static Map<String, Object> fieldFilter(Object obj, String ... fields) {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        for (String fieldFilter : fields) {
            int firstIndex = fieldFilter.indexOf("[");
            String field = firstIndex == -1 ? fieldFilter : fieldFilter.substring(0, firstIndex);
            LinkedHashMap<String, Object> value = null;
            if (obj instanceof Map) {
                Map paramMap = (Map)obj;
                value = (LinkedHashMap<String, Object>)paramMap.get(field);
            } else if (obj.getClass().isArray() || obj instanceof List) {
                if (obj.getClass().isArray()) {
                    obj = TObject.asList((Object[])obj);
                }
                for (Object subObj : (List)obj) {
                    TReflect.fieldFilter(subObj, fields);
                }
            } else {
                try {
                    value = (LinkedHashMap<String, Object>)TReflect.getFieldValue(obj, field);
                }
                catch (ReflectiveOperationException e) {
                    value = null;
                }
            }
            if (firstIndex > 1) {
                String[] subFieldArray;
                LinkedHashMap<String, Object> subResultMap = new LinkedHashMap<String, Object>();
                String subFieldStr = fieldFilter.substring(firstIndex);
                subFieldStr = TString.removeSuffix(subFieldStr);
                subFieldStr = TString.removePrefix(subFieldStr);
                for (String subField : subFieldArray = subFieldStr.split(",")) {
                    Map<String, Object> data = TReflect.fieldFilter(value, subField);
                    subResultMap.putAll(data);
                }
                value = subResultMap;
            }
            resultMap.put(field, value);
        }
        return resultMap;
    }

    public static boolean isBasicType(Class clazz) {
        return clazz == null || clazz.isPrimitive() || clazz.getName().startsWith("java.lang");
    }

    public static boolean isSystemType(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        for (String systemPackage : systemPackages) {
            if (!clazz.getCanonicalName().startsWith(systemPackage)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSystemType(String className) {
        if (className.indexOf(".") == -1) {
            return true;
        }
        for (String systemPackage : systemPackages) {
            if (!className.startsWith(systemPackage)) continue;
            return true;
        }
        return false;
    }

    public static String getPackageType(String primitiveType) {
        switch (primitiveType) {
            case "int": {
                return "java.lang.Integer";
            }
            case "byte": {
                return "java.lang.Byte";
            }
            case "short": {
                return "java.lang.Short";
            }
            case "long": {
                return "java.lang.Long";
            }
            case "float": {
                return "java.lang.Float";
            }
            case "double": {
                return "java.lang.Double";
            }
            case "char": {
                return "java.lang.Character";
            }
            case "boolean": {
                return "java.lang.Boolean";
            }
        }
        return null;
    }
}

