/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.log;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.tools.TFile;
import org.voovan.tools.log.Logger;
import org.voovan.tools.log.LoggerThread;

public class SingleLogger {
    private String fileName;
    private LoggerThread loggerThread;
    private static volatile Map<String, SingleLogger> singleLoggerPool = new ConcurrentHashMap<String, SingleLogger>();

    public SingleLogger(String fileName) {
        this.fileName = fileName;
        TFile.mkdir(fileName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setLoggerThread(LoggerThread loggerThread) {
        this.loggerThread = loggerThread;
    }

    public boolean isFinished() {
        return this.loggerThread.isFinished();
    }

    public void addLogMessage(String msg) {
        this.loggerThread.addLogMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SingleLogger writeLog(String fileName, String msg) {
        SingleLogger singleLog = null;
        if (!singleLoggerPool.containsKey(fileName) || singleLoggerPool.get(fileName).isFinished()) {
            try {
                singleLog = new SingleLogger(fileName);
                FileOutputStream outputStream = null;
                outputStream = new FileOutputStream(fileName, true);
                LoggerThread loggerThread = LoggerThread.start(new OutputStream[]{outputStream});
                singleLog.setLoggerThread(loggerThread);
                Map<String, SingleLogger> map = singleLoggerPool;
                synchronized (map) {
                    singleLoggerPool.put(fileName, singleLog);
                }
            }
            catch (FileNotFoundException e) {
                Logger.error("[SingleLogger] log file " + fileName + " not found.", e);
            }
        } else {
            singleLog = singleLoggerPool.get(fileName);
        }
        if (singleLog != null) {
            singleLog.addLogMessage(msg);
        }
        return singleLog;
    }
}

