/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.voovan.tools.TEnv;
import org.voovan.tools.TString;
import org.voovan.tools.log.Logger;
import org.voovan.tools.log.LoggerStatic;

public class LoggerThread
implements Runnable {
    private ConcurrentLinkedDeque<String> logQueue;
    private OutputStream[] outputStreams;
    private volatile AtomicBoolean finished = new AtomicBoolean(false);
    private volatile int pause = 0;

    public LoggerThread(OutputStream[] outputStreams) {
        this.logQueue = new ConcurrentLinkedDeque();
        this.outputStreams = outputStreams;
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public boolean pause() {
        this.pause = 1;
        try {
            TEnv.wait(3000, () -> this.pause != 2);
            return true;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void unpause() {
        this.pause = 0;
    }

    public OutputStream[] getOutputStreams() {
        return this.outputStreams;
    }

    public void setOutputStreams(OutputStream[] outputStreams) {
        this.outputStreams = outputStreams;
    }

    public void closeAllOutputStreams() {
        try {
            for (OutputStream outputStream : this.outputStreams) {
                if (outputStream == null) continue;
                outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        for (OutputStream outputStream : this.outputStreams) {
            if (outputStream == null) continue;
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addLogMessage(String msg) {
        this.logQueue.offer(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String formatedMessage = null;
        Thread mainThread = TEnv.getMainThread();
        boolean needFlush = false;
        try {
            while (Logger.isEnable()) {
                if (this.pause == 1) {
                    this.flush();
                    this.pause = 2;
                }
                if (this.pause != 0) {
                    Thread.sleep(1L);
                    continue;
                }
                formatedMessage = this.logQueue.poll();
                if (formatedMessage == null) {
                    if (needFlush) {
                        this.flush();
                        needFlush = false;
                    }
                    Thread.sleep(1L);
                    continue;
                }
                if (formatedMessage != null && this.outputStreams != null) {
                    for (OutputStream outputStream : this.outputStreams) {
                        if (outputStream == null) continue;
                        if (LoggerStatic.HAS_COLOR && !(outputStream instanceof PrintStream)) {
                            formatedMessage = TString.fastReplaceAll(formatedMessage, "\u001b\\[\\d{2}m", "");
                        }
                        outputStream.write(formatedMessage.getBytes());
                        needFlush = true;
                    }
                }
                if (mainThread != null) continue;
            }
            System.out.println("[FRAMEWORK] Main logger thread is terminaled");
            this.finished.set(true);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            try {
                for (OutputStream outputStream : this.outputStreams) {
                    if (outputStream == null) continue;
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized LoggerThread start(OutputStream[] outputStreams) {
        LoggerThread loggerThread = new LoggerThread(outputStreams);
        Thread loggerMainThread = new Thread((Runnable)loggerThread, "VOOVAN@LOGGER_THREAD");
        loggerMainThread.setDaemon(true);
        loggerMainThread.start();
        return loggerThread;
    }
}

