/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.log;

import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.log.Formater;
import org.voovan.tools.log.Message;

public class Logger {
    private static Formater formater = Formater.newInstance();
    private static boolean enable = true;

    public static boolean isEnable() {
        return enable;
    }

    public static void setEnable(boolean enable) {
        Logger.enable = enable;
    }

    public static void stopLoggerThread() {
    }

    public static boolean isLogLevel(String logLevel) {
        if (formater.getLogLevel().contains("ALL")) {
            return true;
        }
        return formater.getLogLevel().contains(logLevel);
    }

    public static void info(Object msg) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            msg = Logger.buildMessage(msg);
            Message message = Message.newInstance("INFO", msg.toString());
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + msg);
        }
    }

    public static void infof(String msg, Object ... args) {
        if (!Logger.isEnable()) {
            return;
        }
        Logger.info(TString.tokenReplace(msg, args));
    }

    public static void fremawork(Object msg) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            msg = Logger.buildMessage(msg);
            Message message = Message.newInstance("FRAMEWORK", msg.toString());
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + msg);
        }
    }

    public static void fremaworkf(String msg, Object ... args) {
        if (!Logger.isEnable()) {
            return;
        }
        Logger.info(TString.tokenReplace(msg, args));
    }

    public static void debug(Object msg) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            msg = Logger.buildMessage(msg);
            Message message = Message.newInstance("DEBUG", msg.toString());
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + msg);
        }
    }

    public static void debugf(String msg, Object ... args) {
        if (!Logger.isEnable()) {
            return;
        }
        Logger.debug(TString.tokenReplace(msg, args));
    }

    public static void warn(Object msg) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            msg = Logger.buildMessage(msg);
            Message message = Message.newInstance("WARN", msg.toString());
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + msg);
        }
    }

    public static void warnf(String msg, Object ... args) {
        if (!Logger.isEnable()) {
            return;
        }
        Logger.warn(TString.tokenReplace(msg, args));
    }

    public static void warn(Exception e) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            String msg = Logger.buildMessage(null, e);
            Message message = Message.newInstance("WARN", msg);
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + e.getMessage());
        }
    }

    public static void warn(Object msg, Exception e) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            String msgStr = Logger.buildMessage(msg, e);
            Message message = Message.newInstance("WARN", msgStr);
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + msg);
        }
    }

    public static void warnf(String msg, Exception e, Object ... args) {
        if (!Logger.isEnable()) {
            return;
        }
        Logger.warn(TString.tokenReplace(msg, args), e);
    }

    public static void error(Object msg) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            msg = Logger.buildMessage(msg, null);
            Message message = Message.newInstance("ERROR", msg.toString());
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + msg);
        }
    }

    public static void errorf(String msg, Object ... args) {
        if (!Logger.isEnable()) {
            return;
        }
        Logger.error(TString.tokenReplace(msg, args));
    }

    public static void error(Exception e) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            String msg = Logger.buildMessage(null, e);
            Message message = Message.newInstance("ERROR", msg);
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + e.getMessage());
        }
    }

    public static void error(Object msg, Exception e) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            String msgStr = Logger.buildMessage(msg, e);
            Message message = Message.newInstance("ERROR", msgStr);
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + msg);
        }
    }

    public static void errorf(String msg, Exception e, Object ... args) {
        if (!Logger.isEnable()) {
            return;
        }
        Logger.error(TString.tokenReplace(msg, args), e);
    }

    public static void fatal(Object msg) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            msg = Logger.buildMessage(msg);
            Message message = Message.newInstance("FATAL", msg.toString());
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + msg);
        }
    }

    public static void fatalf(String msg, Object ... args) {
        if (!Logger.isEnable()) {
            return;
        }
        Logger.fatal(TString.tokenReplace(msg, args));
    }

    public static void fatal(Exception e) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            String msg = Logger.buildMessage(e.getMessage(), e);
            Message message = Message.newInstance("FATAL", msg);
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + e.getMessage());
        }
    }

    public static void fatal(Object msg, Exception e) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            String msgStr = Logger.buildMessage(msg, e);
            Message message = Message.newInstance("FATAL", msgStr);
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            Logger.simple("Logger system error:" + oe.getMessage() + "\r\n");
            Logger.simple(TEnv.getStackElementsMessage(oe.getStackTrace()));
            Logger.simple("Output message is: " + msg);
        }
    }

    public static void fatalf(String msg, Exception e, Object ... args) {
        if (!Logger.isEnable()) {
            return;
        }
        Logger.fatal(TString.tokenReplace(msg, args), e);
    }

    public static void simple(Object msg) {
        if (!Logger.isEnable()) {
            return;
        }
        try {
            msg = Logger.buildMessage(msg);
            Message message = Message.newInstance("SIMPLE", msg.toString());
            formater.writeFormatedLog(message);
        }
        catch (Exception oe) {
            System.out.println("Logger system error:" + oe.getMessage() + "\r\n");
            System.out.println(TEnv.getStackElementsMessage(oe.getStackTrace()));
            System.out.println("Output message is: " + msg);
        }
    }

    public static void simplef(String msg, Object ... args) {
        if (!Logger.isEnable()) {
            return;
        }
        Logger.error(TString.tokenReplace(msg, args));
    }

    private static String buildMessage(Object msg, Throwable exception) {
        msg = TObject.nullDefault(msg, "");
        String stackMessage = "";
        if (exception == null) {
            return msg.toString();
        }
        do {
            stackMessage = stackMessage + exception.getClass().getCanonicalName() + ": " + exception.getMessage() + TFile.getLineSeparator() + TString.indent(TEnv.getStackElementsMessage(exception.getStackTrace()), 8) + TFile.getLineSeparator();
        } while ((exception = exception.getCause()) != null);
        return (msg.toString().isEmpty() ? "" : msg + " => ") + stackMessage;
    }

    private static String buildMessage(Object msg) {
        return Logger.buildMessage(msg, null);
    }
}

