/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.voovan.Global;
import org.voovan.tools.TDateTime;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.TZip;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.log.Logger;
import org.voovan.tools.log.LoggerStatic;
import org.voovan.tools.log.LoggerThread;
import org.voovan.tools.log.Message;

public class Formater {
    private String template;
    private volatile LoggerThread loggerThread;
    private List<String> logLevel;
    private String dateStamp;
    private int maxLineLength = -1;
    private String lineHead;
    private String lineTail;
    private static String DATE = TDateTime.now("yyyyMMdd");

    public Formater(String template) {
        this.template = template;
        this.logLevel = new Vector<String>();
        this.logLevel.addAll(TObject.asList(LoggerStatic.getLogConfig("LogLevel", "ALL").split(",")));
        this.dateStamp = DATE;
        Global.getHashWheelTimer().addTask(new HashWheelTask(){

            @Override
            public void run() {
                if (Logger.isEnable()) {
                    if (!Formater.this.dateStamp.equals(DATE)) {
                        Formater.this.loggerThread.setOutputStreams(Formater.getOutputStreams());
                    }
                    Formater.this.packLogFile();
                }
            }
        }, 1);
    }

    public List<String> getLogLevel() {
        return this.logLevel;
    }

    public static StackTraceElement currentStackLine() {
        StackTraceElement[] stackTraceElements = TEnv.getStackElements();
        return stackTraceElements[6];
    }

    private static String currentThreadName() {
        Thread currentThread = Thread.currentThread();
        return currentThread.getName();
    }

    private int realLength(String str) {
        return str.replaceAll("\\{\\{n\\}\\}", "").replaceAll("\\{\\{.*\\}\\}", " ").replaceAll("\u001b\\[\\d{2}m", "").length();
    }

    private String lineFormat(Message message) {
        return TString.tokenReplace(this.template, message.getTokens()) + TFile.getLineSeparator();
    }

    public void fillTokens(Message message) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        message.setTokens(tokens);
        tokens.put("t", "\t");
        tokens.put("s", " ");
        tokens.put("n", TFile.getLineSeparator());
        tokens.put("I", message.getMessage());
        if (LoggerStatic.HAS_COLOR) {
            if (!TEnv.OS_NAME.toUpperCase().contains("WINDOWS")) {
                tokens.put("F0", "\u001b[30m");
                tokens.put("F1", "\u001b[31m");
                tokens.put("F2", "\u001b[32m");
                tokens.put("F3", "\u001b[33m");
                tokens.put("F4", "\u001b[34m");
                tokens.put("F5", "\u001b[35m");
                tokens.put("F6", "\u001b[36m");
                tokens.put("F7", "\u001b[37m");
                tokens.put("FD", "\u001b[39m");
                tokens.put("B0", "\u001b[40m");
                tokens.put("B1", "\u001b[41m");
                tokens.put("B2", "\u001b[42m");
                tokens.put("B3", "\u001b[43m");
                tokens.put("B4", "\u001b[44m");
                tokens.put("B5", "\u001b[45m");
                tokens.put("B6", "\u001b[46m");
                tokens.put("B7", "\u001b[47m");
                tokens.put("BD", "\u001b[49m");
            } else {
                tokens.put("F0", "");
                tokens.put("F1", "");
                tokens.put("F2", "");
                tokens.put("F3", "");
                tokens.put("F4", "");
                tokens.put("F5", "");
                tokens.put("F6", "");
                tokens.put("F7", "");
                tokens.put("FD", "");
                tokens.put("B0", "");
                tokens.put("B1", "");
                tokens.put("B2", "");
                tokens.put("B3", "");
                tokens.put("B4", "");
                tokens.put("B5", "");
                tokens.put("B6", "");
                tokens.put("B7", "");
                tokens.put("BD", "");
            }
        }
        if (LoggerStatic.HAS_LEVEL) {
            tokens.put("P", TObject.nullDefault(message.getLevel(), "INFO"));
        }
        if (LoggerStatic.HAS_THREAD) {
            tokens.put("T", Formater.currentThreadName());
        }
        if (LoggerStatic.HAS_DATE) {
            tokens.put("D", TDateTime.now("yyyy-MM-dd HH:mm:ss:SS z"));
        }
        if (LoggerStatic.HAS_RUNTIME) {
            tokens.put("R", Long.toString(System.currentTimeMillis() - LoggerStatic.getStartTimeMillis()));
        }
        if (LoggerStatic.HAS_STACK) {
            StackTraceElement stackTraceElement = Formater.currentStackLine();
            tokens.put("SI", stackTraceElement.toString());
            tokens.put("L", Integer.toString(stackTraceElement.getLineNumber()));
            tokens.put("M", stackTraceElement.getMethodName());
            tokens.put("F", stackTraceElement.getFileName());
            tokens.put("C", stackTraceElement.getClassName());
        }
    }

    public String format(Message message) {
        this.fillTokens(message);
        return this.lineFormat(message);
    }

    public String simpleFormat(Message message) {
        this.fillTokens(message);
        return TString.tokenReplace(message.getMessage(), message.getTokens());
    }

    public boolean messageWritable(Message message) {
        if (this.logLevel.contains("ALL")) {
            return true;
        }
        return this.logLevel.contains(message.getLevel());
    }

    public void writeFormatedLog(Message message) {
        if (this.messageWritable(message)) {
            if ("SIMPLE".equals(message.getLevel())) {
                this.writeLog(this.simpleFormat(message) + "\r\n");
            } else {
                this.writeLog(this.format(message));
            }
        }
    }

    public synchronized void writeLog(String msg) {
        if (Logger.isEnable()) {
            if (this.loggerThread == null || this.loggerThread.isFinished()) {
                this.loggerThread = LoggerThread.start(Formater.getOutputStreams());
            }
            this.loggerThread.addLogMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packLogFile() {
        block9: {
            long packSize = (long)(Double.valueOf(LoggerStatic.getLogConfig("PackSize", "1024")) * 1024.0 * 1024.0);
            String logFilePath = Formater.getFormatedLogFilePath();
            String tmpFilePath = TFile.getFileDirectory(logFilePath) + ".tmpPackLog";
            File logFile = new File(logFilePath);
            File tmpLogFile = new File(tmpFilePath);
            if (packSize > 0L && logFile.length() > packSize) {
                try {
                    if (!this.loggerThread.pause()) break block9;
                    try {
                        TFile.moveFile(logFile, tmpLogFile);
                        Global.getThreadPool().execute(() -> {
                            String logFileExtendNam = TFile.getFileExtension(logFilePath);
                            String innerLogFilePath = logFilePath.replace("." + logFileExtendNam, "");
                            try {
                                File packFile = new File(innerLogFilePath + TDateTime.now("HHmmss") + "." + logFileExtendNam + ".gz");
                                TZip.encodeGZip(tmpLogFile, packFile);
                                TFile.deleteFile(tmpLogFile);
                            }
                            catch (Exception e) {
                                System.out.println("[ERROR] Pack log file " + innerLogFilePath + "error: ");
                                e.printStackTrace();
                            }
                        });
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    for (OutputStream outputStream : this.loggerThread.getOutputStreams()) {
                        if (!(outputStream instanceof FileOutputStream)) continue;
                        try {
                            ((FileOutputStream)outputStream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.loggerThread.setOutputStreams(Formater.getOutputStreams());
                }
                finally {
                    this.loggerThread.unpause();
                }
            }
        }
    }

    public static String getFormatedLogFilePath() {
        String filePath = "";
        String logFile = LoggerStatic.getLogConfig("LogFile", LoggerStatic.LOG_FILE);
        if (logFile != null) {
            HashMap<String, String> tokens = new HashMap<String, String>();
            tokens.put("D", DATE);
            tokens.put("WorkDir", TFile.getContextPath());
            filePath = TString.tokenReplace(logFile, tokens);
            String fileDirectory = filePath.substring(0, filePath.lastIndexOf(File.separator));
            File loggerFile = new File(fileDirectory);
            if (!loggerFile.exists() && !loggerFile.mkdirs()) {
                System.out.println("Logger file directory error!");
            }
        } else {
            filePath = null;
        }
        return filePath;
    }

    public static Formater newInstance() {
        return new Formater(LoggerStatic.LOG_TEMPLATE);
    }

    protected static OutputStream[] getOutputStreams() {
        String[] LogTypes = LoggerStatic.getLogConfig("LogType", "STDOUT").split(",");
        String logFilePath = Formater.getFormatedLogFilePath();
        OutputStream[] outputStreams = new OutputStream[LogTypes.length];
        block12: for (int i = 0; i < LogTypes.length; ++i) {
            String logType;
            switch (logType = LogTypes[i].trim()) {
                case "STDOUT": {
                    outputStreams[i] = System.out;
                    continue block12;
                }
                case "STDERR": {
                    outputStreams[i] = System.err;
                    continue block12;
                }
                case "FILE": {
                    try {
                        outputStreams[i] = new FileOutputStream(logFilePath, true);
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("log file: [" + logFilePath + "] is not found.\r\n");
                    }
                    continue block12;
                }
            }
        }
        return outputStreams;
    }

    static {
        Global.getHashWheelTimer().addTask(new HashWheelTask(){

            @Override
            public void run() {
                DATE = TDateTime.now("yyyyMMdd");
            }
        }, 1);
    }
}

