/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.json;

import java.io.IOException;
import org.voovan.tools.FastThreadLocal;
import org.voovan.tools.TFile;
import org.voovan.tools.TString;

public class YAML2JSON {
    public static FastThreadLocal<Integer> YAML_READ_INDEX = FastThreadLocal.withInitial(() -> 0);

    public static String convert(String jsonStr) throws IOException {
        int lineType;
        YAML_READ_INDEX.set(0);
        StringBuilder result = new StringBuilder();
        int firstLineType = -1;
        while ((lineType = YAML2JSON.getNextLineType(jsonStr)) != -1) {
            if (firstLineType == -1) {
                firstLineType = lineType;
            }
            result.append(YAML2JSON.parse(lineType, jsonStr));
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) == ',') {
            result.deleteCharAt(result.length() - 1);
        }
        if (firstLineType == 1 || firstLineType == 2) {
            result.insert(0, '{');
            result.append('}');
        }
        return result.toString();
    }

    public static int getNextLineType(String jsonStr) {
        String line = YAML2JSON.readLine(jsonStr);
        if (line != null) {
            YAML2JSON.writeBack(line);
            line = line.trim();
            if (line.endsWith(">") || line.endsWith("|") || line.endsWith("|+") || line.endsWith("|-")) {
                return 2;
            }
            if (line.contains(":")) {
                return 1;
            }
            if (line.startsWith("-")) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public static String parse(int nextLintType, String jsonStr) {
        String result = null;
        switch (nextLintType) {
            case 0: {
                result = YAML2JSON.parseArray(jsonStr);
                break;
            }
            case 1: {
                result = YAML2JSON.parseMap(jsonStr);
                break;
            }
            case 2: {
                result = YAML2JSON.parseMulitLineString(jsonStr);
                break;
            }
        }
        return result;
    }

    public static String readLine(String jsonStr) {
        String line = TString.readLine(jsonStr, YAML_READ_INDEX.get());
        if (line != null) {
            YAML_READ_INDEX.set(YAML_READ_INDEX.get() + line.length());
        }
        return line;
    }

    public static String parseArray(String jsonStr) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int prevLineRetract = -1;
        while (true) {
            String line;
            if ((line = YAML2JSON.readLine(jsonStr)) == null) {
                if (stringBuilder.length() <= 0 || stringBuilder.charAt(stringBuilder.length() - 1) != ',') break;
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                break;
            }
            if (line.trim().startsWith("#")) continue;
            int lineRetract = TString.retract(line);
            String lineValue = TString.trimEndLF(line.substring(lineRetract == 0 ? 0 : lineRetract + 1));
            if (prevLineRetract == -1) {
                prevLineRetract = lineRetract;
            }
            if (prevLineRetract < lineRetract) {
                YAML2JSON.writeBack(line);
                if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                stringBuilder.append("],");
                break;
            }
            if (prevLineRetract > lineRetract) {
                if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                YAML2JSON.writeBack(line);
                break;
            }
            int nextLineType = YAML2JSON.getNextLineType(jsonStr);
            if (nextLineType == 1) {
                stringBuilder.append("{" + YAML2JSON.parseMap(jsonStr) + "}");
                continue;
            }
            if (lineValue.endsWith(">") || lineValue.endsWith("|") || lineValue.endsWith("|+") || lineValue.endsWith("|-")) {
                YAML2JSON.writeBack(line);
                stringBuilder.append(YAML2JSON.parseMulitLineString(jsonStr)).append(",");
                continue;
            }
            if (!lineValue.startsWith("-")) continue;
            stringBuilder.append(YAML2JSON.formatLine(lineValue.replaceAll("- *", ""))).append(",");
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String parseMap(String jsonStr) {
        StringBuilder stringBuilder = new StringBuilder();
        int prevLineRetract = -1;
        while (true) {
            String line;
            if ((line = YAML2JSON.readLine(jsonStr)) == null) {
                if (stringBuilder.length() <= 0 || stringBuilder.charAt(stringBuilder.length() - 1) != ',') break;
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                break;
            }
            if (line.trim().startsWith("#")) continue;
            int lineRetract = TString.retract(line);
            String lineValue = TString.trimEndLF(line.substring(lineRetract == 0 ? 0 : lineRetract + 1));
            if (prevLineRetract == -1) {
                prevLineRetract = lineRetract;
            }
            int nextLineType = YAML2JSON.getNextLineType(jsonStr);
            if (prevLineRetract < lineRetract) {
                YAML2JSON.writeBack(line);
                lineValue = YAML2JSON.parse(nextLineType, jsonStr);
                stringBuilder.append(lineValue);
                if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                stringBuilder.append("},");
                if (!lineValue.startsWith("[") || !lineValue.endsWith("]")) break;
                stringBuilder.deleteCharAt(stringBuilder.indexOf("{"));
                int closePostion = stringBuilder.lastIndexOf("},");
                stringBuilder.delete(closePostion, closePostion + 2);
                stringBuilder.append(",");
                break;
            }
            if (prevLineRetract > lineRetract) {
                YAML2JSON.writeBack(line);
                if (stringBuilder.length() <= 0 || stringBuilder.charAt(stringBuilder.length() - 1) != ',') break;
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                break;
            }
            if (nextLineType == 0) {
                stringBuilder.append(YAML2JSON.formatLine(lineValue));
                stringBuilder.append(YAML2JSON.parse(nextLineType, jsonStr)).append(",");
                continue;
            }
            if (lineValue.trim().endsWith(">") || lineValue.trim().endsWith("|") || lineValue.trim().endsWith("|+") || lineValue.trim().endsWith("|-")) {
                YAML2JSON.writeBack(line);
                stringBuilder.append(YAML2JSON.parseMulitLineString(jsonStr)).append(",");
                continue;
            }
            if (lineValue.trim().endsWith(":")) {
                stringBuilder.append(YAML2JSON.formatLine(lineValue)).append("{");
                continue;
            }
            if (!lineValue.contains(": ") || lineValue.trim().endsWith(":")) continue;
            stringBuilder.append(YAML2JSON.formatLine(lineValue)).append(",");
        }
        return stringBuilder.toString();
    }

    public static void writeBack(String line) {
        YAML_READ_INDEX.set(YAML_READ_INDEX.get() - line.length());
    }

    public static String formatLine(String line) {
        int pairIndex = (line = line.replace("- ", "")).indexOf(":");
        if (pairIndex > 0) {
            String key = line.substring(0, pairIndex).trim();
            String value = "";
            if (pairIndex <= line.length() - 2) {
                value = line.substring(pairIndex + 2).trim();
            }
            if (!(value.isEmpty() || value.startsWith("\"") || value.endsWith("\"") || TString.isNumber(value, 10) || TString.isDecimal(value))) {
                value = "\"" + value + "\"";
            }
            line = "\"" + key + "\":" + value;
        } else if (!TString.isNumber(line, 10) && !TString.isDecimal(line)) {
            line = "\"" + line + "\"";
        }
        return line;
    }

    public static String parseMulitLineString(String jsonStr) {
        int initLineRetract = 0;
        int lineRetract = 0;
        String markLine = YAML2JSON.readLine(jsonStr);
        String line = null;
        String result = "";
        markLine = markLine.trim();
        while ((line = YAML2JSON.readLine(jsonStr)) != null) {
            if (line.trim().startsWith("#")) continue;
            lineRetract = TString.retract(line);
            String lineValue = line.substring(lineRetract == 0 ? 0 : lineRetract + 1);
            if (lineRetract == initLineRetract || initLineRetract == 0) {
                result = result + lineValue;
                initLineRetract = lineRetract;
                continue;
            }
            YAML2JSON.writeBack(line);
            break;
        }
        if (markLine.endsWith("-")) {
            result = TString.trimEndLF(result) + TFile.getLineSeparator();
        }
        if (markLine.endsWith(">")) {
            result = result.replace(TFile.getLineSeparator(), "");
        }
        if (markLine.endsWith("|")) {
            result = TString.trimEndLF(result);
        }
        markLine = TString.fastReplaceAll(markLine, ":\\s*(\\||>)[+-]?", ":");
        markLine = markLine + TString.convertEscapeChar(result);
        return YAML2JSON.formatLine(markLine) + ",";
    }
}

