/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.json;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.voovan.tools.TDateTime;
import org.voovan.tools.TString;
import org.voovan.tools.json.JSON;
import org.voovan.tools.reflect.TReflect;

public class JSONEncode {
    private static String complexObject(Object object, boolean allField) throws ReflectiveOperationException {
        return JSONEncode.mapObject(TReflect.getMapfromObject(object, allField), allField);
    }

    private static String mapObject(Map<?, ?> mapObject, boolean allField) throws ReflectiveOperationException {
        Object[] keys;
        String mapString = "{";
        StringBuilder contentStringBuilder = new StringBuilder();
        String ContentString = null;
        for (Object mapkey : keys = mapObject.keySet().toArray()) {
            String key = JSONEncode.fromObject(mapkey, allField);
            String Value = JSONEncode.fromObject(mapObject.get(mapkey), allField);
            contentStringBuilder.append((Object)key);
            contentStringBuilder.append(":");
            contentStringBuilder.append(Value);
            contentStringBuilder.append(",");
        }
        ContentString = contentStringBuilder.toString();
        if (!ContentString.trim().isEmpty()) {
            ContentString = ContentString.substring(0, ContentString.length() - 1);
        }
        mapString = mapString + ContentString + "}";
        return mapString;
    }

    private static String CollectionObject(Collection<Object> listObject, boolean allField) throws ReflectiveOperationException {
        return JSONEncode.arrayObject(listObject.toArray(), allField);
    }

    private static String arrayObject(Object[] arrayObject, boolean allField) throws ReflectiveOperationException {
        String arrayString = "[";
        String ContentString = "";
        StringBuilder ContentStringBuilder = new StringBuilder();
        for (Object object : arrayObject) {
            String Value = JSONEncode.fromObject(object, allField);
            ContentStringBuilder.append(Value);
            ContentStringBuilder.append(",");
        }
        ContentString = ContentStringBuilder.toString();
        if (!ContentString.trim().isEmpty()) {
            ContentString = ContentString.substring(0, ContentString.length() - 1);
        }
        arrayString = arrayString + ContentString + "]";
        return arrayString;
    }

    public static String fromObject(Object object) throws ReflectiveOperationException {
        return JSONEncode.fromObject(object, false);
    }

    public static String fromObject(Object object, boolean allField) throws ReflectiveOperationException {
        String value = null;
        if (object == null) {
            value = "null";
        } else {
            if (object instanceof Class) {
                return ((Class)object).getCanonicalName();
            }
            if (object instanceof BigDecimal) {
                if (BigDecimal.ZERO.compareTo((BigDecimal)object) == 0) {
                    object = BigDecimal.ZERO;
                }
                value = ((BigDecimal)object).toPlainString();
            } else if (object instanceof Date) {
                value = "\"" + TDateTime.format((Date)object, "yyyy-MM-dd HH:mm:ss") + "\"";
            } else if (object instanceof Map) {
                Map mapObject = (Map)object;
                value = JSONEncode.mapObject(mapObject, allField);
            } else if (object instanceof Collection) {
                Collection collectionObject = (Collection)object;
                value = JSONEncode.CollectionObject(collectionObject, allField);
            } else if (object.getClass().isArray()) {
                Object[] arrayObject = (Object[])object;
                if (object.getClass().getComponentType().isPrimitive()) {
                    int length = Array.getLength(object);
                    arrayObject = new Object[length];
                    for (int i = 0; i < length; ++i) {
                        arrayObject[i] = Array.get(object, i);
                    }
                } else {
                    arrayObject = (Object[])object;
                }
                value = JSONEncode.arrayObject(arrayObject, allField);
            } else if (object instanceof Integer || object instanceof Float || object instanceof Double || object instanceof Boolean || object instanceof Long || object instanceof Short) {
                value = object.toString();
            } else if (TReflect.isBasicType(object.getClass())) {
                String strValue = object.toString();
                if (JSON.isConvertEscapeChar()) {
                    strValue = TString.convertEscapeChar(object.toString());
                }
                value = "\"" + strValue + "\"";
            } else {
                value = JSONEncode.complexObject(object, allField);
            }
        }
        return value;
    }
}

