/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.json;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.json.JSON;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class JSONDecode {
    private static int E_OBJECT = 1;
    private static int E_ARRAY = -1;

    public static Object parse(String jsonStr) {
        return JSONDecode.parse(new StringReader(jsonStr.trim() + "\u0000"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object parse(StringReader reader) {
        try {
            if (reader == null) {
                return null;
            }
            int type = 0;
            Object jsonResult = null;
            boolean isFirstChar = true;
            if (type == 0) {
                char flag = (char)reader.read();
                if (flag == '{') {
                    type = E_OBJECT;
                }
                if (flag == '[') {
                    type = E_ARRAY;
                }
            }
            if (E_OBJECT == type) {
                jsonResult = new LinkedHashMap();
                isFirstChar = false;
            } else if (E_ARRAY == type) {
                jsonResult = new ArrayList();
                isFirstChar = false;
            } else {
                reader.skip(-1L);
            }
            String keyString = null;
            Object value = null;
            char stringWarpFlag = '\u0000';
            int functionWarpFlag = 0;
            boolean isString = false;
            boolean isFunction = false;
            int isComment = 0;
            StringBuilder itemString = new StringBuilder();
            char currentChar = '\u0000';
            char nextChar = '\u0000';
            char prevChar = '\u0000';
            while (true) {
                currentChar = (char)reader.read();
                nextChar = (char)reader.read();
                if (nextChar != '\uffff') {
                    reader.skip(-1L);
                }
                if (!isFirstChar) {
                    reader.skip(-2L);
                    prevChar = (char)reader.read();
                    reader.skip(1L);
                }
                isFirstChar = false;
                if ((currentChar == '\"' || currentChar == '\'') && isComment == 0 && nextChar != '\u0000' && prevChar != '\\') {
                    if (stringWarpFlag == '\u0000') {
                        stringWarpFlag = currentChar;
                        isString = true;
                    } else if (stringWarpFlag != '\u0000' && currentChar == stringWarpFlag) {
                        stringWarpFlag = '\u0000';
                        isString = false;
                    }
                }
                if (!isString) {
                    if (currentChar == '/' && isComment == 0) {
                        if (nextChar != '\u0000' && nextChar == '/') {
                            isComment = 1;
                        }
                        if (nextChar != '\u0000' && nextChar == '*') {
                            isComment = 2;
                            if (currentChar != '\uffff') continue;
                            return jsonResult;
                        }
                    }
                    if (isComment > 0) {
                        if (isComment == 1 && currentChar == '\n') {
                            isComment = 0;
                        }
                        if (isComment == 2 && currentChar == '/' && prevChar != '\u0000' && prevChar == '*') {
                            isComment = 0;
                            if (currentChar != '\uffff') continue;
                            return jsonResult;
                        }
                        if (currentChar != '\uffff') continue;
                        return jsonResult;
                    }
                }
                if (!isString && !isFunction) {
                    if (currentChar == '[') {
                        reader.skip(-1L);
                        value = JSONDecode.parse(reader);
                        continue;
                    }
                    if (currentChar == ']') {
                        if (itemString.length() == 0 && value == null) return jsonResult;
                        currentChar = (char)44;
                        reader.skip(-1L);
                    } else {
                        if (currentChar == '{') {
                            reader.skip(-1L);
                            value = JSONDecode.parse(reader);
                            continue;
                        }
                        if (currentChar == '}') {
                            if (itemString.length() == 0 && value == null) return jsonResult;
                            currentChar = (char)44;
                            reader.skip(-1L);
                        }
                    }
                }
                if (isString || !isString && !Character.isWhitespace(currentChar)) {
                    itemString.append(currentChar);
                }
                if (jsonResult == null) {
                    jsonResult = value;
                }
                if (!isString) {
                    if (!isString && itemString.toString().trim().startsWith("function")) {
                        if (currentChar == '{') {
                            ++functionWarpFlag;
                        } else if (currentChar == '}') {
                            if (--functionWarpFlag == 0) {
                                isFunction = false;
                                value = itemString.toString();
                                itemString = new StringBuilder();
                            }
                        } else {
                            isFunction = true;
                        }
                    }
                    if (!isFunction) {
                        if (currentChar == ':' || currentChar == '=') {
                            keyString = itemString.substring(0, itemString.length() - 1).trim();
                            itemString = new StringBuilder();
                        }
                        if (currentChar == ',') {
                            if (value == null) {
                                value = itemString.substring(0, itemString.length() - 1).trim();
                            }
                            itemString = new StringBuilder();
                        }
                        if (currentChar == '\n') {
                            itemString.trimToSize();
                            if (value == null && itemString.length() > 0) {
                                value = itemString.toString().trim();
                            }
                            itemString = new StringBuilder();
                        }
                    }
                }
                if (value != null && jsonResult != null) {
                    Cloneable result;
                    if (value instanceof String) {
                        String stringValue = (String)value;
                        if (stringValue.length() >= 2 && stringValue.charAt(0) == '\"' && stringValue.charAt(stringValue.length() - 1) == '\"') {
                            value = stringValue.substring(1, stringValue.length() - 1);
                            if (JSON.isConvertEscapeChar()) {
                                value = TString.unConvertEscapeChar(value.toString());
                            }
                        } else if (stringValue.length() >= 2 && stringValue.charAt(0) == '\'' && stringValue.charAt(stringValue.length() - 1) == '\'') {
                            value = stringValue.substring(1, stringValue.length() - 1);
                            if (JSON.isConvertEscapeChar()) {
                                value = TString.unConvertEscapeChar(value.toString());
                            }
                        } else if (TString.isInteger(stringValue)) {
                            Long longValue = Long.parseLong((String)value);
                            value = longValue <= Integer.MAX_VALUE && longValue >= -2147483647L ? (Number)Integer.parseInt((String)value) : (Number)longValue;
                        } else if (TString.isDecimal(stringValue)) {
                            Number resultValue = new Float((String)value);
                            if (resultValue.toString().equals(value)) {
                                value = resultValue;
                            } else {
                                resultValue = new Double((String)value);
                                if (resultValue.toString().equals(value)) {
                                    value = resultValue;
                                } else {
                                    resultValue = new BigDecimal((String)value);
                                }
                            }
                            value = resultValue;
                        } else if (TString.isBoolean(stringValue)) {
                            value = Boolean.parseBoolean((String)value);
                        } else if (value.equals("null")) {
                            value = null;
                        } else if (value.equals("")) {
                            value = null;
                        }
                    }
                    if (jsonResult instanceof HashMap) {
                        result = (HashMap)jsonResult;
                        if (keyString != null) {
                            if (keyString.length() >= 2 && keyString.charAt(0) == '\"' && keyString.charAt(keyString.length() - 1) == '\"') {
                                keyString = keyString.substring(1, keyString.length() - 1);
                            }
                            if (keyString.length() >= 2 && keyString.charAt(0) == '\'' && keyString.charAt(keyString.length() - 1) == '\'') {
                                keyString = keyString.substring(1, keyString.length() - 1);
                            }
                            ((HashMap)result).put(keyString, value);
                        }
                    } else if (jsonResult instanceof ArrayList && value != null) {
                        result = (ArrayList)jsonResult;
                        ((ArrayList)result).add(value);
                    } else if (jsonResult == null) {
                        jsonResult = value;
                    }
                    keyString = null;
                    value = null;
                }
                if (currentChar == '\uffff') return jsonResult;
            }
        }
        catch (Exception e) {
            try {
                int position = (Integer)TReflect.getFieldValue(reader, "next") - 1;
                String jsonStr = (String)TReflect.getFieldValue(reader, "str");
                jsonStr = jsonStr.substring(0, position) + "^" + jsonStr.substring(position, position + 10);
                Logger.error(jsonStr, e);
                return null;
            }
            catch (ReflectiveOperationException ex) {
                Logger.error(ex);
            }
            return null;
        }
    }

    public static <T> T fromJSON(String jsonStr, Type type, boolean ignoreCase) throws ReflectiveOperationException, ParseException {
        if (jsonStr == null) {
            return null;
        }
        Object parseObject = JSONDecode.parse(jsonStr);
        if (parseObject == null) {
            parseObject = jsonStr;
        }
        if (type == Map.class && parseObject instanceof Map) {
            return (T)parseObject;
        }
        if (parseObject instanceof Map) {
            Map mapJSON = (Map)parseObject;
            return TReflect.getObjectFromMap(type, mapJSON, ignoreCase);
        }
        if (parseObject instanceof Collection) {
            return TReflect.getObjectFromMap(type, TObject.asMap(TReflect.SINGLE_VALUE_KEY, parseObject), false);
        }
        if (parseObject instanceof String || parseObject.getClass().isPrimitive()) {
            return TString.toObject(parseObject.toString(), type);
        }
        return null;
    }

    public static <T> T fromJSON(String jsonStr, Class<T> clazz) throws ParseException, ReflectiveOperationException, IOException {
        return JSONDecode.fromJSON(jsonStr, clazz, false);
    }
}

