/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.hashwheeltimer;

import java.util.Timer;
import java.util.TimerTask;
import org.voovan.tools.TEnv;
import org.voovan.tools.hashwheeltimer.HashWheel;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.log.Logger;

public class HashWheelTimer {
    private HashWheel wheel;
    private int tickStep = 1000;
    private Timer timer;

    public HashWheelTimer(int size) {
        this.wheel = new HashWheel(size);
        this.timer = new Timer("VOOVAN@HASH_WHEEL");
    }

    public HashWheelTimer(int size, int tickStep) {
        this.wheel = new HashWheel(size);
        this.timer = new Timer("VOOVAN@HASH_WHEEL");
        this.tickStep = tickStep;
    }

    public boolean addTask(HashWheelTask task, int interval) {
        return this.addTask(task, interval, false);
    }

    public boolean addTask(HashWheelTask task, int interval, boolean asynchronous) {
        return this.wheel.addTask(task, interval, asynchronous);
    }

    public boolean removeTask(HashWheelTask task) {
        return this.wheel.removeTask(task);
    }

    public boolean rotate() {
        final HashWheel rotateWheel = this.wheel;
        final HashWheelTimer tempTimer = this;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    rotateWheel.Tick();
                }
                catch (Exception e) {
                    Logger.error("HashWheelTimer tick task error", e);
                }
                if (TEnv.IS_SHUTDOWN) {
                    tempTimer.cancel();
                }
            }
        }, 0L, (long)this.tickStep);
        return true;
    }

    public void clear() {
        this.wheel.clear();
    }

    public void cancel() {
        this.timer.cancel();
    }
}

