/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.hashwheeltimer;

import org.voovan.Global;
import org.voovan.tools.hashwheeltimer.HashWheel;

public abstract class HashWheelTask {
    private int interval;
    private int skipTick = 0;
    private boolean asynchronous;
    private HashWheel hashWheel;
    private int slot;
    private long doCount;
    private boolean isCancel;

    public HashWheelTask() {
        this.interval = 0;
        this.skipTick = 0;
        this.asynchronous = false;
        this.isCancel = false;
    }

    public HashWheelTask(int interval, boolean asynchronous) {
        this.interval = interval;
        this.skipTick = 0;
        this.asynchronous = asynchronous;
        this.isCancel = false;
    }

    protected void init(int skipTick, int interval, boolean asynchronous, HashWheel hashWheel, int slot) {
        this.skipTick = skipTick;
        this.interval = interval;
        this.asynchronous = asynchronous;
        this.hashWheel = hashWheel;
        this.slot = slot;
        this.doCount = 0L;
        this.isCancel = false;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public int getSkipTick() {
        return this.skipTick;
    }

    public void setSkipTick(int skipTick) {
        this.skipTick = skipTick;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public int getSlot() {
        return this.slot;
    }

    public long getDoCount() {
        return this.doCount;
    }

    public boolean cancel() {
        this.isCancel = true;
        return this.hashWheel.removeTask(this);
    }

    public abstract void run();

    public boolean doTask() {
        ++this.doCount;
        if (this.doCount == Long.MAX_VALUE) {
            this.doCount = 0L;
        }
        if (this.skipTick > 0) {
            --this.skipTick;
            return false;
        }
        if (this.asynchronous) {
            final HashWheelTask task = this;
            if (!Global.getThreadPool().isShutdown()) {
                Global.getThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        task.run();
                    }
                });
            } else {
                task.cancel();
            }
        } else {
            this.run();
        }
        return true;
    }
}

