/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.compiler.sandbox;

import java.net.InetAddress;
import java.security.Permission;
import java.util.List;
import org.voovan.tools.TString;
import org.voovan.tools.compiler.sandbox.SandboxControler;

public class SandboxSecurity
extends SecurityManager {
    private SecurityManager systemSecurityManager;
    private SandboxControler sandboxControler;

    public SandboxSecurity(SandboxControler sandboxControler) {
        this.sandboxControler = sandboxControler;
        this.systemSecurityManager = System.getSecurityManager();
        if (this.systemSecurityManager instanceof SandboxSecurity) {
            this.systemSecurityManager = ((SandboxSecurity)this.systemSecurityManager).getSystemSecurityManager();
        }
    }

    public SecurityManager getSystemSecurityManager() {
        return this.systemSecurityManager;
    }

    private boolean isDynamicObject() {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().contains("_VDC_")) continue;
            return true;
        }
        return false;
    }

    public boolean isInList(List<String> restricts, String param) {
        if (restricts == null) {
            return true;
        }
        boolean result = false;
        for (String restrict : restricts) {
            if (TString.regexMatch(param, restrict.trim()) <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isNotInList(List<String> restricts, String param) {
        if (restricts == null) {
            return true;
        }
        boolean result = false;
        for (String restrict : restricts) {
            if (TString.regexMatch(param, restrict.trim()) <= 0) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean commonCheck(Object condiction, Object param) {
        boolean result = true;
        if (this.isDynamicObject() && condiction instanceof Boolean && param == null) {
            result = (Boolean)condiction;
        } else if (this.isDynamicObject() && condiction instanceof List) {
            result = this.isInList((List)condiction, (String)param);
        }
        return result;
    }

    public void throwException(String resource) {
        throw new SecurityException("Access to protected resource [" + resource + "] is restricted in Sandbox mode");
    }

    public void checkLoadClass(String className) throws ClassNotFoundException {
        if (this.isDynamicObject() && !this.isNotInList(this.sandboxControler.getForbiddenClasses(), className)) {
            throw new ClassNotFoundException("Access to protected resource [ Load Class: " + className + "] is restricted in Sandbox mode");
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkPermission(perm);
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (!this.commonCheck(this.sandboxControler.isThread(), null)) {
            this.throwException("Thread Operation");
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (!this.commonCheck(this.sandboxControler.isThread(), null)) {
            this.throwException("ThreadGroup Operation");
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkAccess(g);
        }
    }

    @Override
    public void checkExit(int status) {
        if (!this.commonCheck(this.sandboxControler.isExit(), null)) {
            this.throwException("Exit Operation");
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkExit(status);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (!this.commonCheck(this.sandboxControler.isExec(), null)) {
            this.throwException("Execute " + cmd);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (!this.commonCheck(this.sandboxControler.isLink(), null)) {
            this.throwException("Link " + lib);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkLink(lib);
        }
    }

    @Override
    public void checkRead(String file) {
        if (!this.commonCheck(this.sandboxControler.getFile(), file)) {
            this.throwException("Read " + file);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkRead(file);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (!this.commonCheck(this.sandboxControler.getFile(), file)) {
            this.throwException("Write " + file);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        if (!this.commonCheck(this.sandboxControler.getFile(), file)) {
            this.throwException("Delete " + file);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkDelete(file);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        String addrsss = host + ":" + port;
        if (!this.commonCheck(this.sandboxControler.getNetwork(), addrsss)) {
            this.throwException("Connect " + addrsss);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkConnect(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        String addrsss = host + ":" + port;
        if (!this.commonCheck(this.sandboxControler.getNetwork(), addrsss)) {
            this.throwException("Connect " + addrsss);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        String addrsss = ":" + port;
        if (!this.commonCheck(this.sandboxControler.getNetwork(), addrsss)) {
            this.throwException("Listen " + addrsss);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        String addrsss = host + ":" + port;
        if (!this.commonCheck(this.sandboxControler.getNetwork(), addrsss)) {
            this.throwException("Accept " + addrsss);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkAccept(host, port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        String addrsss = maddr.getHostAddress();
        if (!this.commonCheck(this.sandboxControler.getNetwork(), addrsss)) {
            this.throwException("Multicast " + addrsss);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkMulticast(maddr);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (!this.commonCheck(this.sandboxControler.isProperties(), null)) {
            this.throwException("System Property");
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (!this.commonCheck(this.sandboxControler.isProperties(), null)) {
            this.throwException("System Property");
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkPropertyAccess(key);
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (!this.commonCheck(this.sandboxControler.isPrintJob(), null)) {
            this.throwException("Print Job");
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkPrintJobAccess();
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (!this.commonCheck(this.sandboxControler.getPackageAccess(), pkg)) {
            this.throwException("Package " + pkg);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (!this.commonCheck(this.sandboxControler.getPackageDefintion(), pkg)) {
            this.throwException("Package " + pkg);
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkSetFactory() {
        if (!this.commonCheck(this.sandboxControler.isFactory(), null)) {
            this.throwException("Socket Factory");
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkSetFactory();
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (!this.commonCheck(this.sandboxControler.isSecurityAccess(), null)) {
            this.throwException("Security Access");
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkSecurityAccess(target);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (!this.commonCheck(this.sandboxControler.isCreateClassLoader(), null)) {
            this.throwException("Create ClassLoader");
        }
        if (this.systemSecurityManager != null) {
            this.systemSecurityManager.checkCreateClassLoader();
        }
    }
}

