/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.compiler.function;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.voovan.tools.TFile;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.buffer.ByteBufferChannel;
import org.voovan.tools.collection.MultiMap;
import org.voovan.tools.compiler.DynamicCompiler;
import org.voovan.tools.compiler.DynamicCompilerManager;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class DynamicFunction {
    private static final String CODE_TEMPLATE = new String(TFile.loadResource("org/voovan/tools/compiler/function/CodeTemplate.txt"));
    private List<Class> importClasses;
    private MultiMap<Integer, Object> args;
    private String argCode;
    private boolean enableImportInCode;
    private String packageName;
    private String name;
    private String className;
    private String importCode;
    private String bodyCode;
    private String code;
    private String javaCode;
    private Class clazz;
    private File codeFile;
    private String fileCharset;
    private long lastFileTimeStamp;
    private boolean needCompile;
    private String importFunctionCode;
    private ArrayList<String> importFunctions;

    public DynamicFunction(String name, String code) {
        this.init();
        this.name = name;
        this.code = code;
        DynamicCompilerManager.addFunction(this);
    }

    public DynamicFunction(File file, String charset) throws UnsupportedEncodingException {
        this.init();
        String fileName = TFile.getFileName(file.getPath());
        this.name = fileName.substring(0, fileName.lastIndexOf("."));
        this.codeFile = file;
        this.fileCharset = charset;
        this.lastFileTimeStamp = file.lastModified();
        DynamicCompilerManager.addFunction(this);
    }

    private void init() {
        this.packageName = "org.voovan.tools.compiler.temporary";
        this.name = null;
        this.argCode = null;
        this.importCode = "";
        this.bodyCode = "";
        this.code = null;
        this.javaCode = "";
        this.clazz = Object.class;
        this.codeFile = null;
        this.needCompile = true;
        this.enableImportInCode = false;
        this.importClasses = new ArrayList<Class>();
        this.args = new MultiMap();
        this.importFunctionCode = "";
        this.importFunctions = new ArrayList();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnableImportInCode() {
        return this.enableImportInCode;
    }

    public void enableImportInCode(boolean enableImportInCode) {
        this.enableImportInCode = enableImportInCode;
    }

    public String getCode() {
        if (this.codeFile != null) {
            try {
                this.code = new String(TFile.loadFile(this.codeFile), this.fileCharset);
            }
            catch (UnsupportedEncodingException e) {
                Logger.error("Load file " + this.codeFile.getPath() + " error", e);
            }
        }
        return this.code;
    }

    public void setCode(String code) {
        if (this.codeFile != null) {
            throw new RuntimeException("This function used code in file, Can't invoke this method.");
        }
        this.code = code;
        this.needCompile = true;
    }

    public String getClassName() {
        return this.className;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public void addPrepareArg(int argIndex, Class argClazz, String argName) {
        this.args.putValues((Integer)argIndex, (Object[])new Object[]{argClazz, argName});
    }

    public void removePrepareArg(int argIndex) {
        this.args.remove(argIndex);
    }

    public void addImport(Class clazz) {
        this.importClasses.add(clazz);
    }

    public void removeImport(Class clazz) {
        this.importClasses.remove(clazz);
    }

    private void genImports() {
        this.importCode = "";
        for (Class importClass : this.importClasses) {
            this.importCode = this.importCode + "import " + importClass.getCanonicalName() + ";";
        }
        this.importCode = this.importCode + TFile.getLineSeparator();
    }

    public void addImportFunction(String name) {
        this.importFunctions.add(name);
        if (!this.importClasses.contains(DynamicCompilerManager.class)) {
            this.importClasses.add(DynamicCompilerManager.class);
        }
    }

    public List<String> getImportFunctionx() {
        return this.importFunctions;
    }

    public void clearImportFunctions() {
        this.importFunctions.clear();
        this.importClasses.remove(DynamicCompilerManager.class);
    }

    private void genImportFunction() {
        for (String dynamicFunctionName : this.importFunctions) {
            this.importFunctionCode = this.importFunctionCode + "public static Object " + dynamicFunctionName + "(Object ... args) throws Exception { \r\n         return DynamicCompilerManager.callFunction(\"" + dynamicFunctionName + "\", args); \r\n    } \r\n";
        }
    }

    private void genClassName() {
        this.className = this.name + "_VDC_" + TString.generateShortUUID();
    }

    private void genArgCode() {
        this.argCode = "";
        for (Map.Entry prepareArg : this.args.entrySet()) {
            int argIndex = (Integer)prepareArg.getKey();
            Class argClazz = (Class)this.args.getValue(argIndex, 0);
            String argName = (String)this.args.getValue(argIndex, 1);
            this.argCode = this.argCode + "        " + argClazz.getCanonicalName() + " " + argName + " = (" + argClazz.getSimpleName() + ")args[" + argIndex + "];" + TFile.getLineSeparator();
        }
        this.argCode = this.argCode.trim();
    }

    private void parseCode() {
        String lineCode;
        if (this.codeFile != null) {
            this.code = this.getCode();
        }
        if (this.code == null) {
            throw new NullPointerException("Function code is null.");
        }
        if (!this.code.contains("return ")) {
            this.code = this.code + "\r\n        return null;";
        }
        this.bodyCode = "";
        ByteBufferChannel byteBufferChannel = new ByteBufferChannel();
        byteBufferChannel.writeEnd(ByteBuffer.wrap(this.code.getBytes()));
        while ((lineCode = byteBufferChannel.readLine()) != null) {
            if (lineCode.trim().startsWith("import ")) {
                if (!this.enableImportInCode) continue;
                this.importCode = this.importCode + lineCode;
                continue;
            }
            this.bodyCode = this.bodyCode + lineCode;
        }
        this.bodyCode = TString.indent(this.bodyCode, 8);
        byteBufferChannel.release();
    }

    private String genCode() {
        this.genImports();
        this.genImportFunction();
        this.genClassName();
        this.genArgCode();
        this.parseCode();
        this.javaCode = TString.tokenReplace(CODE_TEMPLATE, TObject.asMap("PACKAGE", this.packageName, "IMPORT", this.importCode, "IMPORTFUNCTION", this.importFunctionCode, "CLASSNAME", this.className, "PREPAREARG", this.argCode, "CODE", this.bodyCode));
        return this.javaCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileCode() throws ReflectiveOperationException {
        Class clazz = this.clazz;
        synchronized (clazz) {
            if (this.clazz != Object.class && this.codeFile != null) {
                this.checkFileChanged();
            }
            if (this.clazz == Object.class || this.needCompile) {
                this.genCode();
                DynamicCompiler compiler = new DynamicCompiler();
                if (compiler.compileCode(this.javaCode).booleanValue()) {
                    this.clazz = compiler.getClazz();
                    this.className = this.clazz.getCanonicalName();
                    this.needCompile = false;
                } else {
                    Logger.simple(this.code);
                    throw new ReflectiveOperationException("Compile code error.");
                }
            }
        }
    }

    private void checkFileChanged() {
        if (this.lastFileTimeStamp != this.codeFile.lastModified()) {
            this.lastFileTimeStamp = this.codeFile.lastModified();
            this.needCompile = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(Object ... args) throws ReflectiveOperationException {
        Class clazz = this.clazz;
        synchronized (clazz) {
            this.compileCode();
            Object result = TReflect.invokeMethod((Object)this.clazz, "execute", new Object[]{args});
            return result;
        }
    }
}

