/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.compiler.clazz;

import java.io.File;
import java.io.UnsupportedEncodingException;
import org.voovan.tools.TFile;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.compiler.DynamicCompiler;
import org.voovan.tools.compiler.DynamicCompilerManager;
import org.voovan.tools.log.Logger;

public class DynamicClass {
    private String name;
    private String className;
    private String codeClassName;
    private String code;
    private String javaCode;
    private Class clazz;
    private File codeFile;
    private String fileCharset;
    private long lastFileTimeStamp;
    private boolean needCompile;

    public DynamicClass(String name, String code) {
        this.init();
        this.name = name;
        this.code = code;
        DynamicCompilerManager.addClazz(this);
    }

    public DynamicClass(File file, String charset) throws UnsupportedEncodingException {
        this.init();
        String fileName = TFile.getFileName(file.getPath());
        this.name = fileName.substring(0, fileName.lastIndexOf("."));
        this.codeFile = file;
        this.fileCharset = charset;
        this.lastFileTimeStamp = file.lastModified();
        DynamicCompilerManager.addClazz(this);
    }

    private void init() {
        this.name = null;
        this.code = null;
        this.clazz = Object.class;
        this.codeFile = null;
        this.needCompile = true;
        this.needCompile = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        if (this.codeFile != null) {
            try {
                this.code = new String(TFile.loadFile(this.codeFile), this.fileCharset);
            }
            catch (UnsupportedEncodingException e) {
                Logger.error("Load file " + this.codeFile.getPath() + " error", e);
            }
        }
        this.codeClassName = DynamicCompiler.getClassNameFromCode(this.code);
        return this.code;
    }

    public void setCode(String code) {
        if (this.codeFile != null) {
            throw new RuntimeException("This function used code in file, Can't invoke this method.");
        }
        this.code = code;
        this.needCompile = true;
    }

    public String getClassName() {
        return this.className;
    }

    public Class getClazz() {
        if (this.clazz != Object.class && this.codeFile != null) {
            this.checkFileChanged();
        }
        if (this.clazz == Object.class || this.needCompile) {
            try {
                this.compileCode();
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
                this.clazz = null;
            }
        }
        return this.clazz;
    }

    private void genClassName() {
        this.className = this.codeClassName + "_VDC_" + TString.generateShortUUID();
    }

    private String genCode() {
        this.getCode();
        String javaCode = TString.fastReplaceAll(this.code, "class +" + this.codeClassName, "class {{CLASSNAME}}");
        this.genClassName();
        this.javaCode = TString.tokenReplace(javaCode, TObject.asMap("CLASSNAME", this.className));
        return this.javaCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileCode() throws ReflectiveOperationException {
        if (this.clazz != Object.class && this.codeFile != null) {
            this.checkFileChanged();
        }
        if (this.clazz == Object.class || this.needCompile) {
            Class clazz = this.clazz;
            synchronized (clazz) {
                this.genCode();
                DynamicCompiler compiler = new DynamicCompiler();
                if (!compiler.compileCode(this.javaCode).booleanValue()) {
                    Logger.simple(this.code);
                    throw new ReflectiveOperationException("Compile code error.");
                }
                this.clazz = compiler.getClazz();
                this.className = this.clazz.getCanonicalName();
                this.needCompile = false;
            }
        }
    }

    private void checkFileChanged() {
        if (this.lastFileTimeStamp != this.codeFile.lastModified()) {
            this.lastFileTimeStamp = this.codeFile.lastModified();
            this.needCompile = true;
        }
    }
}

