/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.compiler;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.tools.compiler.clazz.DynamicClass;
import org.voovan.tools.compiler.function.DynamicFunction;
import org.voovan.tools.reflect.TReflect;

public class DynamicCompilerManager {
    private static Map<String, DynamicFunction> functions = new ConcurrentHashMap<String, DynamicFunction>();
    private static Map<String, DynamicClass> classes = new ConcurrentHashMap<String, DynamicClass>();

    public static DynamicFunction addFunction(File file, String charSet) throws UnsupportedEncodingException, ReflectiveOperationException {
        DynamicFunction dynamicFunction = new DynamicFunction(file, charSet);
        dynamicFunction.compileCode();
        functions.put(dynamicFunction.getName(), dynamicFunction);
        return dynamicFunction;
    }

    public static DynamicFunction addFunction(File file) throws UnsupportedEncodingException, ReflectiveOperationException {
        DynamicFunction dynamicFunction = new DynamicFunction(file, "UTF-8");
        dynamicFunction.compileCode();
        functions.put(dynamicFunction.getName(), dynamicFunction);
        return dynamicFunction;
    }

    public static DynamicFunction addFunction(String name, String code) throws ReflectiveOperationException {
        DynamicFunction dynamicFunction = new DynamicFunction(name, code);
        dynamicFunction.compileCode();
        functions.put(dynamicFunction.getName(), dynamicFunction);
        return dynamicFunction;
    }

    public static DynamicFunction addFunction(DynamicFunction dynamicFunction) {
        functions.put(dynamicFunction.getName(), dynamicFunction);
        return dynamicFunction;
    }

    public static DynamicFunction getFunctions(String name) {
        return functions.get(name);
    }

    public static void removeFunctions(String name) {
        functions.remove(name);
    }

    public static Map<String, DynamicFunction> getFunctions() {
        return functions;
    }

    public static Object callFunction(String name, Object ... args) throws ReflectiveOperationException {
        return functions.get(name).call(args);
    }

    public static DynamicClass addClazz(File file, String charSet) throws UnsupportedEncodingException, ReflectiveOperationException {
        DynamicClass dynamicClass = new DynamicClass(file, charSet);
        dynamicClass.compileCode();
        classes.put(dynamicClass.getName(), dynamicClass);
        return dynamicClass;
    }

    public static DynamicClass addClazz(File file) throws UnsupportedEncodingException, ReflectiveOperationException {
        DynamicClass dynamicClass = new DynamicClass(file, "UTF-8");
        dynamicClass.compileCode();
        classes.put(dynamicClass.getName(), dynamicClass);
        return dynamicClass;
    }

    public static DynamicClass addClazz(String name, String code) throws ReflectiveOperationException {
        DynamicClass dynamicClass = new DynamicClass(name, code);
        dynamicClass.compileCode();
        classes.put(dynamicClass.getName(), dynamicClass);
        return dynamicClass;
    }

    public static DynamicClass addClazz(DynamicClass dynamicClass) {
        classes.put(dynamicClass.getName(), dynamicClass);
        return dynamicClass;
    }

    public static DynamicClass getClazz(String name) {
        return classes.get(name);
    }

    public static void removeClazz(String name) {
        classes.remove(name);
    }

    public static Map<String, DynamicClass> getClazzs() {
        return classes;
    }

    public static <T> T newInstance(String name, Object ... args) throws ReflectiveOperationException {
        return TReflect.newInstance(classes.get(name).getClazz(), args);
    }
}

