/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.voovan.tools.TObject;
import org.voovan.tools.compiler.DynamicClassLoader;
import org.voovan.tools.compiler.JavaMemClass;
import org.voovan.tools.compiler.JavaMemSource;
import org.voovan.tools.compiler.MemFileManager;
import org.voovan.tools.log.Logger;

public class DynamicCompiler {
    private static DynamicClassLoader classLoader = new DynamicClassLoader(DynamicCompiler.class.getClassLoader());
    private JavaCompiler compiler = null;
    private JavaFileManager fileManager = null;
    private List<String> options = new ArrayList<String>();
    private DiagnosticCollector<JavaFileObject> diagnosticCollector;
    private Class clazz = null;

    public DynamicCompiler() {
        this.compiler = this.getComplier();
        this.diagnosticCollector = new DiagnosticCollector();
    }

    public DynamicCompiler(String classPath, String extDirs, String classDir) {
        if (classPath != null) {
            this.options.addAll(TObject.asList("-classpath", classPath));
        }
        if (classDir != null) {
            this.options.addAll(TObject.asList("-d", classDir));
        }
        if (extDirs != null) {
            this.options.addAll(TObject.asList("-extdirs", extDirs));
        }
        this.compiler = this.getComplier();
        this.diagnosticCollector = new DiagnosticCollector();
    }

    public Class getClazz() {
        return this.clazz;
    }

    private JavaCompiler getComplier() {
        return ToolProvider.getSystemJavaCompiler();
    }

    public Boolean compileCode(String javaSourceCode) {
        String className = DynamicCompiler.getClassNameFromCode(javaSourceCode);
        this.fileManager = new MemFileManager(this.compiler.getStandardFileManager(this.diagnosticCollector, null, null), classLoader);
        JavaMemSource file = new JavaMemSource(className, javaSourceCode);
        List<JavaFileObject> compilationUnits = Arrays.asList(file);
        return this.basicCompileCode(compilationUnits);
    }

    public Boolean compileCode(List<String> javaFileNameList) {
        this.fileManager = this.compiler.getStandardFileManager(this.diagnosticCollector, null, null);
        StandardJavaFileManager standardJavaFileManager = (StandardJavaFileManager)this.fileManager;
        Iterable<? extends JavaFileObject> compilationUnits = standardJavaFileManager.getJavaFileObjectsFromStrings(javaFileNameList);
        return this.basicCompileCode(compilationUnits);
    }

    public Boolean compileCode(File[] javaFileArray) {
        this.fileManager = this.compiler.getStandardFileManager(this.diagnosticCollector, null, null);
        StandardJavaFileManager standardJavaFileManager = (StandardJavaFileManager)this.fileManager;
        Iterable<? extends JavaFileObject> compilationUnits = standardJavaFileManager.getJavaFileObjects(javaFileArray);
        return this.basicCompileCode(compilationUnits);
    }

    public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
        return this.diagnosticCollector.getDiagnostics();
    }

    private Boolean basicCompileCode(Iterable<? extends JavaFileObject> compilationUnits) {
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.fileManager, this.diagnosticCollector, this.options, null, compilationUnits);
        Boolean success = task.call();
        if (success.booleanValue() && this.fileManager instanceof MemFileManager) {
            MemFileManager memFileManager = (MemFileManager)this.fileManager;
            JavaMemClass javaMemClass = memFileManager.getJavaMemClass();
            this.clazz = javaMemClass.loadThisClass();
        } else {
            this.clazz = null;
            String message = "";
            for (Diagnostic<JavaFileObject> diagnostics : this.diagnosticCollector.getDiagnostics()) {
                message = message + "\r\n" + diagnostics.toString();
            }
            Logger.error("Compile code error :", new Exception(message));
        }
        if (this.fileManager != null) {
            try {
                this.fileManager.close();
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
        return success;
    }

    public static Class getClassByName(String className) throws ClassNotFoundException {
        return classLoader.loadClass(className);
    }

    public static String getClassNameFromCode(String javaSourceCode) {
        String className = javaSourceCode.substring(javaSourceCode.indexOf(" class ") + 7, javaSourceCode.indexOf("{")).trim();
        int spaceIndex = className.indexOf(" ");
        if (spaceIndex != -1) {
            className = className.substring(0, spaceIndex);
        }
        className = className.trim();
        return className;
    }
}

