/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;

public class SimpleArraySet<E>
extends AbstractSet<E> {
    Object[] elements;
    volatile int size;

    public SimpleArraySet(int cap) {
        this.elements = new Object[cap];
    }

    public E[] getElements() {
        return this.elements;
    }

    public E get(int index) {
        return (E)this.elements[index];
    }

    public void set(int index, E e) {
        this.elements[index] = e;
    }

    public E getAndRemove(int index) {
        Object e = this.elements[index];
        this.elements[index] = null;
        return (E)e;
    }

    @Override
    public boolean add(E selectionKey) {
        this.elements[this.size++] = selectionKey;
        if (this.elements.length == this.size) {
            this.reallocate();
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    private void reallocate() {
        this.elements = Arrays.copyOf(this.elements, this.elements.length << 1);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    public void reset() {
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return "SelectionKeySet.size: " + this.size();
    }
}

