/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.collection.CacheStatic;
import org.voovan.tools.collection.ScanedObject;
import org.voovan.tools.log.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.ScanParams;

public class RedisZSetWithZSet
implements Closeable {
    private JedisPool redisPool;
    private String name = null;
    private int dbIndex = 0;
    private HashMap<String, String> scriptHashMap = new HashMap();

    public RedisZSetWithZSet(String host, int port, int timeout, int poolsize, String name, String password) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = password == null ? new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout) : new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password);
        this.name = name;
    }

    public RedisZSetWithZSet(String host, int port, int timeout, int poolsize, String name) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout);
        this.name = name;
    }

    public RedisZSetWithZSet(String name) {
        this.redisPool = CacheStatic.getDefaultRedisPool();
        this.name = name;
    }

    public RedisZSetWithZSet(JedisPool jedisPool, String name) {
        this.redisPool = jedisPool;
        this.name = name;
    }

    public RedisZSetWithZSet(JedisPool jedisPool) {
        this.redisPool = jedisPool;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    private Jedis getJedis() {
        Jedis Jedis2 = this.redisPool.getResource();
        Jedis2.select(this.dbIndex);
        return Jedis2;
    }

    public void setDbIndex(int dbIndex) {
        this.dbIndex = dbIndex;
    }

    public Object eval(Jedis jedis, String command, double itemName, Object ... values) {
        String params = ", ";
        String cachedKey = command + values.length;
        String scriptHash = this.scriptHashMap.get(cachedKey);
        for (int i = 0; i < values.length; ++i) {
            if (scriptHash == null) {
                params = params + "ARGV[" + (i + 3) + "], ";
            }
            values[i] = values[i].toString();
        }
        List valueList = TObject.asList(this.name, String.valueOf(itemName));
        valueList.addAll(TObject.asList(values));
        if (scriptHash == null) {
            params = TString.removeSuffix(params.trim());
            String script = "local innerKey = redis.call('zcount', ARGV[1], ARGV[2], ARGV[2]);\nif (innerKey == 0) then\n    innerKey = '100000'..ARGV[2];\n    redis.call('zadd', ARGV[1], innerKey, innerKey);\nelse \n    innerKey = ARGV[2];\nend\nreturn redis.call('" + command + "', innerKey" + params + ");";
            scriptHash = jedis.scriptLoad(script);
            this.scriptHashMap.put(cachedKey, scriptHash);
            Logger.fremawork("Create " + cachedKey + ": " + scriptHash);
            System.out.println(script);
            System.out.println(valueList);
        }
        return jedis.evalsha(scriptHash, Collections.emptyList(), valueList);
    }

    private ArrayList convertScoreMembersToArrays(Map<String, Double> scoreMembers) {
        ArrayList<String> args = new ArrayList<String>(scoreMembers.size() * 2);
        for (Map.Entry<String, Double> entry : scoreMembers.entrySet()) {
            args.add(entry.getValue().toString());
            args.add(entry.getKey());
        }
        return args;
    }

    public long addAll(double itemName, Map<String, Double> values) {
        try (Jedis jedis = this.getJedis();){
            long l = (Long)this.eval(jedis, "zadd", itemName, this.convertScoreMembersToArrays(values).toArray());
            return l;
        }
    }

    public long add(double itemName, double score, String value) {
        try (Jedis jedis = this.getJedis();){
            long l = (Long)this.eval(jedis, "zadd", itemName, score, value);
            return l;
        }
    }

    public double increase(double itemName, String value, double score) {
        try (Jedis jedis = this.getJedis();){
            double d = Double.valueOf((String)this.eval(jedis, "zincrby", itemName, score, value));
            return d;
        }
    }

    public long size() {
        try (Jedis jedis = this.getJedis();){
            long l = jedis.zcard(this.name);
            return l;
        }
    }

    public long size(double itemName) {
        try (Jedis jedis = this.getJedis();){
            long l = (Long)this.eval(jedis, "zcard", itemName, new Object[0]);
            return l;
        }
    }

    public long scoreRangeCount(double itemName, double min, double max) {
        try (Jedis jedis = this.getJedis();){
            long l = (Long)this.eval(jedis, "zcount", itemName, min, max);
            return l;
        }
    }

    public long valueRangeCount(double itemName, String min, String max) {
        try (Jedis jedis = this.getJedis();){
            long l = (Long)this.eval(jedis, "zlexcount", itemName, min, max);
            return l;
        }
    }

    public Set<String> getRangeByIndex(double itemName, long start, long end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<String> result = new HashSet<String>();
            result.addAll((Collection)this.eval(jedis, "zrange", itemName, start, end));
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public Set<String> getRevRangeByIndex(double itemName, long start, long end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<String> result = new HashSet<String>();
            result.addAll((Collection)this.eval(jedis, "zrevrange", itemName, start, end));
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public Set<String> getRangeByValue(double itemName, String start, String end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<String> result = new HashSet<String>();
            result.addAll((Collection)this.eval(jedis, "zrangeByLex", itemName, start, end));
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public Set<String> getRangeByValue(double itemName, String start, String end, int offset, int size) {
        try (Jedis jedis = this.getJedis();){
            HashSet<String> result = new HashSet<String>();
            result.addAll((Collection)this.eval(jedis, "zrangeByLex", itemName, start, end, "LIMIT", offset, size));
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public Set<String> getRevRangeByValue(double itemName, String start, String end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<String> result = new HashSet<String>();
            result.addAll((Collection)this.eval(jedis, "zrevrangeByLex", itemName, start, end));
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public Set<String> getRevRangeByValue(double itemName, String start, String end, int offset, int size) {
        try (Jedis jedis = this.getJedis();){
            HashSet<String> result = new HashSet<String>();
            result.addAll((Collection)this.eval(jedis, "zrevrangeByLex", itemName, start, end, "LIMIT", offset, size));
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public Set<String> getRangeByScore(double itemName, double start, double end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<String> result = new HashSet<String>();
            result.addAll((Collection)this.eval(jedis, "zrangeByScore", itemName, start, end));
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public Set<String> getRangeByScore(double itemName, double start, double end, int offset, int size) {
        try (Jedis jedis = this.getJedis();){
            HashSet<String> result = new HashSet<String>();
            result.addAll((Collection)this.eval(jedis, "zrangeByScore", itemName, start, end, "LIMIT", offset, size));
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public Set<String> getRevRangeByScore(double itemName, double start, double end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<String> result = new HashSet<String>();
            result.addAll((Collection)this.eval(jedis, "zrevrangeByScore", itemName, start, end));
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public Set<String> getRevRangeByScore(double itemName, double start, double end, int offset, int size) {
        try (Jedis jedis = this.getJedis();){
            HashSet<String> result = new HashSet<String>();
            result.addAll((Collection)this.eval(jedis, "zrevrangeByScore", itemName, start, end, "LIMIT", offset, size));
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public long indexOf(double itemName, String value) {
        try (Jedis jedis = this.getJedis();){
            long l = (Long)this.eval(jedis, "zrank", itemName, value);
            return l;
        }
    }

    public long revIndexOf(double itemName, String value) {
        try (Jedis jedis = this.getJedis();){
            long l = (Long)this.eval(jedis, "zrevrank", itemName, value);
            return l;
        }
    }

    public long remove(double itemName, String value) {
        try (Jedis jedis = this.getJedis();){
            long l = (Long)this.eval(jedis, "zrem", itemName, value);
            return l;
        }
    }

    public long removeRangeByValue(double itemName, String start, String end) {
        try (Jedis jedis = this.getJedis();){
            long l = (Long)this.eval(jedis, "zremrangeByLex", itemName, start, end);
            return l;
        }
    }

    public long removeRangeByIndex(double itemName, int start, int end) {
        try (Jedis jedis = this.getJedis();){
            long l = (Long)this.eval(jedis, "zremrangeByRank", itemName, start, end);
            return l;
        }
    }

    public long removeRangeByScore(double itemName, double min, double max) {
        try (Jedis jedis = this.getJedis();){
            long l = (Long)this.eval(jedis, "zremrangeByScore", itemName, min, max);
            return l;
        }
    }

    public double getScore(double itemName, String value) {
        try (Jedis jedis = this.getJedis();){
            double d = Double.valueOf((String)this.eval(jedis, "zscore", itemName, value));
            return d;
        }
    }

    public ScanedObject scan(double itemName, String cursor, String matchValue, Integer count) {
        try (Jedis jedis = this.getJedis();){
            ArrayList<Object> paramList = new ArrayList<Object>();
            paramList.add(cursor);
            ScanParams scanParams = new ScanParams();
            if (matchValue != null) {
                paramList.add("MATCH");
                paramList.add(matchValue);
            } else if (count != null) {
                paramList.add("Count");
                paramList.add(count);
            }
            ArrayList resultList = (ArrayList)this.eval(jedis, "zscan", itemName, paramList.toArray());
            Object cursorValue = resultList.get(0);
            ScanedObject scanedObject = new ScanedObject((String)cursorValue);
            for (Object object : (ArrayList)resultList.get(1)) {
                scanedObject.getResultList().add((String)object);
            }
            ScanedObject scanedObject2 = scanedObject;
            return scanedObject2;
        }
    }

    @Override
    public void close() throws IOException {
        this.redisPool.close();
    }
}

