/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.voovan.tools.collection.CacheStatic;
import org.voovan.tools.collection.ScanedObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Tuple;

public class RedisZSet<V>
implements Closeable {
    private JedisPool redisPool;
    private String name = null;
    private int dbIndex = 0;

    public RedisZSet(String host, int port, int timeout, int poolsize, String name, String password) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = password == null ? new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout) : new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password);
        this.name = name;
    }

    public RedisZSet(String host, int port, int timeout, int poolsize, String name) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout);
        this.name = name;
    }

    public RedisZSet(String name) {
        this.redisPool = CacheStatic.getDefaultRedisPool();
        this.name = name;
    }

    public RedisZSet(JedisPool jedisPool, String name) {
        this.redisPool = jedisPool;
        this.name = name;
    }

    public RedisZSet(JedisPool jedisPool) {
        this.redisPool = jedisPool;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    private Jedis getJedis() {
        Jedis Jedis2 = this.redisPool.getResource();
        Jedis2.select(this.dbIndex);
        return Jedis2;
    }

    public void setDbIndex(int dbIndex) {
        this.dbIndex = dbIndex;
    }

    public long addAll(Map<V, Double> values) {
        try (Jedis jedis = this.getJedis();){
            HashMap<byte[], Double> byteMap = new HashMap<byte[], Double>();
            for (Map.Entry<V, Double> value : values.entrySet()) {
                byteMap.put(CacheStatic.serialize(value.getKey()), value.getValue());
            }
            long l = jedis.zadd(this.name.getBytes(), byteMap);
            return l;
        }
    }

    public long add(double score, V value) {
        try (Jedis jedis = this.getJedis();){
            byte[] valueByteArray = CacheStatic.serialize(value);
            long l = jedis.zadd(this.name.getBytes(), score, valueByteArray);
            return l;
        }
    }

    public double increase(V value, double score) {
        try (Jedis jedis = this.getJedis();){
            byte[] valueByteArray = CacheStatic.serialize(value);
            double d = jedis.zincrby(this.name.getBytes(), score, valueByteArray);
            return d;
        }
    }

    public long size() {
        try (Jedis jedis = this.getJedis();){
            long l = jedis.zcard(this.name.getBytes());
            return l;
        }
    }

    public long scoreRangeCount(double min, double max) {
        try (Jedis jedis = this.getJedis();){
            long l = jedis.zcount(this.name.getBytes(), min, max);
            return l;
        }
    }

    public long valueRangeCount(V min, V max) {
        try (Jedis jedis = this.getJedis();){
            byte[] minByteValue = CacheStatic.serialize(min);
            byte[] maxByteValue = CacheStatic.serialize(max);
            long l = jedis.zlexcount(this.name.getBytes(), minByteValue, maxByteValue);
            return l;
        }
    }

    public Set<V> getRangeByIndex(long start, long end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<Object> result = new HashSet<Object>();
            Set bytesSet = jedis.zrange(this.name.getBytes(), start, end);
            for (byte[] objByteArray : bytesSet) {
                result.add(CacheStatic.unserialize(objByteArray));
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
    }

    public Set<V> getRevRangeByIndex(long start, long end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<Object> result = new HashSet<Object>();
            Set bytesSet = jedis.zrevrange(this.name.getBytes(), start, end);
            for (byte[] objByteArray : bytesSet) {
                result.add(CacheStatic.unserialize(objByteArray));
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
    }

    public Set<V> getRrangeByValue(V start, V end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<Object> result = new HashSet<Object>();
            byte[] startByteArray = CacheStatic.serialize(start);
            byte[] endByteArray = CacheStatic.serialize(end);
            Set bytesSet = jedis.zrangeByLex(this.name.getBytes(), startByteArray, endByteArray);
            for (byte[] objByteArray : bytesSet) {
                result.add(CacheStatic.unserialize(objByteArray));
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
    }

    public Set<V> getRangeByValue(V start, V end, int offset, int size) {
        try (Jedis jedis = this.getJedis();){
            HashSet<Object> result = new HashSet<Object>();
            byte[] startByteArray = CacheStatic.serialize(start);
            byte[] endByteArray = CacheStatic.serialize(end);
            Set bytesSet = jedis.zrangeByLex(this.name.getBytes(), startByteArray, endByteArray, offset, size);
            for (byte[] objByteArray : bytesSet) {
                result.add(CacheStatic.unserialize(objByteArray));
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
    }

    public Set<V> getRevRangeByValue(V start, V end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<Object> result = new HashSet<Object>();
            byte[] startByteArray = CacheStatic.serialize(start);
            byte[] endByteArray = CacheStatic.serialize(end);
            Set bytesSet = jedis.zrevrangeByLex(this.name.getBytes(), startByteArray, endByteArray);
            for (byte[] objByteArray : bytesSet) {
                result.add(CacheStatic.unserialize(objByteArray));
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
    }

    public Set<V> getRevRangeByValue(V start, V end, int offset, int size) {
        try (Jedis jedis = this.getJedis();){
            HashSet<Object> result = new HashSet<Object>();
            byte[] startByteArray = CacheStatic.serialize(start);
            byte[] endByteArray = CacheStatic.serialize(end);
            Set bytesSet = jedis.zrevrangeByLex(this.name.getBytes(), startByteArray, endByteArray, offset, size);
            for (byte[] objByteArray : bytesSet) {
                result.add(CacheStatic.unserialize(objByteArray));
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
    }

    public Set<V> getRangeByScore(double start, double end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<Object> result = new HashSet<Object>();
            byte[] startByteArray = CacheStatic.serialize(start);
            byte[] endByteArray = CacheStatic.serialize(end);
            Set bytesSet = jedis.zrangeByScore(this.name.getBytes(), startByteArray, endByteArray);
            for (byte[] objByteArray : bytesSet) {
                result.add(CacheStatic.unserialize(objByteArray));
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
    }

    public Set<V> getRangeByScore(double start, double end, int offset, int size) {
        try (Jedis jedis = this.getJedis();){
            HashSet<Object> result = new HashSet<Object>();
            byte[] startByteArray = CacheStatic.serialize(start);
            byte[] endByteArray = CacheStatic.serialize(end);
            Set bytesSet = jedis.zrangeByScore(this.name.getBytes(), startByteArray, endByteArray, offset, size);
            for (byte[] objByteArray : bytesSet) {
                result.add(CacheStatic.unserialize(objByteArray));
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
    }

    public Set<V> getRevRangeByScore(double start, double end) {
        try (Jedis jedis = this.getJedis();){
            HashSet<Object> result = new HashSet<Object>();
            byte[] startByteArray = CacheStatic.serialize(start);
            byte[] endByteArray = CacheStatic.serialize(end);
            Set bytesSet = jedis.zrevrangeByScore(this.name.getBytes(), startByteArray, endByteArray);
            for (byte[] objByteArray : bytesSet) {
                result.add(CacheStatic.unserialize(objByteArray));
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
    }

    public Set<V> getRevRangeByScore(double start, double end, int offset, int size) {
        try (Jedis jedis = this.getJedis();){
            HashSet<Object> result = new HashSet<Object>();
            byte[] startByteArray = CacheStatic.serialize(start);
            byte[] endByteArray = CacheStatic.serialize(end);
            Set bytesSet = jedis.zrevrangeByScore(this.name.getBytes(), startByteArray, endByteArray, offset, size);
            for (byte[] objByteArray : bytesSet) {
                result.add(CacheStatic.unserialize(objByteArray));
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
    }

    public long indexOf(V value) {
        try (Jedis jedis = this.getJedis();){
            HashSet result = new HashSet();
            byte[] valueByteArray = CacheStatic.serialize(value);
            long l = jedis.zrank(this.name.getBytes(), valueByteArray);
            return l;
        }
    }

    public long revIndexOf(V value) {
        try (Jedis jedis = this.getJedis();){
            HashSet result = new HashSet();
            byte[] valueByteArray = CacheStatic.serialize(value);
            long l = jedis.zrevrank(this.name.getBytes(), valueByteArray);
            return l;
        }
    }

    public long remove(V value) {
        try (Jedis jedis = this.getJedis();){
            HashSet result = new HashSet();
            byte[] valueByteArray = CacheStatic.serialize(value);
            long l = jedis.zrem(this.name.getBytes(), (byte[][])new byte[][]{valueByteArray});
            return l;
        }
    }

    public long removeRangeByValue(V start, V end) {
        try (Jedis jedis = this.getJedis();){
            byte[] startByteArray = CacheStatic.serialize(start);
            byte[] endByteArray = CacheStatic.serialize(end);
            long l = jedis.zremrangeByLex(this.name.getBytes(), startByteArray, endByteArray);
            return l;
        }
    }

    public long removeRangeByIndex(int start, int end) {
        try (Jedis jedis = this.getJedis();){
            long l = jedis.zremrangeByRank(this.name.getBytes(), (long)start, (long)end);
            return l;
        }
    }

    public long removeRangeByScore(double min, double max) {
        try (Jedis jedis = this.getJedis();){
            long l = jedis.zremrangeByScore(this.name.getBytes(), min, max);
            return l;
        }
    }

    public double getScore(V value) {
        try (Jedis jedis = this.getJedis();){
            byte[] valueByteArray = CacheStatic.serialize(value);
            double d = jedis.zscore(this.name.getBytes(), valueByteArray);
            return d;
        }
    }

    public ScanedObject scan(String cursor, V matchValue, Integer count) {
        try (Jedis jedis = this.getJedis();){
            byte[] matchValueByteArray = CacheStatic.serialize(matchValue);
            ScanParams scanParams = new ScanParams();
            if (matchValue != null) {
                scanParams.match(matchValueByteArray);
            }
            if (count != null) {
                scanParams.count(count);
            }
            ScanResult scanResult = jedis.zscan(this.name.getBytes(), cursor.getBytes(), scanParams);
            ScanedObject scanedObject = new ScanedObject(scanResult.getStringCursor());
            for (Tuple tuple : scanResult.getResult()) {
                scanedObject.getResultList().add(CacheStatic.unserialize(tuple.getBinaryElement()));
            }
            ScanedObject scanedObject2 = scanedObject;
            return scanedObject2;
        }
    }

    @Override
    public void close() throws IOException {
        this.redisPool.close();
    }
}

