/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.collection.CacheStatic;
import org.voovan.tools.log.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisMapWithList
implements Closeable {
    private JedisPool redisPool;
    private String name = null;
    private int dbIndex = 0;
    private HashMap<String, String> scriptHashMap = new HashMap();

    public RedisMapWithList(String host, int port, int timeout, int poolsize, String name, String password) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = password == null ? new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout) : new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password);
        this.name = name;
    }

    public RedisMapWithList(String host, int port, int timeout, int poolsize, String name) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout);
        this.name = name;
    }

    public RedisMapWithList(String name) {
        this.redisPool = CacheStatic.getDefaultRedisPool();
        this.name = name;
    }

    public RedisMapWithList(JedisPool jedisPool, String name) {
        this.redisPool = jedisPool;
        this.name = name;
    }

    public RedisMapWithList(JedisPool jedisPool) {
        this.redisPool = jedisPool;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    private Jedis getJedis() {
        Jedis Jedis2 = this.redisPool.getResource();
        Jedis2.select(this.dbIndex);
        return Jedis2;
    }

    public void setDbIndex(int dbIndex) {
        this.dbIndex = dbIndex;
    }

    public Object eval(Jedis jedis, String command, String itemName, Object ... values) {
        String params = ", ";
        String cachedKey = command + values.length;
        String scriptHash = this.scriptHashMap.get(cachedKey);
        for (int i = 0; i < values.length; ++i) {
            if (scriptHash == null) {
                params = params + "ARGV[" + (i + 3) + "], ";
            }
            values[i] = values[i].toString();
        }
        List valueList = TObject.asList(this.name, itemName);
        valueList.addAll(TObject.asList(values));
        if (scriptHash == null) {
            params = TString.removeSuffix(params.trim());
            String script = "local innerKey = redis.call('HEXISTS', ARGV[1], ARGV[2]);\nif (innerKey == 0) then\n    innerKey = tostring(ARGV[1])..'-'..tostring(ARGV[2]);\n    redis.call('hset', ARGV[1], innerKey, innerKey);\nelse \n    innerKey = tostring(ARGV[1])..'-'..tostring(ARGV[2]);\nend\nreturn redis.call('" + command + "', innerKey" + params + ");";
            scriptHash = jedis.scriptLoad(script);
            this.scriptHashMap.put(cachedKey, scriptHash);
            Logger.fremawork("Create " + cachedKey + ": " + scriptHash);
            System.out.println(script);
        }
        return jedis.evalsha(scriptHash, Collections.emptyList(), valueList);
    }

    private ArrayList convertScoreMembersToArrays(Map<String, Double> scoreMembers) {
        ArrayList<String> args = new ArrayList<String>(scoreMembers.size() * 2);
        for (Map.Entry<String, Double> entry : scoreMembers.entrySet()) {
            args.add(entry.getValue().toString());
            args.add(entry.getKey());
        }
        return args;
    }

    public int size() {
        try (Jedis jedis = this.getJedis();){
            int n = Long.valueOf(jedis.hlen(this.name)).intValue();
            return n;
        }
    }

    public int size(String itemName) {
        try (Jedis jedis = this.getJedis();){
            int n = (Integer)this.eval(jedis, "zcard", itemName, new Object[0]);
            return n;
        }
    }

    public String get(String itemName, int index) {
        try (Jedis jedis = this.getJedis();){
            String string = (String)this.eval(jedis, "lindex", itemName, index);
            return string;
        }
    }

    public String set(String itemName, int index, String element) {
        try (Jedis jedis = this.getJedis();){
            String string = (String)this.eval(jedis, "lset", itemName, index, element);
            return string;
        }
    }

    public boolean add(String itemName, String s) {
        return this.offerLast(itemName, s);
    }

    public boolean offer(String itemName, String s) {
        return this.offerLast(itemName, s);
    }

    public boolean offerFirst(String itemName, String s) {
        try (Jedis jedis = this.getJedis();){
            this.eval(jedis, "lpush", itemName, s);
            boolean bl = true;
            return bl;
        }
    }

    public boolean offerLast(String itemName, String s) {
        try (Jedis jedis = this.getJedis();){
            this.eval(jedis, "rpush", itemName, s);
            boolean bl = true;
            return bl;
        }
    }

    public void addFirst(String itemName, String s) {
        this.offerFirst(itemName, s);
    }

    public void addLast(String itemName, String s) {
        this.offerLast(itemName, s);
    }

    public String removeFirst(String itemName) {
        try (Jedis jedis = this.getJedis();){
            String string = (String)this.eval(jedis, "lpop", itemName, new Object[0]);
            return string;
        }
    }

    public String removeLast(String itemName) {
        try (Jedis jedis = this.getJedis();){
            String string = (String)this.eval(jedis, "lpop", itemName, new Object[0]);
            return string;
        }
    }

    public List<String> removeFirst(String itemName, int timeout) {
        try (Jedis jedis = this.getJedis();){
            List list = (List)this.eval(jedis, "blpop", itemName, new Object[0]);
            return list;
        }
    }

    public List<String> removeLast(String itemName, int timeout) {
        try (Jedis jedis = this.getJedis();){
            List list = (List)this.eval(jedis, "brpop", itemName, new Object[0]);
            return list;
        }
    }

    public String pollFirst(String itemName) {
        return this.removeFirst(itemName);
    }

    public String pollLast(String itemName) {
        return this.removeLast(itemName);
    }

    public String getFirst(String itemName) {
        try (Jedis jedis = this.getJedis();){
            String string = (String)this.eval(jedis, "lindex", itemName, 0);
            return string;
        }
    }

    public String getLast(String itemName) {
        try (Jedis jedis = this.getJedis();){
            String string = (String)this.eval(jedis, "lindex", itemName, -1);
            return string;
        }
    }

    public String peekFirst(String itemName) {
        return this.getFirst(itemName);
    }

    public String peekLast(String itemName) {
        return this.getLast(itemName);
    }

    public String remove(String itemName) {
        return this.removeFirst(itemName);
    }

    public String remove(String itemName, int index) {
        try (Jedis jedis = this.getJedis();){
            String value = this.get(itemName, index);
            this.eval(jedis, "lrem", itemName, 1, value);
            String string = value;
            return string;
        }
    }

    public String poll(String itemName) {
        return this.pollFirst(itemName);
    }

    public String element(String itemName) {
        return this.getFirst(itemName);
    }

    public String peek(String itemName) {
        return this.peekFirst(itemName);
    }

    public void push(String itemName, String s) {
        this.addFirst(itemName, s);
    }

    public String pop(String itemName) {
        return this.removeFirst(itemName);
    }

    public boolean trim(String itemName, int start, int end) {
        try (Jedis jedis = this.getJedis();){
            boolean bl = this.eval(jedis, "lrem", itemName, start, end).equals("OK");
            return bl;
        }
    }

    public List<String> range(String itemName, int start, int end) {
        try (Jedis jedis = this.getJedis();){
            List list = (List)this.eval(jedis, "lrange", itemName, start, end);
            return list;
        }
    }

    @Override
    public void close() throws IOException {
        this.redisPool.close();
    }
}

