/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.voovan.tools.collection.CacheStatic;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisList<V>
implements List<V>,
Deque<V>,
Closeable {
    private JedisPool redisPool;
    private String name = null;
    private int dbIndex = 0;

    public RedisList(String host, int port, int timeout, int poolsize, String name, String password) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = password == null ? new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout) : new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password);
        this.name = name;
    }

    public RedisList(String host, int port, int timeout, int poolsize, String name) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(poolsize);
        poolConfig.setMaxTotal(poolsize);
        this.redisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout);
        this.name = name;
    }

    public RedisList(String name) {
        this.redisPool = CacheStatic.getDefaultRedisPool();
        this.name = name;
    }

    public RedisList(JedisPool jedisPool, String name) {
        this.redisPool = jedisPool;
        this.name = name;
    }

    public RedisList(JedisPool jedisPool) {
        this.redisPool = jedisPool;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    private Jedis getJedis() {
        Jedis Jedis2 = this.redisPool.getResource();
        Jedis2.select(this.dbIndex);
        return Jedis2;
    }

    public void setDbIndex(int dbIndex) {
        this.dbIndex = dbIndex;
    }

    @Override
    public void close() throws IOException {
        this.redisPool.close();
    }

    @Override
    public int size() {
        try (Jedis jedis = this.getJedis();){
            int n = Long.valueOf(jedis.llen(this.name)).intValue();
            return n;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<V> iterator() {
        return new RedisListIterator(this, false);
    }

    @Override
    public Iterator<V> descendingIterator() {
        return new RedisListIterator(this, true);
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offerFirst(V s) {
        try (Jedis jedis = this.getJedis();){
            jedis.lpush(this.name.getBytes(), (byte[][])new byte[][]{CacheStatic.serialize(s)});
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean offerLast(V s) {
        try (Jedis jedis = this.getJedis();){
            jedis.rpush(this.name.getBytes(), (byte[][])new byte[][]{CacheStatic.serialize(s)});
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void addFirst(V s) {
        this.offerFirst(s);
    }

    @Override
    public void addLast(V s) {
        this.offerLast(s);
    }

    @Override
    public V removeFirst() {
        try (Jedis jedis = this.getJedis();){
            Object object = CacheStatic.unserialize(jedis.lpop(this.name.getBytes()));
            return (V)object;
        }
    }

    @Override
    public V removeLast() {
        try (Jedis jedis = this.getJedis();){
            Object object = CacheStatic.unserialize(jedis.rpop(this.name.getBytes()));
            return (V)object;
        }
    }

    public List<V> removeFirst(int timeout) {
        try (Jedis jedis = this.getJedis();){
            ArrayList<Object> result = new ArrayList<Object>();
            List queryResult = jedis.blpop(timeout, (byte[][])new byte[][]{this.name.getBytes()});
            for (byte[] bytes : queryResult) {
                result.add(CacheStatic.unserialize(bytes));
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
    }

    public List<V> removeLast(int timeout) {
        try (Jedis jedis = this.getJedis();){
            ArrayList<Object> result = new ArrayList<Object>();
            List queryResult = jedis.brpop(timeout, (byte[][])new byte[][]{this.name.getBytes()});
            for (byte[] bytes : queryResult) {
                result.add(CacheStatic.unserialize(bytes));
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
    }

    @Override
    public V pollFirst() {
        return this.removeFirst();
    }

    @Override
    public V pollLast() {
        return this.removeLast();
    }

    @Override
    public V getFirst() {
        try (Jedis jedis = this.getJedis();){
            Object object = CacheStatic.unserialize(jedis.lindex(this.name.getBytes(), 0L));
            return (V)object;
        }
    }

    @Override
    public V getLast() {
        try (Jedis jedis = this.getJedis();){
            Object object = CacheStatic.unserialize(jedis.lindex(this.name.getBytes(), -1L));
            return (V)object;
        }
    }

    @Override
    public V peekFirst() {
        return this.getFirst();
    }

    @Override
    public V peekLast() {
        return this.getLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        try (Jedis jedis = this.getJedis();){
            int rmCount = Long.valueOf(jedis.lrem(this.name, 1L, o.toString())).intValue();
            boolean bl = rmCount > 0;
            return bl;
        }
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        try (Jedis jedis = this.getJedis();){
            int rmCount = Long.valueOf(jedis.lrem(this.name, -1L, o.toString())).intValue();
            boolean bl = rmCount > 0;
            return bl;
        }
    }

    @Override
    public boolean add(V s) {
        return this.offerLast(s);
    }

    @Override
    public boolean offer(V s) {
        return this.offerLast(s);
    }

    @Override
    public V remove() {
        return this.removeFirst();
    }

    @Override
    public V poll() {
        return this.pollFirst();
    }

    @Override
    public V element() {
        return this.getFirst();
    }

    @Override
    public V peek() {
        return this.peekFirst();
    }

    @Override
    public void push(V s) {
        this.addFirst(s);
    }

    @Override
    public V pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object o) {
        try (Jedis jedis = this.getJedis();){
            int rmCount = Long.valueOf(jedis.lrem(this.name, 0L, o.toString())).intValue();
            boolean bl = rmCount > 0;
            return bl;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        for (V item : c) {
            this.add(item);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) {
        try (Jedis jedis = this.getJedis();){
            byte[] pivot = jedis.lindex(this.name.getBytes(), (long)index);
            for (V item : c) {
                jedis.linsert(this.name.getBytes(), BinaryClient.LIST_POSITION.AFTER, pivot, CacheStatic.serialize(item));
            }
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        try (Jedis jedis = this.getJedis();){
            for (Object item : c) {
                this.remove(c);
            }
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(int index) {
        try (Jedis jedis = this.getJedis();){
            Object object = CacheStatic.unserialize(jedis.lindex(this.name.getBytes(), (long)index));
            return (V)object;
        }
    }

    @Override
    public V set(int index, V element) {
        try (Jedis jedis = this.getJedis();){
            jedis.lset(this.name.getBytes(), (long)index, CacheStatic.serialize(element));
            V v = element;
            return v;
        }
    }

    @Override
    public void add(int index, V element) {
        try (Jedis jedis = this.getJedis();){
            byte[] pivot = jedis.lindex(this.name.getBytes(), (long)index);
            jedis.linsert(this.name.getBytes(), BinaryClient.LIST_POSITION.AFTER, pivot, CacheStatic.serialize(element));
        }
    }

    @Override
    public V remove(int index) {
        try (Jedis jedis = this.getJedis();){
            V value = this.get(index);
            jedis.lrem(this.name.getBytes(), 1L, CacheStatic.serialize(value));
            V v = value;
            return v;
        }
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<V> listIterator() {
        return new RedisListIterator(this, false);
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<V> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public boolean trim(int start, int end) {
        try (Jedis jedis = this.getJedis();){
            boolean bl = jedis.ltrim(this.name, Long.valueOf(start).longValue(), Long.valueOf(end).longValue()).contains("OK");
            return bl;
        }
    }

    public List<V> range(int start, int end) {
        try (Jedis jedis = this.getJedis();){
            ArrayList<Object> result = new ArrayList<Object>();
            List queryResult = jedis.lrange(this.name.getBytes(), Long.valueOf(start).longValue(), Long.valueOf(end).longValue());
            for (byte[] bytes : queryResult) {
                result.add(CacheStatic.unserialize(bytes));
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
    }

    public class RedisListIterator
    implements ListIterator<V> {
        private RedisList redisList;
        private int size = 0;
        private int position = 0;
        private boolean isDesc;

        public RedisListIterator(RedisList redisList, boolean isDesc) {
            this.isDesc = isDesc;
            if (isDesc) {
                this.position = this.size = redisList.size();
            } else {
                this.size = redisList.size();
                this.redisList = redisList;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.isDesc) {
                return this.position > 0;
            }
            return this.position < RedisList.this.size();
        }

        @Override
        public V next() {
            if (this.position == this.size) {
                return null;
            }
            Object value = this.redisList.get(this.position);
            this.position = this.isDesc ? --this.position : ++this.position;
            return value;
        }

        @Override
        public boolean hasPrevious() {
            if (this.isDesc) {
                return this.position < RedisList.this.size();
            }
            return this.position > 0;
        }

        @Override
        public V previous() {
            if (this.position == 0) {
                return null;
            }
            Object value = this.redisList.get(this.position);
            this.position = this.isDesc ? ++this.position : --this.position;
            return value;
        }

        @Override
        public int nextIndex() {
            if (this.isDesc) {
                return this.position - 1 < 0 ? -1 : this.position - 1;
            }
            int size = RedisList.this.size();
            return this.position + 1 > size ? size : this.position + 1;
        }

        @Override
        public int previousIndex() {
            if (this.isDesc) {
                int size = RedisList.this.size();
                return this.position + 1 > size ? size : this.position + 1;
            }
            return this.position - 1 < -1 ? 0 : this.position - 1;
        }

        @Override
        public void remove() {
            this.redisList.remove(this.position);
        }

        @Override
        public void set(V s) {
            this.redisList.set(this.position, s);
        }

        @Override
        public void add(V s) {
            this.redisList.add(this.position, s);
        }
    }
}

