/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.LinkedList;
import java.util.function.Supplier;
import org.voovan.tools.FastThreadLocal;

public class ObjectThreadPool<T> {
    private final FastThreadLocal<LinkedList<T>> THREAD_LOCAL_POOL = FastThreadLocal.withInitial(() -> new LinkedList());
    private int threadLocalMaxSize = 4;

    public ObjectThreadPool() {
    }

    public ObjectThreadPool(int threadLocalMaxSize) {
        this.threadLocalMaxSize = threadLocalMaxSize;
    }

    public int getThreadLocalMaxSize() {
        return this.threadLocalMaxSize;
    }

    public void setThreadLocalMaxSize(int threadLocalMaxSize) {
        this.threadLocalMaxSize = threadLocalMaxSize;
    }

    public LinkedList<T> getThreadLoaclPool() {
        return this.THREAD_LOCAL_POOL.get();
    }

    public T get(Supplier<T> supplier) {
        LinkedList<T> threadLocalPool = this.getThreadLoaclPool();
        T t = threadLocalPool.poll();
        if (t == null) {
            t = supplier.get();
        }
        return t;
    }

    public void release(T t, Supplier destory) {
        LinkedList<T> threadLocalPool = this.getThreadLoaclPool();
        if (threadLocalPool.size() < this.threadLocalMaxSize) {
            threadLocalPool.offer(t);
        } else {
            destory.get();
        }
    }
}

