/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import java.util.function.Supplier;
import org.voovan.Global;
import org.voovan.tools.TEnv;
import org.voovan.tools.TString;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.json.JSON;
import org.voovan.tools.json.annotation.NotJSON;

public class ObjectPool {
    private volatile ConcurrentHashMap<Object, PooledObject> objects = new ConcurrentHashMap();
    private volatile ConcurrentLinkedDeque<Object> unborrowedObjectIdList = new ConcurrentLinkedDeque();
    private long aliveTime = 0L;
    private boolean autoRefreshOnGet = true;
    private Function destory;
    private Supplier supplier = null;
    private int minSize = 0;
    private int maxSize = Integer.MAX_VALUE;
    private int interval = 5;

    public ObjectPool(long aliveTime, boolean autoRefreshOnGet) {
        this.aliveTime = aliveTime;
        this.autoRefreshOnGet = autoRefreshOnGet;
    }

    public ObjectPool(long aliveTime) {
        this.aliveTime = aliveTime;
    }

    public ObjectPool() {
    }

    public long getAliveTime() {
        return this.aliveTime;
    }

    public ObjectPool autoRefreshOnGet(boolean autoRefreshOnGet) {
        this.autoRefreshOnGet = autoRefreshOnGet;
        return this;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public ObjectPool minSize(int minSize) {
        this.minSize = minSize;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public ObjectPool maxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public int getInterval() {
        return this.interval;
    }

    public ObjectPool interval(int interval) {
        this.interval = interval;
        return this;
    }

    public Supplier getSupplier() {
        return this.supplier;
    }

    public ObjectPool supplier(Supplier supplier) {
        this.supplier = supplier;
        return this;
    }

    public Function destory() {
        return this.destory;
    }

    public ObjectPool destory(Function destory) {
        this.destory = destory;
        return this;
    }

    public ObjectPool aliveTime(long aliveTime) {
        this.aliveTime = aliveTime;
        return this;
    }

    private String genObjectId() {
        return TString.generateShortUUID();
    }

    public boolean isAutoRefreshOnGet() {
        return this.autoRefreshOnGet;
    }

    public Object get(Object id) {
        PooledObject pooledObject = this.objects.get(id);
        if (pooledObject != null) {
            return pooledObject.getObject();
        }
        return null;
    }

    public Object add(Object obj) {
        String id = this.genObjectId();
        return this.add(id, obj);
    }

    public Object add(Object id, Object obj) {
        if (this.addAndBorrow(id, obj) != null) {
            this.unborrowedObjectIdList.offer(id);
            return id;
        }
        return null;
    }

    public Object addAndBorrow(Object id, Object obj) {
        if (obj == null) {
            return null;
        }
        if (this.objects.size() >= this.maxSize) {
            new RuntimeException("ObjectPool is full.").printStackTrace();
            return null;
        }
        this.objects.put(id, new PooledObject(this, id, obj));
        return id;
    }

    public boolean contains(Object id) {
        return this.objects.containsKey(id);
    }

    public synchronized void remove(Object id) {
        this.objects.remove(id);
        this.unborrowedObjectIdList.remove(id);
    }

    public int size() {
        return this.objects.size();
    }

    public int borrowedSize() {
        return this.objects.size() - this.unborrowedObjectIdList.size();
    }

    public int avaliableSize() {
        return this.unborrowedObjectIdList.size();
    }

    public synchronized void clear() {
        this.objects.clear();
        this.unborrowedObjectIdList.clear();
    }

    public Object borrow() {
        Object borrowedObject = this.unborrowedObjectIdList.poll();
        if (borrowedObject == null && this.supplier != null) {
            borrowedObject = this.addAndBorrow(this.genObjectId(), this.supplier.get());
        }
        return borrowedObject;
    }

    public Object borrow(int waitTime) {
        Object objectId = null;
        while (waitTime >= 0 && (objectId = this.borrow()) == null) {
            TEnv.sleep(1);
        }
        return objectId;
    }

    public void restitution(Object id) {
        this.unborrowedObjectIdList.addLast(id);
    }

    public ObjectPool create() {
        ObjectPool finalobjectPool = this;
        Global.getHashWheelTimer().addTask(new HashWheelTask(){

            @Override
            public void run() {
                try {
                    Iterator iterator = ObjectPool.this.objects.values().iterator();
                    while (iterator.hasNext()) {
                        if (ObjectPool.this.objects.size() <= ObjectPool.this.minSize) {
                            return;
                        }
                        PooledObject pooledObject = (PooledObject)iterator.next();
                        if (!ObjectPool.this.unborrowedObjectIdList.contains(pooledObject.getId()) || pooledObject.isAlive()) continue;
                        if (ObjectPool.this.destory != null) {
                            if (ObjectPool.this.destory.apply(pooledObject) == null) {
                                ObjectPool.this.remove(pooledObject.getId());
                                continue;
                            }
                            pooledObject.refresh();
                            continue;
                        }
                        ObjectPool.this.remove(pooledObject.getId());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, this.interval, true);
        return this;
    }

    public String toString() {
        return "{Total:" + this.objects.size() + ", unborrow:" + this.unborrowedObjectIdList.size() + "}";
    }

    public class PooledObject {
        private long lastVisiediTime;
        private Object id;
        @NotJSON
        private Object object;
        @NotJSON
        private ObjectPool objectCachedPool;

        public PooledObject(ObjectPool objectCachedPool, Object id, Object object) {
            this.objectCachedPool = objectCachedPool;
            this.lastVisiediTime = System.currentTimeMillis();
            this.id = id;
            this.object = object;
        }

        public void refresh() {
            this.lastVisiediTime = System.currentTimeMillis();
        }

        public Object getObject() {
            if (this.objectCachedPool.isAutoRefreshOnGet()) {
                this.refresh();
            }
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public Object getId() {
            return this.id;
        }

        public boolean isAlive() {
            if (this.objectCachedPool.aliveTime <= 0L) {
                return false;
            }
            long currentAliveTime = System.currentTimeMillis() - this.lastVisiediTime;
            return this.objectCachedPool.aliveTime <= 0L || currentAliveTime < this.objectCachedPool.aliveTime * 1000L;
        }

        public String toString() {
            return JSON.toJSON(this).replace("\"", "");
        }
    }
}

