/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.voovan.tools.collection.CacheStatic;
import org.voovan.tools.log.Logger;

public class MemcachedMap<String, V>
implements Map<String, V>,
Closeable {
    private MemcachedClientBuilder memcachedClientBuilder;
    private MemcachedClient memcachedClient = null;
    private Function<String, V> buildFunction = null;

    public MemcachedMap(String host, int port, int timeout, int poolSize) {
        if (this.memcachedClientBuilder == null) {
            try {
                if (poolSize == 0) {
                    poolSize = CacheStatic.defaultPoolSize();
                }
                this.memcachedClientBuilder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)(host + ":" + port)));
                this.memcachedClientBuilder.setFailureMode(true);
                this.memcachedClientBuilder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
                this.memcachedClientBuilder.setConnectionPoolSize(poolSize);
                this.memcachedClientBuilder.setConnectTimeout((long)timeout);
            }
            catch (Exception e) {
                Logger.error("Read ./classes/Memcached.properties error");
            }
        }
    }

    public MemcachedMap(MemcachedClientBuilder memcachedClientBuilder) {
        this.memcachedClientBuilder = memcachedClientBuilder;
    }

    public MemcachedMap() {
        this.memcachedClientBuilder = CacheStatic.getDefalutMemcachedPool();
    }

    private MemcachedClient getMemcachedClient() {
        if (this.memcachedClient == null || this.memcachedClient.isShutdown()) {
            try {
                this.memcachedClient = this.memcachedClientBuilder.build();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.memcachedClient;
    }

    public void build(Function<String, V> buildFunction) {
        this.buildFunction = buildFunction;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        MemcachedClient memcachedClient = this.getMemcachedClient();
        try {
            return memcachedClient.get(key.toString()) != null;
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        MemcachedClient memcachedClient = this.getMemcachedClient();
        try {
            Object result = memcachedClient.get(key.toString());
            if (result == null && this.buildFunction != null) {
                Function<String, V> function = this.buildFunction;
                synchronized (function) {
                    V value = this.buildFunction.apply(key);
                    this.put((String)key, value);
                    return value;
                }
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return null;
    }

    @Override
    public V put(String key, V value) {
        MemcachedClient memcachedClient = this.getMemcachedClient();
        try {
            if (memcachedClient.set((String)key, 0, value)) {
                return value;
            }
            return null;
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
    }

    public boolean put(String key, Object value, int expire) {
        MemcachedClient memcachedClient = this.getMemcachedClient();
        try {
            return memcachedClient.set((String)key, expire, value);
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    public Boolean putWithNoReply(String key, Object value, int expire) {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.getMemcachedClient();
            memcachedClient.setWithNoReply((String)key, expire, value);
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
        return true;
    }

    @Override
    public V remove(Object key) {
        MemcachedClient memcachedClient = this.getMemcachedClient();
        try {
            Object value = memcachedClient.get(key.toString());
            memcachedClient.delete(key.toString());
            return (V)value;
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
    }

    public void removeWithNoReply(Object key) {
        MemcachedClient memcachedClient = this.getMemcachedClient();
        try {
            Object value = memcachedClient.get(key.toString());
            memcachedClient.deleteWithNoReply(key.toString());
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    @Override
    public void putAll(Map map) {
        MemcachedClient memcachedClient = this.getMemcachedClient();
        try {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                memcachedClient.set(entry.getKey().toString(), 0, (Object)entry.getValue().toString());
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    @Override
    public void clear() {
        MemcachedClient memcachedClient = this.getMemcachedClient();
        try {
            memcachedClient.flushAll();
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public long decr(String key, long value) {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.getMemcachedClient();
            return memcachedClient.decr((String)key, value);
        }
        catch (Exception e) {
            Logger.error(e);
            return 0L;
        }
    }

    public long decr(String key, long value, long initValue) {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.getMemcachedClient();
            return memcachedClient.decr((String)key, value, initValue);
        }
        catch (Exception e) {
            Logger.error(e);
            return 0L;
        }
    }

    public long incr(String key, long value) {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.getMemcachedClient();
            return memcachedClient.incr((String)key, value);
        }
        catch (Exception e) {
            Logger.error(e);
            return 0L;
        }
    }

    public long incr(String key, long value, long initValue) {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.getMemcachedClient();
            return memcachedClient.incr((String)key, value, initValue);
        }
        catch (Exception e) {
            Logger.error(e);
            return 0L;
        }
    }

    public boolean append(String key, V value) {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.getMemcachedClient();
            return memcachedClient.append((String)key, value);
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    public boolean prepend(String key, V value) {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.getMemcachedClient();
            return memcachedClient.prepend((String)key, value);
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    public void appendWithNoReply(String key, V value) {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.getMemcachedClient();
            memcachedClient.appendWithNoReply((String)key, value);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public void prependWithNoReply(String key, V value) {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.getMemcachedClient();
            memcachedClient.prependWithNoReply((String)key, value);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public boolean cas(String key, V value, long version) {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.getMemcachedClient();
            return memcachedClient.cas((String)key, 0, value, version);
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    public boolean cas(String key, V value, int time, long version) {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.getMemcachedClient();
            return memcachedClient.cas((String)key, time, value, version);
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.memcachedClient.shutdown();
    }
}

