/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.voovan.tools.TObject;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class CollectionSearch<T> {
    private int step = 0;
    private boolean parallelStream = true;
    private Collection<T> collection;
    private Map<String, Map<String, Object>> searchStep = new TreeMap<String, Map<String, Object>>();

    public CollectionSearch(Collection<T> collection) {
        this.collection = collection;
    }

    public static <P> CollectionSearch<P> newInstance(Collection<P> collection) {
        return new CollectionSearch<P>(collection);
    }

    public boolean isParallelStream() {
        return this.parallelStream;
    }

    public CollectionSearch setParallelStream(boolean parallelStream) {
        this.parallelStream = parallelStream;
        return this;
    }

    public CollectionSearch addCondition(String field, Object value) {
        this.searchStep.put(this.step++ + "_Condition", TObject.asMap(new Object[]{"field", field, "value", value, "operate", Operate.EQUAL}));
        return this;
    }

    public CollectionSearch addCondition(String field, Operate operate, Object value) {
        this.searchStep.put(this.step++ + "_Condition", TObject.asMap(new Object[]{"field", field, "value", value, "operate", operate}));
        return this;
    }

    public CollectionSearch addCondition(Predicate<T> predicate) {
        this.searchStep.put(this.step++ + "_Condition", TObject.asMap("predicate", predicate));
        return this;
    }

    public CollectionSearch sort(String sortField, boolean isAsc) {
        this.searchStep.put(this.step++ + "_Sort", TObject.asMap("field", sortField, "isAsc", isAsc));
        return this;
    }

    public CollectionSearch sort(String sortField) {
        this.searchStep.put(this.step++ + "_Sort", TObject.asMap("field", sortField, "isAsc", true));
        return this;
    }

    public CollectionSearch sort(Comparator<T> comparator) {
        this.searchStep.put(this.step++ + "_Sort", TObject.asMap("comparator", comparator));
        return this;
    }

    public CollectionSearch limit(int limit) {
        this.searchStep.put(this.step++ + "_Limit", TObject.asMap("limit", limit));
        return this;
    }

    public CollectionSearch page(int pageNum, int pageSize) {
        this.searchStep.put(this.step++ + "_Page", TObject.asMap("pageNum", pageNum, "pageSize", pageSize));
        return this;
    }

    public Stream streamRun() {
        Stream<Object> stream = null;
        stream = this.parallelStream ? this.collection.parallelStream() : this.collection.stream();
        for (Map.Entry<String, Map<String, Object>> step : this.searchStep.entrySet()) {
            String stepType = step.getKey();
            final Map<String, Object> stepInfo = step.getValue();
            if (stepType.endsWith("Condition")) {
                if (stepInfo.get("predicate") != null) {
                    stream = stream.filter((Predicate)stepInfo.get("predicate"));
                    continue;
                }
                stream = stream.filter(new Predicate<T>(){

                    @Override
                    public boolean test(T o) {
                        boolean isMatch = false;
                        Object collectionValue = null;
                        try {
                            String stepField = (String)stepInfo.get("field");
                            Object stepValue = stepInfo.get("value");
                            Operate stepOperate = (Operate)((Object)stepInfo.get("operate"));
                            if (o == null) {
                                return false;
                            }
                            collectionValue = o instanceof Map ? (Object)((Map)o).get(stepField) : (Object)TReflect.getFieldValue(o, stepField);
                            if (collectionValue == null) {
                                return false;
                            }
                            if (collectionValue.getClass().getSimpleName().startsWith("Atomic")) {
                                collectionValue = TReflect.invokeMethod(collectionValue, "getThread", new Object[0]);
                            }
                            if (collectionValue == null && stepValue == null) {
                                isMatch = true;
                            } else if (collectionValue.getClass().equals(stepValue.getClass())) {
                                if (stepValue instanceof Comparable) {
                                    if (stepOperate == Operate.EQUAL || stepOperate == Operate.GREATER || stepOperate == Operate.LESS || stepOperate == Operate.NOT_EQUAL) {
                                        int compareResult = ((Comparable)collectionValue).compareTo(stepValue);
                                        if (compareResult == 0 && stepOperate == Operate.EQUAL) {
                                            isMatch = true;
                                        } else if (compareResult != 0 && stepOperate == Operate.NOT_EQUAL) {
                                            isMatch = true;
                                        } else if (compareResult > 0 && stepOperate == Operate.GREATER) {
                                            isMatch = true;
                                        } else if (compareResult < 0 && stepOperate == Operate.LESS) {
                                            isMatch = true;
                                        }
                                    }
                                } else {
                                    isMatch = false;
                                }
                                if (stepValue instanceof String && !isMatch) {
                                    String stringStepValue = (String)stepValue;
                                    String stringCollectionValue = (String)collectionValue;
                                    isMatch = stepOperate == Operate.START_WITH ? stringCollectionValue.startsWith(stringStepValue) : (stepOperate == Operate.END_WITH ? stringCollectionValue.endsWith(stringStepValue) : (stepOperate == Operate.CONTAINS ? stringCollectionValue.contains(stringStepValue) : false));
                                }
                                if (stepValue instanceof Collection && !isMatch) {
                                    Collection collectionStepValue = (Collection)collectionValue;
                                    isMatch = stepOperate == Operate.CONTAINS ? collectionStepValue.contains(stepValue) : false;
                                }
                            } else {
                                isMatch = false;
                            }
                        }
                        catch (ReflectiveOperationException e) {
                            Logger.error("CollectionSearch filter error", e);
                            isMatch = false;
                        }
                        return isMatch;
                    }
                });
                continue;
            }
            if (stepType.endsWith("Sort")) {
                if (stepInfo.get("comparator") != null) {
                    stream = stream.sorted((Comparator)stepInfo.get("comparator"));
                    continue;
                }
                final String sortField = (String)stepInfo.get("field");
                final boolean isAsc = (Boolean)stepInfo.get("isAsc");
                stream = stream.sorted(new Comparator<T>(){

                    @Override
                    public int compare(T o1, T o2) {
                        try {
                            Object fieldValue1 = null;
                            Object fieldValue2 = null;
                            if (o1 == null || o2 == null) {
                                return -1;
                            }
                            fieldValue1 = fieldValue1 instanceof Map ? (Object)((Map)o1).get(sortField) : (Object)TReflect.getFieldValue(o1, sortField);
                            fieldValue2 = fieldValue2 instanceof Map ? (Object)((Map)o2).get(sortField) : (Object)TReflect.getFieldValue(o2, sortField);
                            if (fieldValue1 == null || fieldValue2 == null) {
                                return -1;
                            }
                            if (fieldValue1.getClass() == fieldValue2.getClass()) {
                                if (fieldValue1 instanceof Comparable) {
                                    if (isAsc) {
                                        return ((Comparable)fieldValue1).compareTo(fieldValue2);
                                    }
                                    return ((Comparable)fieldValue1).compareTo(fieldValue2) * -1;
                                }
                                return 0;
                            }
                            return 0;
                        }
                        catch (ReflectiveOperationException e) {
                            Logger.error("CollectionSearch sorted error", e);
                            return 0;
                        }
                    }
                });
                continue;
            }
            if (stepType.endsWith("Limit")) {
                int limit = (Integer)stepInfo.get("limit");
                stream = stream.limit(limit);
                continue;
            }
            if (!stepType.endsWith("Page")) continue;
            int pageNum = (Integer)stepInfo.get("pageNum");
            int pageSize = (Integer)stepInfo.get("pageSize");
            List listResult = stream.collect(Collectors.toList());
            if (pageNum > 0 && pageSize > 0) {
                int start = (pageNum - 1) * pageSize;
                int end = start + pageSize;
                if (end > listResult.size()) {
                    end = listResult.size();
                }
                if (end > listResult.size() - 1) {
                    end = listResult.size();
                }
                listResult = start < end ? listResult.subList(start, end) : new ArrayList();
            }
            stream = listResult.stream();
        }
        return stream;
    }

    public Collection<T> search() {
        List listResult = this.streamRun().collect(Collectors.toList());
        return listResult;
    }

    public <R> List<R> fields(final String ... fieldFilters) {
        List listResult = this.streamRun().map(new Function(){

            public Object apply(Object o) {
                return TReflect.fieldFilter(o, fieldFilters);
            }
        }).collect(Collectors.toList());
        return listResult;
    }

    public <R> List<R> map(Function<T, R> function) {
        List listResult = this.streamRun().map(function).collect(Collectors.toList());
        return listResult;
    }

    public <R> List<R> flatMap(Function<T, R> function) {
        List listResult = this.streamRun().map(function).collect(Collectors.toList());
        return listResult;
    }

    public long count() {
        return this.streamRun().count();
    }

    public static enum Operate {
        EQUAL,
        NOT_EQUAL,
        GREATER,
        LESS,
        START_WITH,
        END_WITH,
        CONTAINS;

    }
}

