/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.voovan.tools.FastThreadLocal;

public class Chain<E>
extends ArrayList<E> {
    public static FastThreadLocal<AtomicInteger> iteratorLocal = FastThreadLocal.withInitial(() -> new AtomicInteger(0));
    public static FastThreadLocal<AtomicInteger> invertedIteratorLocal = FastThreadLocal.withInitial(() -> new AtomicInteger(0));
    private boolean isStop = false;

    public Chain() {
        this.rewind();
    }

    public Chain<E> rewind() {
        this.isStop = false;
        iteratorLocal.get().set(0);
        invertedIteratorLocal.get().set(this.size() - 1);
        return this;
    }

    public void stop() {
        this.isStop = true;
    }

    public E next() {
        if (this.isStop) {
            return null;
        }
        if (this.hasNext()) {
            return this.get(iteratorLocal.get().getAndIncrement());
        }
        return null;
    }

    public boolean hasNext() {
        if (this.isStop) {
            return false;
        }
        return iteratorLocal.get().get() <= this.size() - 1;
    }

    public E previous() {
        if (this.isStop) {
            return null;
        }
        if (this.hasPrevious()) {
            return this.get(invertedIteratorLocal.get().getAndDecrement());
        }
        return null;
    }

    public boolean hasPrevious() {
        if (this.isStop) {
            return false;
        }
        return invertedIteratorLocal.get().get() >= 0;
    }
}

