/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.voovan.Global;
import org.voovan.tools.TEnv;
import org.voovan.tools.collection.CacheMap;
import org.voovan.tools.collection.CollectionSearch;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.hashwheeltimer.HashWheelTimer;
import org.voovan.tools.json.annotation.NotJSON;
import org.voovan.tools.log.Logger;

public class CachedHashMap<K, V>
extends ConcurrentHashMap<K, V>
implements CacheMap<K, V> {
    protected static final HashWheelTimer wheelTimer = new HashWheelTimer(60, 1000);
    private Function<K, V> supplier = null;
    private boolean asyncBuild = true;
    private int interval = 1;
    private boolean autoRemove = true;
    private Function destory;
    private long expire = 0L;
    private ConcurrentHashMap<K, TimeMark> cacheMark = new ConcurrentHashMap();
    private int maxSize;

    public CachedHashMap(Integer maxSize) {
        this.maxSize = maxSize == null ? Integer.MAX_VALUE : maxSize;
    }

    public CachedHashMap() {
        this.maxSize = Integer.MAX_VALUE;
    }

    @Override
    public Function<K, V> getSupplier() {
        return this.supplier;
    }

    public CachedHashMap<K, V> supplier(Function<K, V> buildFunction, boolean asyncBuild) {
        this.supplier = buildFunction;
        this.asyncBuild = asyncBuild;
        this.autoRemove = false;
        return this;
    }

    @Override
    public CachedHashMap<K, V> supplier(Function<K, V> buildFunction) {
        this.supplier(buildFunction, true);
        this.autoRemove = false;
        return this;
    }

    public Function getDestory() {
        return this.destory;
    }

    public CachedHashMap<K, V> destory(Function destory) {
        this.destory = destory;
        return this;
    }

    public CachedHashMap<K, V> maxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public CachedHashMap<K, V> interval(int interval) {
        this.interval = interval;
        return this;
    }

    public CachedHashMap<K, V> autoRemove(boolean autoRemove) {
        this.autoRemove = autoRemove;
        return this;
    }

    @Override
    public long getExpire() {
        return this.expire;
    }

    @Override
    public CachedHashMap expire(long expire) {
        this.expire = expire;
        return this;
    }

    public ConcurrentHashMap<K, TimeMark> getCacheMark() {
        return this.cacheMark;
    }

    public CachedHashMap<K, V> create() {
        final CachedHashMap cachedHashMap = this;
        if (this.interval >= 1) {
            wheelTimer.addTask(new HashWheelTask(){

                @Override
                public void run() {
                    if (!cachedHashMap.getCacheMark().isEmpty()) {
                        for (TimeMark timeMark : cachedHashMap.getCacheMark().values().toArray(new TimeMark[0])) {
                            if (!timeMark.isExpire()) continue;
                            if (CachedHashMap.this.autoRemove) {
                                if (CachedHashMap.this.destory != null) {
                                    if (CachedHashMap.this.destory.apply(cachedHashMap.get(timeMark.key)) == null) {
                                        cachedHashMap.remove(timeMark.getKey());
                                        cachedHashMap.cacheMark.remove(timeMark.getKey());
                                        continue;
                                    }
                                    timeMark.refresh(true);
                                    continue;
                                }
                                cachedHashMap.cacheMark.remove(timeMark.getKey());
                                cachedHashMap.remove(timeMark.getKey());
                                continue;
                            }
                            if (cachedHashMap.getSupplier() == null) continue;
                            cachedHashMap.createCache(timeMark.getKey(), cachedHashMap.supplier, timeMark.getExpireTime());
                            timeMark.refresh(true);
                        }
                        CachedHashMap.this.fixSize();
                    }
                }
            }, this.interval);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCache(final K key, final Function<K, V> supplier, Long createExpire) {
        if (supplier == null) {
            return;
        }
        TimeMark timeMark = null;
        ConcurrentHashMap<K, TimeMark> concurrentHashMap = this.cacheMark;
        synchronized (concurrentHashMap) {
            timeMark = this.cacheMark.get(key);
            if (timeMark == null) {
                timeMark = new TimeMark(this, key, createExpire);
                this.cacheMark.put(key, timeMark);
            }
        }
        final TimeMark finalTimeMark = timeMark;
        final Long finalCreateExpire = createExpire;
        AtomicBoolean atomicBoolean = timeMark.createFlag;
        synchronized (atomicBoolean) {
            if (timeMark.tryLockOnCreate()) {
                if (this.asyncBuild) {
                    Global.getThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            CachedHashMap.this.generator(key, supplier, finalTimeMark, finalCreateExpire);
                        }
                    });
                } else {
                    this.generator(key, supplier, timeMark, createExpire);
                }
            }
        }
        try {
            TEnv.wait(10000, () -> finalTimeMark.isOnCreate());
        }
        catch (TimeoutException e) {
            Logger.error("wait supplier timeout: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generator(K key, Function<K, V> supplier, TimeMark timeMark, Long createExpire) {
        try {
            Function<K, V> function = supplier;
            synchronized (function) {
                V value = supplier.apply(key);
                timeMark.refresh(true);
                if (this.expire == Long.MAX_VALUE) {
                    this.put(key, value);
                } else {
                    this.put(key, value, createExpire);
                }
            }
        }
        catch (Exception e) {
            Logger.error("Create with supplier failed: ", e);
        }
        finally {
            timeMark.releaseCreateLock();
        }
    }

    @Override
    public V get(Object key, Function<K, V> appointedSupplier, Long createExpire, boolean refresh) {
        if (this.cacheMark.containsKey(key) && !this.cacheMark.get(key).isExpire() && !this.cacheMark.get(key).isOnCreate()) {
            this.cacheMark.get(key).refresh(refresh);
        } else {
            appointedSupplier = appointedSupplier == null ? this.supplier : appointedSupplier;
            createExpire = createExpire == null ? this.expire : createExpire;
            this.createCache(key, appointedSupplier, createExpire);
        }
        return super.get(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putAll(m, this.expire);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m, long expire) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.cacheMark.put(e.getKey(), new TimeMark<K>(this, e.getKey(), expire));
        }
        super.putAll(m);
    }

    @Override
    public V put(K key, V value) {
        this.put(key, value, this.expire);
        return value;
    }

    @Override
    public V put(K key, V value, long expire) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        this.cacheMark.putIfAbsent(key, new TimeMark<K>(this, key, expire));
        return super.put(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.expire);
    }

    @Override
    public V putIfAbsent(K key, V value, long expire) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        V result = super.putIfAbsent(key, value);
        this.cacheMark.putIfAbsent(key, new TimeMark<K>(this, key, expire));
        if (result != null) {
            return result;
        }
        return null;
    }

    public boolean isExpire(String key) {
        return this.cacheMark.get(key).isExpire();
    }

    private void fixSize() {
        int diffSize = this.size() - this.maxSize;
        if (diffSize > 0) {
            TimeMark[] removedTimeMark;
            for (TimeMark timeMark : removedTimeMark = CollectionSearch.newInstance(this.cacheMark.values()).addCondition("expireTime", CollectionSearch.Operate.NOT_EQUAL, 0L).addCondition("lastTime", CollectionSearch.Operate.LESS, System.currentTimeMillis() - 1000L).sort("visitCount").limit(10 * diffSize).sort("lastTime").limit(diffSize).search().toArray(new TimeMark[0])) {
                System.out.println("remove");
                this.cacheMark.remove(timeMark.getKey());
                this.remove(timeMark.getKey());
            }
        }
    }

    @Override
    public long getTTL(K key) {
        TimeMark timeMark = this.cacheMark.get(key);
        if (timeMark != null) {
            return timeMark.getExpireTime();
        }
        return -1L;
    }

    @Override
    public boolean setTTL(K key, long expire) {
        TimeMark timeMark = this.cacheMark.get(key);
        if (timeMark == null) {
            return false;
        }
        timeMark.setExpireTime(expire);
        timeMark.refresh(true);
        return true;
    }

    @Override
    public V remove(Object key) {
        this.cacheMark.remove(key);
        return super.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.cacheMark.remove(key);
        return super.remove(key, value);
    }

    @Override
    public void clear() {
        this.cacheMark.clear();
        super.clear();
    }

    static {
        wheelTimer.rotate();
    }

    private class TimeMark<K> {
        @NotJSON
        private CachedHashMap<K, V> mainMap;
        private K key;
        private AtomicLong expireTime = new AtomicLong(0L);
        private AtomicLong lastTime = new AtomicLong(0L);
        private volatile AtomicLong visitCount = new AtomicLong(0L);
        private volatile AtomicBoolean createFlag = new AtomicBoolean(false);

        public TimeMark(CachedHashMap<K, V> mainMap, K key, long expireTime) {
            this.key = key;
            this.mainMap = mainMap;
            this.expireTime.set(expireTime);
            this.visitCount.set(0L);
            this.refresh(true);
        }

        public void refresh(boolean updateLastTime) {
            this.visitCount.incrementAndGet();
            if (updateLastTime) {
                this.lastTime.set(System.currentTimeMillis());
            }
        }

        public boolean isExpire() {
            return this.expireTime.get() > 0L && System.currentTimeMillis() - this.lastTime.get() >= this.expireTime.get() * 1000L;
        }

        public CachedHashMap<K, V> getMainMap() {
            return this.mainMap;
        }

        public K getKey() {
            return this.key;
        }

        public long getExpireTime() {
            return this.expireTime.get();
        }

        public void setExpireTime(long expireTime) {
            this.expireTime.set(expireTime);
        }

        public Long getLastTime() {
            return this.lastTime.get();
        }

        public AtomicLong getVisitCount() {
            return this.visitCount;
        }

        public boolean isOnCreate() {
            return this.createFlag.get();
        }

        public boolean tryLockOnCreate() {
            return this.createFlag.compareAndSet(false, true);
        }

        public void releaseCreateLock() {
            this.createFlag.set(false);
        }
    }
}

