/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.collection;

import java.util.concurrent.ConcurrentHashMap;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.voovan.tools.TPerformance;
import org.voovan.tools.TProperties;
import org.voovan.tools.TSerialize;
import org.voovan.tools.log.Logger;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class CacheStatic {
    private static final String DEFAULT = "system_default";
    private static ConcurrentHashMap<String, MemcachedClientBuilder> MEMCACHED_CLIENT_BUILDER_CACHE = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, JedisPool> REDIS_POOL_CACHE = new ConcurrentHashMap();

    public static MemcachedClientBuilder getDefalutMemcachedPool() {
        MemcachedClientBuilder memcachedClientBuilder = MEMCACHED_CLIENT_BUILDER_CACHE.get(DEFAULT);
        if (memcachedClientBuilder == null) {
            try {
                String host = TProperties.getString("memcached", "Host");
                int port = TProperties.getInt("memcached", "Port");
                int timeout = TProperties.getInt("memcached", "Timeout");
                int poolSize = TProperties.getInt("memcached", "PoolSize");
                memcachedClientBuilder = CacheStatic.createMemcachedPool(DEFAULT, host, port, timeout, poolSize);
            }
            catch (Exception e) {
                Logger.error("Read ./classes/Memcached.properties error");
            }
        }
        return memcachedClientBuilder;
    }

    public static MemcachedClientBuilder getMemcachedPool(String name) {
        return MEMCACHED_CLIENT_BUILDER_CACHE.get(name);
    }

    @Deprecated
    public static MemcachedClientBuilder getMemcachedPool() {
        return CacheStatic.getDefalutMemcachedPool();
    }

    public static synchronized MemcachedClientBuilder createMemcachedPool(String name, String host, int port, int timeout, int poolSize) {
        MemcachedClientBuilder memcachedClientBuilder = MEMCACHED_CLIENT_BUILDER_CACHE.get(name);
        if (memcachedClientBuilder != null) {
            return memcachedClientBuilder;
        }
        if (host == null) {
            return null;
        }
        if (poolSize == 0) {
            poolSize = CacheStatic.defaultPoolSize();
        }
        memcachedClientBuilder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)(host + ":" + port)));
        memcachedClientBuilder.setFailureMode(true);
        memcachedClientBuilder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
        memcachedClientBuilder.setConnectionPoolSize(poolSize);
        memcachedClientBuilder.setConnectTimeout((long)timeout);
        MEMCACHED_CLIENT_BUILDER_CACHE.put(name, memcachedClientBuilder);
        return memcachedClientBuilder;
    }

    public static JedisPool getDefaultRedisPool() {
        JedisPool redisPool = REDIS_POOL_CACHE.get(DEFAULT);
        if (redisPool == null) {
            try {
                String host = TProperties.getString("redis", "Host");
                int port = TProperties.getInt("redis", "Port");
                int timeout = TProperties.getInt("redis", "Timeout");
                String password = TProperties.getString("redis", "Password");
                int poolSize = TProperties.getInt("redis", "PoolSize");
                redisPool = CacheStatic.createRedisPool(DEFAULT, host, port, timeout, password, poolSize);
            }
            catch (Exception e) {
                Logger.error("Read ./classes/Memcached.properties error");
            }
        }
        return redisPool;
    }

    public static JedisPool getRedisPool(String name) {
        return REDIS_POOL_CACHE.get(name);
    }

    @Deprecated
    public static JedisPool getRedisPool() {
        return CacheStatic.getDefaultRedisPool();
    }

    public static synchronized JedisPool createRedisPool(String name, String host, int port, int timeout, String password, int poolSize) {
        JedisPool redisPool = REDIS_POOL_CACHE.get(name);
        if (redisPool != null) {
            return redisPool;
        }
        if (host == null) {
            return null;
        }
        if (poolSize == 0) {
            poolSize = CacheStatic.defaultPoolSize();
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(poolSize);
        poolConfig.setMaxIdle(poolSize);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        redisPool = password == null ? new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout) : new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password);
        REDIS_POOL_CACHE.put(name, redisPool);
        return redisPool;
    }

    public static int defaultPoolSize() {
        return TPerformance.getProcessorCount() * 10;
    }

    public static byte[] serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        return TSerialize.serialize(obj);
    }

    public static Object unserialize(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        return TSerialize.unserialize(byteArray);
    }
}

