/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.buffer;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.voovan.Global;
import org.voovan.tools.TStream;
import org.voovan.tools.TUnsafe;
import org.voovan.tools.buffer.Cleaner;
import org.voovan.tools.collection.ObjectThreadPool;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class TByteBuffer {
    public static ObjectThreadPool<ByteBuffer> BYTE_BUFFER_THREAD_POOL = new ObjectThreadPool(System.getProperty("ThreadBufferPoolSize") != null ? Integer.valueOf(System.getProperty("ThreadBufferPoolSize")) : 32);
    public static int DEFAULT_BYTE_BUFFER_SIZE = System.getProperty("DefaultBufferSize") != null ? Integer.valueOf(System.getProperty("BufferSize")) : 4096;
    public static final ByteBuffer EMPTY_BYTE_BUFFER;
    public static Class DIRECT_BYTE_BUFFER_CLASS;
    public static Constructor DIRECT_BYTE_BUFFER_CONSTURCTOR;
    public static Field addressField;
    public static Field capacityField;
    public static Field attField;

    private static Constructor getConsturctor() {
        try {
            Constructor constructor = DIRECT_BYTE_BUFFER_CLASS.getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Field ByteBufferField(String fieldName) {
        Field field = TReflect.findField(DIRECT_BYTE_BUFFER_CLASS, fieldName);
        field.setAccessible(true);
        return field;
    }

    protected static ByteBuffer allocateManualReleaseBuffer(int capacity) {
        try {
            long address = TUnsafe.getUnsafe().allocateMemory(capacity);
            Deallocator deallocator = new Deallocator(new Long(address));
            ByteBuffer byteBuffer = (ByteBuffer)DIRECT_BYTE_BUFFER_CONSTURCTOR.newInstance(address, capacity, deallocator);
            Cleaner.create(byteBuffer, deallocator);
            return byteBuffer;
        }
        catch (Exception e) {
            Logger.error("Create ByteBufferChannel error. ", e);
            return null;
        }
    }

    public static ByteBuffer allocateDirect() {
        return TByteBuffer.allocateDirect(DEFAULT_BYTE_BUFFER_SIZE);
    }

    public static ByteBuffer allocateDirect(int capacity) {
        if (Global.NO_HEAP_MANUAL_RELEASE.booleanValue()) {
            ByteBuffer byteBuffer = BYTE_BUFFER_THREAD_POOL.get(() -> TByteBuffer.allocateManualReleaseBuffer(capacity));
            if (capacity <= byteBuffer.capacity()) {
                byteBuffer.limit(capacity);
            } else {
                TByteBuffer.reallocate(byteBuffer, capacity);
            }
            byteBuffer.position(0);
            byteBuffer.limit(capacity);
            return byteBuffer;
        }
        return ByteBuffer.allocateDirect(capacity);
    }

    public static boolean reallocate(ByteBuffer byteBuffer, int newSize) {
        if (TByteBuffer.isReleased(byteBuffer)) {
            return false;
        }
        try {
            if (byteBuffer.capacity() > newSize) {
                byteBuffer.limit(newSize);
                return true;
            }
            if (!byteBuffer.hasArray()) {
                if (TByteBuffer.getAtt(byteBuffer) == null) {
                    throw new UnsupportedOperationException("JDK's ByteBuffer can't reallocate");
                }
                long address = TByteBuffer.getAddress(byteBuffer);
                long newAddress = TUnsafe.getUnsafe().reallocateMemory(address, newSize);
                TByteBuffer.setAddress(byteBuffer, newAddress);
            } else {
                byte[] hb = byteBuffer.array();
                byte[] newHb = Arrays.copyOf(hb, newSize);
                TReflect.setFieldValue((Object)byteBuffer, "hb", (Object)newHb);
            }
            capacityField.set(byteBuffer, newSize);
            return true;
        }
        catch (ReflectiveOperationException e) {
            Logger.error("TByteBuffer.reallocate() Error. ", e);
            return false;
        }
    }

    public static boolean moveData(ByteBuffer byteBuffer, int offset) {
        try {
            if (offset == 0) {
                return true;
            }
            if (byteBuffer.remaining() == 0) {
                return true;
            }
            int newLimit = byteBuffer.limit() + offset;
            int newPosition = byteBuffer.position() + offset;
            if (newPosition < 0) {
                return false;
            }
            if (newLimit > byteBuffer.capacity()) {
                TByteBuffer.reallocate(byteBuffer, newLimit);
            }
            if (!byteBuffer.hasArray()) {
                long address = TByteBuffer.getAddress(byteBuffer);
                if (address != 0L) {
                    long startAddress = address + (long)byteBuffer.position();
                    long targetAddress = address + (long)newPosition;
                    if (address > targetAddress) {
                        targetAddress = address;
                    }
                    TUnsafe.getUnsafe().copyMemory(startAddress, targetAddress, byteBuffer.remaining());
                }
            } else {
                byte[] hb = byteBuffer.array();
                System.arraycopy(hb, byteBuffer.position(), hb, newPosition, byteBuffer.remaining());
            }
            byteBuffer.limit(newLimit);
            byteBuffer.position(newPosition);
            return true;
        }
        catch (ReflectiveOperationException e) {
            Logger.error("TByteBuffer.moveData() Error.", e);
            return false;
        }
    }

    public static ByteBuffer copy(ByteBuffer byteBuffer) throws ReflectiveOperationException {
        ByteBuffer newByteBuffer = TByteBuffer.allocateDirect(byteBuffer.capacity());
        if (byteBuffer.hasRemaining()) {
            long address = TByteBuffer.getAddress(byteBuffer);
            long newAddress = TByteBuffer.getAddress(newByteBuffer);
            TUnsafe.getUnsafe().copyMemory(address, newAddress + (long)byteBuffer.position(), byteBuffer.remaining());
        }
        newByteBuffer.position(byteBuffer.position());
        newByteBuffer.limit(byteBuffer.limit());
        return newByteBuffer;
    }

    public static void release(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        if (!Global.NO_HEAP_MANUAL_RELEASE.booleanValue() || byteBuffer.getClass() != DIRECT_BYTE_BUFFER_CLASS) {
            return;
        }
        try {
            long address;
            Object att;
            if (byteBuffer != null && !TByteBuffer.isReleased(byteBuffer) && (att = TByteBuffer.getAtt(byteBuffer)) != null && att.getClass() == Deallocator.class && (address = TByteBuffer.getAddress(byteBuffer).longValue()) != 0L) {
                byteBuffer.clear();
                if (byteBuffer.capacity() > DEFAULT_BYTE_BUFFER_SIZE) {
                    TByteBuffer.reallocate(byteBuffer, DEFAULT_BYTE_BUFFER_SIZE);
                }
                BYTE_BUFFER_THREAD_POOL.release(byteBuffer, () -> {
                    try {
                        TUnsafe.getUnsafe().freeMemory(address);
                        TByteBuffer.setAddress(byteBuffer, 0L);
                        return true;
                    }
                    catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                        return false;
                    }
                });
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static boolean isReleased(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return true;
        }
        if (!Global.NO_HEAP_MANUAL_RELEASE.booleanValue() || byteBuffer.getClass() != DIRECT_BYTE_BUFFER_CLASS) {
            return false;
        }
        try {
            return TByteBuffer.getAddress(byteBuffer) == 0L;
        }
        catch (ReflectiveOperationException e) {
            return true;
        }
    }

    public static byte[] toArray(ByteBuffer bytebuffer) {
        if (!bytebuffer.hasArray()) {
            if (TByteBuffer.isReleased(bytebuffer)) {
                return new byte[0];
            }
            bytebuffer.mark();
            int position = bytebuffer.position();
            int limit = bytebuffer.limit();
            byte[] buffers = new byte[limit - position];
            bytebuffer.get(buffers);
            bytebuffer.reset();
            return buffers;
        }
        return Arrays.copyOfRange(bytebuffer.array(), 0, bytebuffer.limit());
    }

    public static String toString(ByteBuffer bytebuffer, String charset) {
        try {
            return new String(TByteBuffer.toArray(bytebuffer), charset);
        }
        catch (UnsupportedEncodingException e) {
            Logger.error(charset + " is not supported", e);
            return null;
        }
    }

    public static String toString(ByteBuffer bytebuffer) {
        return TByteBuffer.toString(bytebuffer, "UTF-8");
    }

    public static int indexOf(ByteBuffer byteBuffer, byte[] mark) {
        if (TByteBuffer.isReleased(byteBuffer)) {
            return -1;
        }
        if (byteBuffer.remaining() == 0) {
            return -1;
        }
        int originPosition = byteBuffer.position();
        int length = byteBuffer.remaining();
        if (length < mark.length) {
            return -1;
        }
        int index = -1;
        int i = byteBuffer.position();
        int j = 0;
        while (i <= byteBuffer.limit() - mark.length + j) {
            if (byteBuffer.get(i) != mark[j]) {
                if (i == byteBuffer.limit() - mark.length + j) break;
                int pos = TStream.contains(mark, byteBuffer.get(i + mark.length - j));
                if (pos == -1) {
                    i = i + mark.length + 1 - j;
                    j = 0;
                    continue;
                }
                i = i + mark.length - pos - j;
                j = 0;
                continue;
            }
            if (j == mark.length - 1) {
                i = i - j + 1;
                j = 0;
                index = i - j - 1;
                break;
            }
            ++i;
            ++j;
        }
        byteBuffer.position(originPosition);
        return index;
    }

    public static Long getAddress(ByteBuffer byteBuffer) throws ReflectiveOperationException {
        return (Long)addressField.get(byteBuffer);
    }

    public static void setAddress(ByteBuffer byteBuffer, long address) throws ReflectiveOperationException {
        addressField.set(byteBuffer, address);
        Object att = TByteBuffer.getAtt(byteBuffer);
        if (att != null && att.getClass() == Deallocator.class) {
            ((Deallocator)att).setAddress(address);
        }
    }

    public static Object getAtt(ByteBuffer byteBuffer) throws ReflectiveOperationException {
        return attField.get(byteBuffer);
    }

    public static void setAttr(ByteBuffer byteBuffer, Object attr) throws ReflectiveOperationException {
        attField.set(byteBuffer, attr);
    }

    static {
        System.out.println("[SYTSEM] ThreadBufferPoolSize: " + BYTE_BUFFER_THREAD_POOL.getThreadLocalMaxSize());
        System.out.println("[SYTSEM] BufferSize: " + DEFAULT_BYTE_BUFFER_SIZE);
        EMPTY_BYTE_BUFFER = ByteBuffer.allocateDirect(0);
        DIRECT_BYTE_BUFFER_CLASS = EMPTY_BYTE_BUFFER.getClass();
        DIRECT_BYTE_BUFFER_CONSTURCTOR = TByteBuffer.getConsturctor();
        DIRECT_BYTE_BUFFER_CONSTURCTOR.setAccessible(true);
        addressField = TByteBuffer.ByteBufferField("address");
        capacityField = TByteBuffer.ByteBufferField("capacity");
        attField = TByteBuffer.ByteBufferField("att");
    }

    public static final class Deallocator
    implements Runnable {
        private long address;

        Deallocator(long address) {
            this.address = address;
        }

        public void setAddress(long address) {
            this.address = address;
        }

        public long getAddress() {
            return this.address;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            TUnsafe.getUnsafe().freeMemory(this.address);
            this.address = 0L;
        }
    }
}

