/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.buffer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TProperties;
import org.voovan.tools.TStream;
import org.voovan.tools.TUnsafe;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.exception.LargerThanMaxSizeException;
import org.voovan.tools.exception.MemoryReleasedException;
import org.voovan.tools.log.Logger;
import sun.misc.Unsafe;

public class RingDirectBuffer {
    private static int BYTEBUFFERCHANNEL_MAX_SIZE = TProperties.getInt("framework", "ByteBufferChannelMaxSize");
    private int maxSize = BYTEBUFFERCHANNEL_MAX_SIZE == 0 ? 0x200000 : BYTEBUFFERCHANNEL_MAX_SIZE;
    private static Unsafe unsafe = TUnsafe.getUnsafe();
    private ByteBuffer byteBuffer;
    private long address = 0L;
    private int readPositon = 0;
    private int writePositon = 0;
    private int capacity;

    public RingDirectBuffer() {
        this(TByteBuffer.DEFAULT_BYTE_BUFFER_SIZE);
    }

    public RingDirectBuffer(int capacity) {
        this(TByteBuffer.allocateDirect(capacity));
    }

    public RingDirectBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            throw new UnsupportedOperationException();
        }
        this.capacity = byteBuffer.capacity();
        this.byteBuffer = byteBuffer;
        try {
            this.address = TByteBuffer.getAddress(byteBuffer);
        }
        catch (ReflectiveOperationException e) {
            Logger.error("Get bytebuffer address error.");
        }
    }

    public long getAddress() {
        return this.address;
    }

    public int getReadPositon() {
        return this.readPositon;
    }

    public int getWritePositon() {
        return this.writePositon;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean skip(int offset) {
        this.checkRelease();
        if (this.remaining() < offset || offset < 0) {
            return false;
        }
        this.readPositon = (this.readPositon + offset) % this.capacity;
        return true;
    }

    public Boolean isEmpty() {
        return this.readPositon == this.writePositon;
    }

    public Boolean isFull() {
        return (this.writePositon + 1) % this.capacity == this.readPositon;
    }

    public void clear() {
        this.checkRelease();
        this.readPositon = 0;
        this.writePositon = 0;
    }

    public byte get(int offset) {
        this.checkRelease();
        if (offset < this.remaining()) {
            int realOffset = (this.readPositon + offset) % this.capacity;
            return unsafe.getByte(this.address + (long)realOffset);
        }
        throw new IndexOutOfBoundsException();
    }

    public int get(ByteBuffer byteBuffer) {
        this.checkRelease();
        int size = byteBuffer.remaining();
        if (size > this.remaining()) {
            size = this.remaining();
        }
        for (int i = 0; i < size; ++i) {
            byteBuffer.put(this.get(i));
        }
        return size;
    }

    public int get(byte[] bytes, int offset, int length) {
        this.checkRelease();
        if (length > this.remaining()) {
            length = this.remaining();
        }
        for (int i = offset; i < offset + length; ++i) {
            bytes[i] = this.get(i);
        }
        return length;
    }

    public byte[] toArray() {
        byte[] bytes = new byte[this.remaining()];
        this.get(bytes, 0, bytes.length);
        return bytes;
    }

    public void write(byte b) {
        this.checkRelease();
        if (this.isFull().booleanValue()) {
            throw new BufferOverflowException();
        }
        if (this.isEmpty().booleanValue() && this.readPositon != 0) {
            this.clear();
        }
        unsafe.putByte(this.address + (long)this.writePositon, b);
        this.writePositon = (this.writePositon + 1) % this.capacity;
    }

    public int write(byte[] bytes, int offset, int length) {
        this.checkRelease();
        this.tryExpansion(length);
        for (int i = 0; i < length; ++i) {
            this.write(bytes[offset + i]);
        }
        return length;
    }

    public int write(ByteBuffer byteBuffer) {
        this.checkRelease();
        if (byteBuffer.remaining() == 0) {
            return 0;
        }
        this.tryExpansion(byteBuffer.remaining());
        if (byteBuffer == null) {
            return -1;
        }
        int size = 0;
        for (int writeSize = byteBuffer.remaining(); writeSize > 0; --writeSize) {
            this.write(byteBuffer.get());
            ++size;
        }
        return size;
    }

    public int remaining() {
        this.checkRelease();
        if (this.writePositon == this.readPositon) {
            return 0;
        }
        if (this.writePositon < this.readPositon) {
            return this.capacity - this.readPositon + this.writePositon;
        }
        return this.writePositon - this.readPositon;
    }

    public int avaliable() {
        this.checkRelease();
        return this.capacity - this.remaining() - 1;
    }

    public byte read() {
        this.checkRelease();
        if (this.isEmpty().booleanValue()) {
            throw new BufferUnderflowException();
        }
        byte result = unsafe.getByte(this.address + (long)this.readPositon);
        this.readPositon = (this.readPositon + 1) % this.capacity;
        if (this.isEmpty().booleanValue() && this.readPositon != 0) {
            this.clear();
        }
        return result;
    }

    public int read(ByteBuffer byteBuffer) {
        this.checkRelease();
        int size = byteBuffer.remaining();
        if (size > this.remaining()) {
            size = this.remaining();
        }
        for (int i = 0; i < size; ++i) {
            byteBuffer.put(this.read());
        }
        byteBuffer.flip();
        return size;
    }

    public int read(byte[] bytes, int offset, int length) {
        this.checkRelease();
        if (length > this.remaining()) {
            length = this.remaining();
        }
        for (int i = offset; i < offset + length; ++i) {
            bytes[i] = this.read();
        }
        return length;
    }

    public ByteBuffer getByteBuffer() {
        this.checkRelease();
        if (this.writePositon < this.readPositon) {
            int remaining = this.remaining();
            int tailSize = this.capacity - this.readPositon;
            this.byteBuffer.position(0);
            this.byteBuffer.limit(this.writePositon);
            byte[] tmp = TByteBuffer.toArray(this.byteBuffer);
            this.byteBuffer.limit(this.byteBuffer.capacity());
            unsafe.copyMemory(this.address + (long)this.readPositon, this.address, tailSize);
            for (int i = 0; i < tmp.length; ++i) {
                unsafe.putByte(this.address + (long)tailSize + (long)i, tmp[i]);
            }
            this.readPositon = 0;
            this.writePositon = remaining;
        }
        this.byteBuffer.limit(this.writePositon);
        this.byteBuffer.position(this.readPositon);
        return this.byteBuffer;
    }

    public void compact() {
        this.checkRelease();
        this.readPositon = this.byteBuffer.position();
        this.writePositon = this.byteBuffer.limit();
    }

    public int indexOf(byte[] mark) {
        this.checkRelease();
        if (this.remaining() == 0) {
            return -1;
        }
        int length = this.remaining();
        if (length < mark.length) {
            return -1;
        }
        int index = -1;
        int i = 0;
        int j = 0;
        while (i <= this.remaining() - mark.length + j) {
            if (this.get(i) != mark[j]) {
                if (i == this.remaining() - mark.length + j) break;
                int pos = TStream.contains(mark, this.get(i + mark.length - j));
                if (pos == -1) {
                    i = i + mark.length + 1 - j;
                    j = 0;
                    continue;
                }
                i = i + mark.length - pos - j;
                j = 0;
                continue;
            }
            if (j == mark.length - 1) {
                i = i - j + 1;
                j = 0;
                index = i - j - 1;
                break;
            }
            ++i;
            ++j;
        }
        return index == -1 ? index : (index + this.readPositon) % this.capacity;
    }

    public boolean startWith(byte[] mark) {
        this.checkRelease();
        if (this.remaining() < mark.length) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < mark.length; ++i) {
            if (mark[i] == this.get(i)) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean waitData(int length, int timeout, Runnable supplier) {
        this.checkRelease();
        try {
            TEnv.wait(timeout, () -> {
                if (this.remaining() >= length) {
                    return false;
                }
                supplier.run();
                return this.remaining() < length;
            });
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public boolean waitData(byte[] mark, int timeout, Runnable supplier) {
        this.checkRelease();
        try {
            TEnv.wait(timeout, () -> {
                if (this.indexOf(mark) != -1) {
                    return false;
                }
                supplier.run();
                return this.indexOf(mark) == -1;
            });
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public String readLine() {
        this.checkRelease();
        if (this.remaining() == 0) {
            return null;
        }
        String lineStr = null;
        int index = this.indexOf("\n".getBytes());
        int size = -1;
        if (index >= 0) {
            size = this.readPositon > index ? this.capacity - this.readPositon + index : index - this.readPositon;
            ++size;
        }
        if (this.remaining() > 0 && index == -1) {
            size = this.remaining();
        }
        byte[] temp = new byte[size];
        for (int i = 0; i < size; ++i) {
            temp[i] = this.read();
        }
        lineStr = new String(temp);
        return lineStr.isEmpty() && index == -1 ? null : lineStr;
    }

    public void saveToFile(String filePath, long length) throws IOException {
        this.checkRelease();
        if (this.remaining() == 0) {
            return;
        }
        int bufferSize = 0x100000;
        if (length < (long)bufferSize) {
            bufferSize = Long.valueOf(length).intValue();
        }
        byte[] buffer = new byte[bufferSize];
        TFile.mkdir(TFile.getFileDirectory(filePath));
        File file = new File(filePath);
        try (RandomAccessFile randomAccessFile = null;){
            randomAccessFile = new RandomAccessFile(file, "rwd");
            randomAccessFile.seek(randomAccessFile.length());
            int loadSize = bufferSize;
            ByteBuffer tempByteBuffer = ByteBuffer.wrap(buffer);
            while (length > 0L) {
                loadSize = length > (long)bufferSize ? bufferSize : Long.valueOf(length).intValue();
                tempByteBuffer.limit(loadSize);
                this.read(tempByteBuffer);
                randomAccessFile.write(buffer, 0, loadSize);
                length -= (long)loadSize;
                tempByteBuffer.clear();
            }
        }
    }

    private void checkRelease() {
        if (this.isReleased()) {
            throw new MemoryReleasedException("ByteBufferChannel is released.");
        }
    }

    public boolean isReleased() {
        return this.address == 0L || this.byteBuffer == null;
    }

    public synchronized void release() {
        this.address = 0L;
        this.byteBuffer = null;
        TByteBuffer.release(this.byteBuffer);
    }

    public boolean tryExpansion(int dataSize) throws LargerThanMaxSizeException {
        this.checkRelease();
        if (dataSize > this.avaliable()) {
            this.getByteBuffer();
            int newCapacity = this.capacity + dataSize;
            if (this.maxSize < dataSize) {
                throw new LargerThanMaxSizeException("Max size: " + this.maxSize + ", expect size: " + newCapacity);
            }
            if (TByteBuffer.reallocate(this.byteBuffer, newCapacity)) {
                this.capacity = newCapacity;
                this.resetAddress();
                return true;
            }
            return false;
        }
        return false;
    }

    public void resetAddress() {
        try {
            this.address = TByteBuffer.getAddress(this.byteBuffer);
        }
        catch (ReflectiveOperationException e) {
            Logger.error("Get bytebuffer address error.");
        }
    }

    public String toString() {
        return "readPositon=" + this.readPositon + ", writePositon=" + this.writePositon + ", capacity=" + this.capacity + ", remaining=" + this.remaining() + ", avaliable=" + this.avaliable() + ", address=" + this.address;
    }
}

