/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.buffer;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Timer;
import java.util.TimerTask;
import org.voovan.tools.TProperties;

public class Cleaner
extends PhantomReference<Object> {
    private static final ReferenceQueue<Object> dummyQueue = new ReferenceQueue();
    private static Cleaner first = null;
    private Cleaner next = null;
    private Cleaner prev = null;
    private final Runnable thunk;
    private static final Timer timer;

    private static synchronized Cleaner add(Cleaner cleaner) {
        if (first != null) {
            cleaner.next = first;
            Cleaner.first.prev = cleaner;
        }
        first = cleaner;
        return cleaner;
    }

    private static synchronized boolean remove(Cleaner cleaner) {
        if (cleaner.next == cleaner) {
            return false;
        }
        if (first == cleaner) {
            first = cleaner.next != null ? cleaner.next : cleaner.prev;
        }
        if (cleaner.next != null) {
            cleaner.next.prev = cleaner.prev;
        }
        if (cleaner.prev != null) {
            cleaner.prev.next = cleaner.next;
        }
        cleaner.next = cleaner;
        cleaner.prev = cleaner;
        return true;
    }

    private Cleaner(Object obj, Runnable thunk) {
        super(obj, dummyQueue);
        this.thunk = thunk;
    }

    public static Cleaner create(Object obj, Runnable thunk) {
        return thunk == null ? null : Cleaner.add(new Cleaner(obj, thunk));
    }

    public void clean() {
        if (Cleaner.remove(this)) {
            try {
                this.thunk.run();
            }
            catch (Throwable var2) {
                System.out.println("Cleaner terminated abnormally");
            }
        }
    }

    static {
        Integer noHeapReleaseInterval = TProperties.getInt("framework", "NoHeapReleaseInterval");
        Integer finalNoHeapReleaseInterval = noHeapReleaseInterval == 0 ? 3 : noHeapReleaseInterval;
        timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Reference cleanerRef;
                while ((cleanerRef = dummyQueue.poll()) != null) {
                    if (!(cleanerRef instanceof Cleaner)) continue;
                    Cleaner cleaner = (Cleaner)cleanerRef;
                    cleaner.clean();
                }
            }
        }, 1000L, (long)finalNoHeapReleaseInterval.intValue());
    }
}

