/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.buffer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.voovan.Global;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TProperties;
import org.voovan.tools.TUnsafe;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.exception.LargerThanMaxSizeException;
import org.voovan.tools.exception.MemoryReleasedException;
import org.voovan.tools.log.Logger;
import sun.misc.Unsafe;

public class ByteBufferChannel {
    private static int BYTEBUFFERCHANNEL_MAX_SIZE = TProperties.getInt("framework", "ByteBufferChannelMaxSize");
    private volatile AtomicLong address = new AtomicLong(0L);
    private Unsafe unsafe = TUnsafe.getUnsafe();
    private ByteBuffer byteBuffer;
    private volatile int size;
    private AtomicBoolean borrowed = new AtomicBoolean(false);
    private int maxSize = BYTEBUFFERCHANNEL_MAX_SIZE == 0 ? 0x200000 : BYTEBUFFERCHANNEL_MAX_SIZE;

    public ByteBufferChannel(int capacity) {
        this.init(capacity);
    }

    public ByteBufferChannel(int capacity, Integer maxSize) {
        this.init(capacity);
        this.maxSize = maxSize;
    }

    public ByteBufferChannel(ByteBuffer byteBuffer) {
        this.init(byteBuffer);
    }

    public ByteBufferChannel() {
        this.init(16384);
    }

    private void init(int capacity) {
        this.byteBuffer = this.newByteBuffer(capacity);
        this.byteBuffer.limit(0);
        this.resetAddress();
        this.size = 0;
        this.maxSize = this.maxSize < capacity ? capacity : this.maxSize;
    }

    public void init(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.resetAddress();
        this.size = byteBuffer.remaining();
    }

    private ByteBuffer newByteBuffer(int capacity) {
        try {
            ByteBuffer instance = TByteBuffer.allocateDirect(capacity);
            this.address.set(TByteBuffer.getAddress(instance));
            return instance;
        }
        catch (Exception e) {
            Logger.error("Create ByteBufferChannel error. ", e);
            return null;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public boolean isFull() {
        return this.maxSize <= this.size;
    }

    public boolean isReleased() {
        return this.address.get() == 0L || this.byteBuffer == null;
    }

    private void checkRelease() {
        if (this.isReleased()) {
            throw new MemoryReleasedException("ByteBufferChannel is released.");
        }
    }

    public void release() {
        if (this.byteBuffer == null) {
            return;
        }
        if (!Global.NO_HEAP_MANUAL_RELEASE.booleanValue() || this.byteBuffer.getClass() != TByteBuffer.DIRECT_BYTE_BUFFER_CLASS) {
            return;
        }
        if (this.address.get() != 0L) {
            TByteBuffer.release(this.byteBuffer);
            this.address.set(0L);
            this.byteBuffer = null;
            this.size = -1;
        }
    }

    private void resetAddress() {
        try {
            this.address.set(TByteBuffer.getAddress(this.byteBuffer));
        }
        catch (ReflectiveOperationException e) {
            Logger.error("ByteBufferChannel resetAddress() Error: ", e);
        }
    }

    public int available() {
        if (this.isReleased()) {
            return -1;
        }
        return this.byteBuffer.capacity() - this.size;
    }

    public int capacity() {
        if (this.isReleased()) {
            return -1;
        }
        return this.byteBuffer.capacity();
    }

    public int size() {
        return this.size;
    }

    public byte[] array() {
        if (this.size() == 0) {
            return new byte[0];
        }
        this.checkRelease();
        byte[] temp = new byte[this.size];
        this.get(temp, 0, this.size);
        return temp;
    }

    public void clear() {
        if (this.isReleased()) {
            return;
        }
        if (this.size != 0 && this.byteBuffer != null) {
            this.byteBuffer.limit(0);
            this.size = 0;
        }
    }

    public boolean shrink(int shrinkPosition, int shrinkSize) {
        this.checkRelease();
        if (this.isReleased()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (shrinkSize == 0) {
            return true;
        }
        if (shrinkPosition < 0) {
            return false;
        }
        if (shrinkSize < 0 && shrinkPosition + shrinkSize < 0) {
            shrinkSize = shrinkPosition * -1;
        }
        if (shrinkSize > 0 && shrinkPosition + shrinkSize > this.size()) {
            shrinkSize = this.size() - shrinkPosition;
        }
        if (Math.abs(shrinkSize) > this.size) {
            return true;
        }
        int position = this.byteBuffer.position();
        this.byteBuffer.position(shrinkPosition);
        if (shrinkSize > 0) {
            this.byteBuffer.position(shrinkPosition + shrinkSize);
        }
        if (TByteBuffer.moveData(this.byteBuffer, Math.abs(shrinkSize) * -1)) {
            if (position > shrinkPosition) {
                position += shrinkPosition;
            }
            if (position < this.byteBuffer.limit()) {
                this.byteBuffer.position(position);
            }
            this.size -= Math.abs(shrinkSize);
            return true;
        }
        this.byteBuffer.position(position);
        return false;
    }

    public boolean shrink(int shrinkSize) {
        if (shrinkSize == 0) {
            return true;
        }
        if (shrinkSize > 0) {
            return this.shrink(0, shrinkSize);
        }
        return this.shrink(this.size, shrinkSize);
    }

    public byte get(int position) throws IndexOutOfBoundsException {
        this.checkRelease();
        if (this.size() == 0) {
            throw new IndexOutOfBoundsException();
        }
        if (position >= 0 && position <= this.size) {
            byte result = this.unsafe.getByte(this.address.get() + (long)position);
            return result;
        }
        this.checkRelease();
        throw new IndexOutOfBoundsException();
    }

    public int get(byte[] dst, int position, int length) throws IndexOutOfBoundsException {
        this.checkRelease();
        if (this.size() == 0) {
            return 0;
        }
        int availableCount = this.size() - position;
        if (position >= 0 && availableCount >= 0) {
            if (availableCount == 0) {
                return 0;
            }
            int arrSize = availableCount;
            if (length < availableCount) {
                arrSize = length;
            }
            this.unsafe.copyMemory(null, this.address.get() + (long)position, dst, Unsafe.ARRAY_BYTE_BASE_OFFSET, length);
            return arrSize;
        }
        this.checkRelease();
        throw new IndexOutOfBoundsException();
    }

    public int get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ByteBuffer getByteBuffer() {
        try {
            this.checkRelease();
            this.borrowed.compareAndSet(false, true);
            return this.byteBuffer;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer slice(int size) {
        int oldLimit = this.byteBuffer.limit();
        try {
            this.checkRelease();
            this.byteBuffer.limit(this.byteBuffer.position() + size);
            ByteBuffer byteBuffer = this.byteBuffer.slice();
            return byteBuffer;
        }
        finally {
            this.byteBuffer.limit(oldLimit);
        }
    }

    public boolean compact() {
        if (this.isReleased()) {
            return false;
        }
        if (this.size() == 0 && !this.byteBuffer.hasRemaining()) {
            return true;
        }
        if (this.byteBuffer.position() == 0) {
            this.size = this.byteBuffer.limit();
            return true;
        }
        int position = this.byteBuffer.position();
        int limit = this.byteBuffer.limit();
        boolean result = false;
        if (TByteBuffer.moveData(this.byteBuffer, position * -1)) {
            this.byteBuffer.position(0);
            this.size = limit - position;
            this.byteBuffer.limit(this.size);
            result = true;
        }
        return result;
    }

    public boolean waitData(int length, int timeout, Runnable supplier) {
        try {
            TEnv.wait(timeout, () -> {
                this.checkRelease();
                if (this.size() >= length) {
                    return false;
                }
                supplier.run();
                return this.size() < length;
            });
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public boolean waitData(byte[] mark, int timeout, Runnable supplier) {
        try {
            TEnv.wait(timeout, () -> {
                this.checkRelease();
                if (this.indexOf(mark) != -1) {
                    return false;
                }
                supplier.run();
                return this.indexOf(mark) == -1;
            });
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public boolean reallocate(int newSize) throws LargerThanMaxSizeException {
        this.checkRelease();
        if (this.maxSize < newSize) {
            throw new LargerThanMaxSizeException("Max size: " + this.maxSize + ", expect size: " + newSize);
        }
        if (TByteBuffer.reallocate(this.byteBuffer, newSize)) {
            this.resetAddress();
            return true;
        }
        return false;
    }

    public int write(int writePosition, ByteBuffer src) {
        this.checkRelease();
        if (src.remaining() == 0) {
            return 0;
        }
        if (src == null) {
            return -1;
        }
        int writeSize = src.limit() - src.position();
        if (writeSize > 0) {
            if (this.available() < writeSize) {
                int newSize = this.byteBuffer.capacity() + writeSize;
                this.reallocate(newSize);
            }
            int position = this.byteBuffer.position();
            this.byteBuffer.position(writePosition);
            if (TByteBuffer.moveData(this.byteBuffer, writeSize)) {
                this.size += writeSize;
                this.byteBuffer.limit(this.size);
                this.byteBuffer.position(writePosition);
                this.byteBuffer.put(src);
                if (position > writePosition) {
                    position += writeSize;
                }
                this.byteBuffer.position(position);
            } else {
                this.checkRelease();
                throw new RuntimeException("move data failed");
            }
        }
        return writeSize;
    }

    public int writeEnd(ByteBuffer src) {
        this.checkRelease();
        return this.write(this.size(), src);
    }

    public int writeHead(ByteBuffer src) {
        return this.write(0, src);
    }

    public int readHead(ByteBuffer dst) {
        return this.read(0, dst);
    }

    public int readEnd(ByteBuffer dst) {
        this.checkRelease();
        return this.read(this.size() - dst.limit(), dst);
    }

    public int read(int readPosition, ByteBuffer dst) {
        this.checkRelease();
        if (dst.remaining() == 0) {
            return 0;
        }
        if (dst == null) {
            return -1;
        }
        int readSize = 0;
        readSize = dst.remaining() > this.size - readPosition ? this.size - readPosition : dst.remaining();
        if (readSize != 0) {
            int position = this.byteBuffer.position();
            this.byteBuffer.position(readPosition);
            int dstRemain = dst.remaining();
            int oldLimit = this.byteBuffer.limit();
            if (dstRemain < this.byteBuffer.remaining()) {
                this.byteBuffer.limit(dstRemain);
            }
            dst.put(this.byteBuffer);
            this.byteBuffer.limit(oldLimit);
            if (TByteBuffer.moveData(this.byteBuffer, readSize * -1)) {
                this.size -= readSize;
                this.byteBuffer.limit(this.size);
                if (position > readPosition) {
                    position += readSize * -1;
                }
                this.byteBuffer.position(position);
            } else {
                dst.reset();
            }
        }
        dst.flip();
        return readSize;
    }

    public int indexOf(byte[] mark) {
        this.checkRelease();
        if (this.size() == 0) {
            return -1;
        }
        return TByteBuffer.indexOf(this.byteBuffer, mark);
    }

    public boolean startWith(byte[] mark) {
        this.checkRelease();
        if (this.size() < mark.length) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < mark.length; ++i) {
            if (mark[i] == this.get(i)) continue;
            result = false;
            break;
        }
        return result;
    }

    public String readLine() {
        ByteBuffer byteBuffer;
        this.checkRelease();
        if (this.size() == 0) {
            return null;
        }
        String lineStr = "";
        int index = this.indexOf("\n".getBytes());
        if (index >= 0) {
            byteBuffer = this.getByteBuffer();
            if (byteBuffer == null) {
                return null;
            }
            int limit = byteBuffer.limit();
            byteBuffer.limit(index + 1);
            lineStr = TByteBuffer.toString(byteBuffer);
            byteBuffer.limit(limit);
            byteBuffer.position(index + 1);
            this.compact();
        }
        if (this.size() > 0 && index == -1) {
            byteBuffer = this.getByteBuffer();
            lineStr = TByteBuffer.toString(byteBuffer);
            byteBuffer.position(byteBuffer.limit());
            this.compact();
        }
        return lineStr.isEmpty() && index == -1 ? null : lineStr;
    }

    public ByteBuffer readWithSplit(byte[] splitByte) {
        this.checkRelease();
        if (this.size() == 0) {
            return TByteBuffer.EMPTY_BYTE_BUFFER;
        }
        int index = this.indexOf(splitByte);
        if (this.size() == 0) {
            return TByteBuffer.EMPTY_BYTE_BUFFER;
        }
        if (index == 0) {
            try {
                this.getByteBuffer().position(splitByte.length);
            }
            finally {
                this.compact();
            }
            index = this.indexOf(splitByte);
        }
        if (index == -1) {
            index = this.size();
        }
        ByteBuffer resultBuffer = TByteBuffer.allocateDirect(index);
        int readSize = this.readHead(resultBuffer);
        TByteBuffer.release(resultBuffer);
        this.shrink(splitByte.length);
        return resultBuffer;
    }

    public void saveToFile(String filePath, long length) throws IOException {
        this.checkRelease();
        if (this.size() == 0) {
            return;
        }
        int bufferSize = 0x100000;
        if (length < (long)bufferSize) {
            bufferSize = Long.valueOf(length).intValue();
        }
        new File(TFile.getFileDirectory(filePath)).mkdirs();
        RandomAccessFile randomAccessFile = null;
        File file = new File(filePath);
        byte[] buffer = new byte[bufferSize];
        try {
            randomAccessFile = new RandomAccessFile(file, "rwd");
            randomAccessFile.seek(randomAccessFile.length());
            int loadSize = bufferSize;
            ByteBuffer tempByteBuffer = ByteBuffer.wrap(buffer);
            while (length > 0L) {
                loadSize = length > (long)bufferSize ? bufferSize : Long.valueOf(length).intValue();
                tempByteBuffer.limit(loadSize);
                this.readHead(tempByteBuffer);
                randomAccessFile.write(buffer, 0, loadSize);
                length -= (long)loadSize;
                tempByteBuffer.clear();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            randomAccessFile.close();
        }
    }

    public String toString() {
        return "{size=" + this.size + ", capacity=" + this.capacity() + ", released=" + (this.address.get() == 0L) + ", maxSize=" + this.maxSize + "}";
    }

    public String content() {
        return new String(this.array());
    }
}

