/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools.aop;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.function.Predicate;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import org.voovan.tools.TEnv;
import org.voovan.tools.TString;
import org.voovan.tools.aop.AopUtils;
import org.voovan.tools.aop.CutPointInfo;
import org.voovan.tools.collection.CollectionSearch;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class Aop {
    private static boolean IS_AOP_ON = false;
    private static Instrumentation instrumentation;

    public static void init(String scanPackage) throws Exception {
        Aop.init(null, scanPackage);
    }

    public static void init(String agentJarPath, String scanPackages) throws IOException, AttachNotSupportedException, AgentLoadException, AgentInitializationException, ClassNotFoundException {
        if (scanPackages == null) {
            return;
        }
        for (String scanPackage : scanPackages.split(",")) {
            AopUtils.scanAopClass(scanPackage);
        }
        IS_AOP_ON = true;
        instrumentation = TEnv.agentAttach(agentJarPath);
        if (instrumentation != null) {
            instrumentation.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader loader, String classPath, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                    String className = classPath.replaceAll(File.separator, ".");
                    if (!TReflect.isSystemType(className)) {
                        return Aop.Inject(className, classfileBuffer);
                    }
                    return classfileBuffer;
                }
            });
            Logger.info("[AOP] Enable aop success ");
        } else {
            Logger.error("[AOP] Enable aop failed ");
        }
    }

    public static byte[] Inject(final String className, byte[] classfileBuffer) {
        CtClass ctClass = null;
        try {
            try {
                ctClass = AopUtils.CLASSPOOL.get(className);
                ctClass.detach();
            }
            catch (NotFoundException e) {
                return classfileBuffer;
            }
            for (final CtMethod originMethod : ctClass.getDeclaredMethods()) {
                List avaliableCutPointInfo = (List)CollectionSearch.newInstance(AopUtils.CUT_POINTINFO_LIST).setParallelStream(false).addCondition(new Predicate(){

                    public boolean test(Object o) {
                        CutPointInfo cutPointInfo = (CutPointInfo)o;
                        String cutPointClassName = cutPointInfo.getClazzName().replaceAll("\\.", "\\\\.");
                        return TString.searchByRegex(className, cutPointClassName = cutPointClassName.replaceAll("\\*", ".*?")).length > 0;
                    }
                }).addCondition(new Predicate(){

                    public boolean test(Object o) {
                        CutPointInfo cutPointInfo = (CutPointInfo)o;
                        if (cutPointInfo.getMethodName().equals("*")) {
                            return true;
                        }
                        String innerMethodName = cutPointInfo.getMethodName().replaceAll("\\*", ".*?");
                        innerMethodName = "^" + innerMethodName + "$";
                        return TString.searchByRegex(originMethod.getName(), innerMethodName).length > 0;
                    }
                }).addCondition(new Predicate(){

                    public boolean test(Object o) {
                        boolean parameterTypeEqual = false;
                        boolean resultTypeEqual = false;
                        CutPointInfo cutPointInfo = (CutPointInfo)o;
                        try {
                            if (cutPointInfo.getParameterTypes().length > 0 && cutPointInfo.getParameterTypes()[0].equals("..")) {
                                parameterTypeEqual = true;
                            } else if (cutPointInfo.getParameterTypes().length == originMethod.getParameterTypes().length) {
                                for (int x = 0; x < cutPointInfo.getParameterTypes().length; ++x) {
                                    CtClass methodParameterCtClass = originMethod.getParameterTypes()[x];
                                    if (methodParameterCtClass.getName().equals(cutPointInfo.getParameterTypes()[x])) continue;
                                    return false;
                                }
                                parameterTypeEqual = true;
                            }
                            if ("*".equals(cutPointInfo.getResultType()) || originMethod.getReturnType().getName().equals(cutPointInfo.getResultType())) {
                                resultTypeEqual = true;
                            }
                            return parameterTypeEqual && resultTypeEqual;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                }).search();
                for (CutPointInfo cutPointInfo : avaliableCutPointInfo) {
                    try {
                        String thisParam = "this";
                        String cutPointClassName = cutPointInfo.getCutPointMethod().getDeclaringClass().getName();
                        String cutPointMethodName = cutPointInfo.getCutPointMethod().getName();
                        boolean isLambda = originMethod.getName().startsWith("lambda$");
                        if ((originMethod.getModifiers() & 8) != 0 || isLambda) {
                            thisParam = "null";
                        }
                        if (cutPointInfo.isInterceptLambda() && isLambda) continue;
                        if (cutPointInfo.getType() == -1) {
                            originMethod.insertBefore("{" + cutPointClassName + "." + cutPointMethodName + "(new org.voovan.tools.aop.InterceptInfo($class, \"" + originMethod.getName() + "\", " + thisParam + ", $sig, $args, null, null, null));}");
                            System.out.println("[AOP] Code weaved -> BEFORE:\t\t " + cutPointInfo.getClazzName() + "@" + cutPointMethodName + " -> " + cutPointInfo.getClazzName());
                        }
                        if (cutPointInfo.getType() == 1) {
                            originMethod.insertAfter("{" + cutPointClassName + "." + cutPointMethodName + "(new org.voovan.tools.aop.InterceptInfo($class, \"" + originMethod.getName() + "\", " + thisParam + ", $sig, $args, $type, ($w)$_, null));}");
                            System.out.println("[AOP] Code weaved -> AFTER:\t\t     " + cutPointInfo.getClazzName() + "@" + cutPointMethodName + " -> " + cutPointInfo.getClazzName());
                        }
                        if (cutPointInfo.getType() == 2) {
                            CtClass exceptionType = ClassPool.getDefault().get("java.lang.Exception");
                            originMethod.addCatch("{" + cutPointClassName + "." + cutPointMethodName + "(new org.voovan.tools.aop.InterceptInfo($class, \"" + originMethod.getName() + "\", " + thisParam + ", $sig, $args, null, null, $e));  throw $e;}", exceptionType);
                            System.out.println("[AOP] Code weaved -> EXCEPTION:\t\t " + cutPointInfo.getClazzName() + "@" + cutPointMethodName + " -> " + cutPointInfo.getClazzName());
                        }
                        if (cutPointInfo.getType() != 3) continue;
                        String originMethodName = originMethod.getName();
                        CtMethod ctNewMethod = CtNewMethod.copy((CtMethod)originMethod, (CtClass)ctClass, null);
                        ctNewMethod.setName(originMethodName);
                        originMethod.setName(originMethod.getName() + "$origin");
                        AnnotationsAttribute attribute = (AnnotationsAttribute)originMethod.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
                        if (attribute != null) {
                            originMethod.getMethodInfo().removeAttribute(attribute.getName());
                            ctNewMethod.getMethodInfo().addAttribute((AttributeInfo)attribute);
                        }
                        ctClass.addMethod(ctNewMethod);
                        ctNewMethod.setBody("{ return " + cutPointClassName + "." + cutPointMethodName + "(new org.voovan.tools.aop.InterceptInfo($class, \"" + originMethodName + "\", " + thisParam + ", $sig, $args, null, null, null));}");
                        System.out.println("[AOP] Code weaved -> AROUND:\t\t " + cutPointInfo.getClazzName() + "@" + cutPointMethodName + " -> " + cutPointInfo.getClazzName());
                    }
                    catch (CannotCompileException e) {
                        e.printStackTrace();
                    }
                }
            }
            CtClass.debugDump = "./dump";
            classfileBuffer = ctClass.toBytecode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classfileBuffer;
    }
}

