/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.voovan.tools.TEnv;
import org.voovan.tools.TString;

public class UniqueId {
    private static final int SEQ_DEFAULT = 0;
    private static final int RADIX = 62;
    private static final int SEQUENCE_LEFT = 11;
    private static final int SIGNID_LEFT = 11;
    private static final int MAX_SIGNID = 2048;
    private static final int MAX_SEQUENCE = 2048;
    private volatile AtomicInteger orderedIdSequence = new AtomicInteger(0);
    private Long lastTime = 0L;
    private int workId = 0;

    public UniqueId() {
        int workId = new SecureRandom().nextInt(2048);
        if (workId > 2048 || workId < 0) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 2048));
        }
        workId = 0;
    }

    public UniqueId(int signId) {
        if (signId >= 2048 || signId < 0) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 2048));
        }
        this.workId = signId;
    }

    public long nextNumber() {
        return this.generateId();
    }

    public String nextString() {
        return TString.radixConvert(this.generateId(), 62);
    }

    public synchronized long generateId() {
        long currentTime = System.currentTimeMillis();
        if (this.lastTime < currentTime) {
            this.orderedIdSequence.set(0);
        } else if (this.lastTime > currentTime) {
            throw new RuntimeException("Clock moved backwards.");
        }
        if (this.orderedIdSequence.get() >= 2048) {
            TEnv.sleep(1);
            this.orderedIdSequence.set(0);
        }
        long resultId = currentTime << 22 | (long)(this.workId << 11) | (long)this.orderedIdSequence.getAndAdd(1);
        this.lastTime = System.currentTimeMillis();
        return resultId;
    }
}

