/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.Unsafe;

public class TUnsafe {
    private static Unsafe unsafe;
    private static ConcurrentHashMap<Field, Long> OFFSET_MAP;

    public static Unsafe getUnsafe() {
        return unsafe;
    }

    public static Long getFieldOffset(Field field) {
        Long offset = OFFSET_MAP.get(field);
        if (offset == null) {
            offset = unsafe.objectFieldOffset(field);
            OFFSET_MAP.put(field, offset);
        }
        return offset;
    }

    public static <T> T allocateInstance(Class clazz) throws InstantiationException {
        return (T)unsafe.allocateInstance(clazz);
    }

    public static void putObject(Object obj, Field field, Object value) {
        unsafe.putObject(obj, TUnsafe.getFieldOffset(field), value);
    }

    public static void putByte(Object obj, Field field, byte value) {
        unsafe.putByte(obj, TUnsafe.getFieldOffset(field), value);
    }

    public static void putIntger(Object obj, Field field, int value) {
        unsafe.putInt(obj, TUnsafe.getFieldOffset(field), value);
    }

    public static void putShort(Object obj, Field field, short value) {
        unsafe.putShort(obj, TUnsafe.getFieldOffset(field), value);
    }

    public static void putBoolean(Object obj, Field field, boolean value) {
        unsafe.putBoolean(obj, TUnsafe.getFieldOffset(field), value);
    }

    public static void putLong(Object obj, Field field, long value) {
        unsafe.putLong(obj, TUnsafe.getFieldOffset(field), value);
    }

    public static void putFloat(Object obj, Field field, float value) {
        unsafe.putFloat(obj, TUnsafe.getFieldOffset(field), value);
    }

    public static void putDobule(Object obj, Field field, double value) {
        unsafe.putDouble(obj, TUnsafe.getFieldOffset(field), value);
    }

    public static <T> T getObject(Object obj, Field field) {
        return (T)unsafe.getObject(obj, TUnsafe.getFieldOffset(field));
    }

    public static byte getByte(Object obj, Field field) {
        return unsafe.getByte(obj, TUnsafe.getFieldOffset(field));
    }

    public static int getIntger(Object obj, Field field) {
        return unsafe.getInt(obj, TUnsafe.getFieldOffset(field));
    }

    public static short getShort(Object obj, Field field) {
        return unsafe.getShort(obj, TUnsafe.getFieldOffset(field));
    }

    public static boolean getBoolean(Object obj, Field field) {
        return unsafe.getBoolean(obj, TUnsafe.getFieldOffset(field));
    }

    public static long getLong(Object obj, Field field) {
        return unsafe.getLong(obj, TUnsafe.getFieldOffset(field));
    }

    public static float getFloat(Object obj, Field field) {
        return unsafe.getFloat(obj, TUnsafe.getFieldOffset(field));
    }

    public static double getDobule(Object obj, Field field) {
        return unsafe.getDouble(obj, TUnsafe.getFieldOffset(field));
    }

    static {
        OFFSET_MAP = new ConcurrentHashMap();
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

