/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.voovan.Global;
import org.voovan.tools.TObject;
import org.voovan.tools.json.JSON;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class TString {
    private static Map<Integer, Pattern> regexPattern = new ConcurrentHashMap<Integer, Pattern>();
    public static String TOKEN_PREFIX_REGEX = "\\{\\{";
    public static String TOKEN_SUFFIX_REGEX = "\\}\\}";
    public static String[] chars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    public static Map<String, Integer> unChars = TObject.asMap(Character.valueOf('0'), 0, Character.valueOf('1'), 1, Character.valueOf('2'), 2, Character.valueOf('3'), 3, Character.valueOf('4'), 4, Character.valueOf('5'), 5, Character.valueOf('6'), 6, Character.valueOf('7'), 7, Character.valueOf('8'), 8, Character.valueOf('9'), 9, Character.valueOf('A'), 10, Character.valueOf('B'), 11, Character.valueOf('C'), 12, Character.valueOf('D'), 13, Character.valueOf('E'), 14, Character.valueOf('F'), 15, Character.valueOf('G'), 16, Character.valueOf('H'), 17, Character.valueOf('I'), 18, Character.valueOf('J'), 19, Character.valueOf('K'), 20, Character.valueOf('L'), 21, Character.valueOf('M'), 22, Character.valueOf('N'), 23, Character.valueOf('O'), 24, Character.valueOf('P'), 25, Character.valueOf('Q'), 26, Character.valueOf('R'), 27, Character.valueOf('S'), 28, Character.valueOf('T'), 29, Character.valueOf('U'), 30, Character.valueOf('V'), 31, Character.valueOf('W'), 32, Character.valueOf('X'), 33, Character.valueOf('Y'), 34, Character.valueOf('Z'), 35, Character.valueOf('a'), 36, Character.valueOf('b'), 37, Character.valueOf('c'), 38, Character.valueOf('d'), 39, Character.valueOf('e'), 40, Character.valueOf('f'), 41, Character.valueOf('g'), 42, Character.valueOf('h'), 43, Character.valueOf('i'), 44, Character.valueOf('j'), 45, Character.valueOf('k'), 46, Character.valueOf('l'), 47, Character.valueOf('m'), 48, Character.valueOf('n'), 49, Character.valueOf('o'), 50, Character.valueOf('p'), 51, Character.valueOf('q'), 52, Character.valueOf('r'), 53, Character.valueOf('s'), 54, Character.valueOf('t'), 55, Character.valueOf('u'), 56, Character.valueOf('v'), 57, Character.valueOf('w'), 58, Character.valueOf('x'), 59, Character.valueOf('y'), 60, Character.valueOf('z'), 61);

    public static String uppercaseHead(String source) {
        if (source == null) {
            return null;
        }
        char[] charArray = source.toCharArray();
        charArray[0] = Character.toUpperCase(charArray[0]);
        return new String(charArray);
    }

    public static String removePrefix(String source) {
        if (source == null) {
            return null;
        }
        return source.substring(1, source.length());
    }

    public static String removeSuffix(String source) {
        if (source == null) {
            return null;
        }
        if (source.isEmpty()) {
            return source;
        }
        return source.substring(0, source.length() - 1);
    }

    public static String leftPad(String source, int len, char c) {
        if (source == null) {
            source = "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len - source.length(); ++i) {
            sb.append(c);
        }
        return sb.append(source).toString();
    }

    public static String rightPad(String source, int len, char c) {
        if (source == null) {
            source = "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(source);
        for (int i = 0; i < len - source.length(); ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isNumber(String numberString, int radix) {
        if (numberString == null) {
            return false;
        }
        try {
            Integer.parseInt(numberString, radix);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInteger(String integerString) {
        return integerString != null && TString.regexMatch(integerString, "^-?[0-9]\\d*$") > 0;
    }

    public static boolean isDecimal(String decimalString) {
        return decimalString != null && TString.regexMatch(decimalString, "^-?\\d+\\.\\d+$") > 0;
    }

    public static boolean isBoolean(String booleanString) {
        return "true".equalsIgnoreCase(booleanString) || "false".equalsIgnoreCase(booleanString);
    }

    private static Pattern getCachedPattern(String regex, Integer flags) {
        Pattern pattern = null;
        flags = flags == null ? 0 : flags;
        if (regexPattern.containsKey(regex.hashCode())) {
            pattern = regexPattern.get(regex.hashCode());
        } else {
            pattern = Pattern.compile(regex, flags);
            regexPattern.put(regex.hashCode(), pattern);
        }
        return pattern;
    }

    public static Matcher doRegex(String source, String regex) {
        return TString.doRegex(source, regex, 0);
    }

    public static Matcher doRegex(String source, String regex, Integer flags) {
        if (source == null) {
            return null;
        }
        Pattern pattern = TString.getCachedPattern(regex, flags);
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher;
        }
        return null;
    }

    public static String[] searchByRegex(String source, String regex) {
        return TString.searchByRegex(source, regex, 0);
    }

    public static String[] searchByRegex(String source, String regex, Integer flags) {
        if (source == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = TString.doRegex(source, regex, flags);
        if (matcher != null) {
            do {
                result.add(matcher.group());
            } while (matcher.find());
        }
        return result.toArray(new String[0]);
    }

    public static int regexMatch(String source, String regex) {
        return TString.regexMatch(source, regex, 0);
    }

    public static int regexMatch(String source, String regex, Integer flags) {
        return TString.searchByRegex(source, regex, flags).length;
    }

    public static String fastReplaceAll(String source, String regex, String replacement) {
        return TString.fastReplaceAll(source, regex, replacement, 0);
    }

    public static String fastReplaceAll(String source, String regex, String replacement, Integer flags) {
        Pattern pattern = TString.getCachedPattern(regex, flags);
        return pattern.matcher(source).replaceAll(Matcher.quoteReplacement(replacement));
    }

    public static boolean isNullOrEmpty(String source) {
        return source == null || source.isEmpty();
    }

    public static String tokenReplace(String source, Map<String, ?> tokens) {
        if (source == null) {
            return null;
        }
        for (Map.Entry<String, ?> entry : tokens.entrySet()) {
            String value = entry.getValue() == null ? "null" : entry.getValue().toString();
            source = TString.oneTokenReplace(source, entry.getKey(), value);
        }
        return source;
    }

    public static String tokenReplace(String source, List<Object> list) {
        Map<String, Object> tokens = TObject.arrayToMap(list.toArray());
        return TString.tokenReplace(source, tokens);
    }

    public static String tokenReplace(String source, Object ... args) {
        if (source == null) {
            return null;
        }
        source = TString.tokenReplace(source, TObject.arrayToMap(args));
        return source;
    }

    public static String oneTokenReplace(String source, String tokenName, String tokenValue) {
        String TOKEN_PREFIX = TString.fastReplaceAll(TOKEN_PREFIX_REGEX, "\\\\", "");
        String TOKEN_SUFFIX = TString.fastReplaceAll(TOKEN_SUFFIX_REGEX, "\\\\", "");
        String TOKEN_EMPTY = TOKEN_PREFIX + TOKEN_SUFFIX;
        if (source == null) {
            return null;
        }
        if (source.contains(TOKEN_PREFIX + tokenName + TOKEN_SUFFIX)) {
            return TString.fastReplaceAll(source, TOKEN_PREFIX_REGEX + tokenName + TOKEN_SUFFIX_REGEX, tokenValue == null ? "null" : Matcher.quoteReplacement(tokenValue));
        }
        if ((tokenName == null || TString.isInteger(tokenName)) && source.contains(TOKEN_EMPTY)) {
            return TString.replaceFirst(source, TOKEN_EMPTY, tokenValue);
        }
        return source;
    }

    public static String replaceFirst(String source, String mark, String replacement) {
        if (source == null) {
            return null;
        }
        int head = source.indexOf(mark);
        int tail = head + mark.length();
        replacement = TObject.nullDefault(replacement, "");
        source = source.substring(0, head) + replacement + source.substring(tail, source.length());
        return source;
    }

    public static String replaceLast(String source, String mark, String replacement) {
        if (source == null) {
            return null;
        }
        int head = source.lastIndexOf(mark);
        int tail = head + mark.length();
        replacement = TObject.nullDefault(replacement, "");
        source = source.substring(0, head) + replacement + source.substring(tail, source.length());
        return source;
    }

    public static String indent(String source, int indentCount) {
        if (indentCount > 0 && source != null) {
            StringBuilder indent = new StringBuilder();
            for (int i = 0; i < indentCount; ++i) {
                indent.append(" ");
            }
            source = indent.toString() + source;
            source = TString.fastReplaceAll(source, "\n", "\n" + indent.toString());
        }
        return source;
    }

    public static String reverse(String source) {
        if (source != null) {
            char[] array = source.toCharArray();
            StringBuilder reverse = new StringBuilder();
            for (int i = array.length - 1; i >= 0; --i) {
                reverse.append(array[i]);
            }
            return reverse.toString();
        }
        return null;
    }

    public static String convertEscapeChar(String source) {
        if (source == null) {
            return null;
        }
        source = TString.fastReplaceAll(source, "\\[^u][^[0-9|a-f]]{4}", "\\u005c");
        source = TString.fastReplaceAll(source, "\f", "\\u000c");
        source = TString.fastReplaceAll(source, "'", "\\u0027");
        source = TString.fastReplaceAll(source, "\r", "\\u000d");
        source = TString.fastReplaceAll(source, "\"", "\\u0022");
        source = TString.fastReplaceAll(source, "\b", "\\u0008");
        source = TString.fastReplaceAll(source, "\t", "\\u0009");
        source = TString.fastReplaceAll(source, "\n", "\\u000a");
        return source;
    }

    public static String unConvertEscapeChar(String source) {
        if (source == null) {
            return null;
        }
        source = TString.fastReplaceAll(source, "\\\\u005c", "\\");
        source = TString.fastReplaceAll(source, "\\\\u000c", "\f");
        source = TString.fastReplaceAll(source, "\\\\u0027", "'");
        source = TString.fastReplaceAll(source, "\\\\u000d", "\r");
        source = TString.fastReplaceAll(source, "\\\\u0022", "\"");
        source = TString.fastReplaceAll(source, "\\\\u0008", "\b");
        source = TString.fastReplaceAll(source, "\\\\u0009", "\t");
        source = TString.fastReplaceAll(source, "\\\\u000a", "\n");
        return source;
    }

    public static String toUnicode(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            result.append("\\u" + TString.leftPad(Integer.toHexString(c), 4, '0'));
        }
        return result.toString();
    }

    public static String fromUnicode(String source) {
        if (source == null) {
            return null;
        }
        if (source.contains("\\u")) {
            StringBuffer result = new StringBuffer();
            String[] hex = source.split("\\\\u");
            for (int i = 0; i < hex.length; ++i) {
                String element = hex[i];
                if (element.length() >= 4) {
                    String codePoint = element.substring(0, 4);
                    int charCode = Integer.parseInt(codePoint, 16);
                    result.append((char)charCode);
                    element = element.substring(4, element.length());
                }
                result.append(element);
            }
            return result.toString();
        }
        return source;
    }

    public static <T> T toObject(String value, Type type, boolean ignoreCase) {
        Class clazz = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            clazz = (Class)parameterizedType.getRawType();
        } else if (type instanceof Class) {
            clazz = (Class)type;
        } else {
            return (T)value;
        }
        if (value == null && !clazz.isPrimitive()) {
            return null;
        }
        if (value.equals("null") && !clazz.isPrimitive()) {
            value = null;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            value = value == null ? "0" : value;
            return (T)Integer.valueOf(value);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            value = value == null ? "0" : value;
            return (T)Float.valueOf(value);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            value = value == null ? "0" : value;
            return (T)Double.valueOf(value);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            value = value == null ? "false" : value;
            return (T)Boolean.valueOf(value);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            value = value == null ? "0" : value;
            return (T)Long.valueOf(value);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            value = value == null ? "0" : value;
            return (T)Short.valueOf(value);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            value = value == null ? "0" : value;
            return (T)Byte.valueOf(value);
        }
        if (clazz == Byte.TYPE || TReflect.isExtendsByClass(clazz, Date.class)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return value != null ? (T)TReflect.newInstance(clazz, dateFormat.parse(value).getTime()) : null;
            }
            catch (Exception e) {
                Logger.error("TString.toObject error: ", e);
                return null;
            }
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            Character tmpValue = value != null ? Character.valueOf(value.charAt(0)) : null;
            return (T)tmpValue;
        }
        if ((TReflect.isImpByInterface(clazz, Collection.class) || clazz.isArray()) && JSON.isJSONList(value)) {
            return JSON.toObject(value, type, ignoreCase);
        }
        if (TReflect.isImpByInterface(clazz, Map.class) && JSON.isJSONMap(value)) {
            return JSON.toObject(value, type, ignoreCase);
        }
        if (JSON.isJSON(value) && !TReflect.isSystemType(clazz)) {
            return JSON.toObject(value, type, ignoreCase);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return (T)value.substring(1, value.length() - 1);
        }
        if (clazz == BigDecimal.class) {
            return (T)new BigDecimal(value);
        }
        return (T)value;
    }

    public static <T> T toObject(String value, Type type) {
        return TString.toObject(value, type, false);
    }

    public static String radixConvert(long num, int radix) {
        long value;
        if (radix < 2 || radix > 62) {
            return null;
        }
        num = num < 0L ? num * -1L : num;
        String result = "";
        long tmpValue = num;
        while (true) {
            value = (int)(tmpValue % (long)radix);
            result = chars[(int)value] + result;
            value = tmpValue / (long)radix;
            if (value < (long)radix) break;
            tmpValue = value;
        }
        result = chars[(int)value] + result;
        return result;
    }

    public static long radixUnConvert(String str, int radix) {
        long result = unChars.get(Character.valueOf(str.charAt(0))).intValue();
        for (int i = 1; i < str.length(); ++i) {
            char c = str.charAt(i);
            int val = unChars.get(Character.valueOf(c));
            result = result * 62L + (long)val;
        }
        return result;
    }

    public static String generateShortUUID() {
        StringBuffer shortBuffer = new StringBuffer();
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(TString.radixConvert(x, 62));
        }
        return shortBuffer.toString();
    }

    public static String generateId() {
        return TString.generateId(null, null);
    }

    public static String generateId(Object obj) {
        return TString.generateId(obj, null);
    }

    public static String generateId(Object obj, String sign) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (sign == null) {
            sign = Global.NAME;
        }
        if (obj == null) {
            obj = random.nextInt();
        }
        long currentTime = System.currentTimeMillis();
        long mark = currentTime ^ random.nextLong();
        long randomMark = currentTime ^ random.nextLong();
        long id = (long)obj.hashCode() ^ Runtime.getRuntime().freeMemory() ^ mark ^ new Random(randomMark).nextLong() ^ Long.valueOf(sign, 36);
        return TString.radixConvert(id, 62);
    }

    public static int maxLineLength(String source) {
        String[] lines = source.split("\n");
        int maxLineLength = -1;
        for (String line : lines) {
            if (maxLineLength >= line.length()) continue;
            maxLineLength = line.length();
        }
        return maxLineLength;
    }

    public static String[] split(String source, String regex) {
        if (source == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(source, regex);
        ArrayList<String> items = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            items.add(stringTokenizer.nextToken());
        }
        return items.toArray(new String[items.size()]);
    }

    public static String insert(String source, int position, String value) {
        if (position <= 0) {
            throw new IllegalArgumentException("parameter position must lager than 0");
        }
        return source.substring(0, position) + value + source.substring(position);
    }

    public static String trimEndLF(String source) {
        return source.replaceAll("[\r\n]*$", "");
    }

    public static int retract(String source) {
        int currentRetract;
        for (currentRetract = 0; currentRetract < source.length(); ++currentRetract) {
            if (source.charAt(currentRetract) == ' ') continue;
            if (currentRetract <= 0) break;
            --currentRetract;
            break;
        }
        return currentRetract;
    }

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        sb.append(param.charAt(0));
        for (int i = 1; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append("_");
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        sb.append(param.charAt(0));
        for (int i = 1; i < len; ++i) {
            char c = param.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String assembly(Object ... items) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object item : items) {
            stringBuilder.append(item);
        }
        return stringBuilder.toString();
    }

    public static byte[] toAsciiBytes(String str) {
        byte[] bytes = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            bytes[i] = (byte)str.charAt(i);
        }
        return bytes;
    }

    public static String toAsciiString(byte[] bytes, int offset, int length) {
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = offset; i < length; ++i) {
            stringBuilder.append((char)(bytes[i] & 0xFF));
        }
        return stringBuilder.toString();
    }

    public static String readLine(String str, int beginIndex) {
        if (beginIndex == str.length()) {
            return null;
        }
        int lineIndex = str.indexOf("\n", beginIndex);
        lineIndex = lineIndex == -1 ? str.length() : lineIndex + 1;
        return str.substring(beginIndex, lineIndex);
    }
}

