/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.voovan.tools.TObject;
import org.voovan.tools.TProperties;
import org.voovan.tools.json.JSON;
import org.voovan.tools.json.JSONPath;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class TSerialize {
    public static int SERIALIZE_TYPE = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeJDK(Object object) {
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("object must be implement Serializable");
        }
        ObjectOutputStream objectOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] result = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            result = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            Logger.error("TSerialize.serializeJDK error: ", e);
            result = null;
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unserializeJDK(byte[] bytes) {
        ByteArrayInputStream byteArrayInputStream = null;
        Object result = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(byteArrayInputStream);
            result = ois.readObject();
        }
        catch (Exception e) {
            Logger.error("TSerialize.unserializeJDK error: ", e);
            result = null;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static byte[] serializeJSON(Object object) {
        try {
            Class<?> clazz = object.getClass();
            Class[] genericClazzs = TReflect.getGenericClass(object);
            ArrayList<String> genericClazzStrs = null;
            if (genericClazzs != null) {
                genericClazzStrs = new ArrayList<String>();
                for (Class genericClazz : genericClazzs) {
                    genericClazzStrs.add(genericClazz.getCanonicalName());
                }
            }
            return JSON.toJSON(TObject.asMap("T", clazz.getCanonicalName(), "G", genericClazzStrs, "V", object)).getBytes();
        }
        catch (Exception e) {
            Logger.error("TSerialize.serializeJDK error: ", e);
            return null;
        }
    }

    public static Object unserializeJSON(byte[] bytes) {
        try {
            Class<?> mainClazz = null;
            JSONPath jsonPath = new JSONPath(new String(bytes));
            mainClazz = Class.forName(jsonPath.value("/T", String.class));
            List<String> genericClazzStrs = jsonPath.listObject("/G", String.class);
            Class[] genericClazzs = new Class[genericClazzStrs.size()];
            for (int i = 0; i < genericClazzStrs.size(); ++i) {
                genericClazzs[i] = Class.forName(genericClazzStrs.get(i));
            }
            Class[] classArray = genericClazzs = genericClazzs.length == 0 ? null : genericClazzs;
            if (TReflect.isImpByInterface(mainClazz, Map.class) || TReflect.isImpByInterface(mainClazz, Collection.class)) {
                return TReflect.getObjectFromMap(mainClazz, (Map)jsonPath.mapObject("/V", genericClazzs), true);
            }
            return jsonPath.value("/V", mainClazz);
        }
        catch (Exception e) {
            Logger.error("TSerialize.serializeJDK error: ", e);
            return null;
        }
    }

    public static byte[] serialize(Object object) {
        if (SERIALIZE_TYPE == 0) {
            return TSerialize.serializeJDK(object);
        }
        if (SERIALIZE_TYPE == 1) {
            return TSerialize.serializeJSON(object);
        }
        return TSerialize.serializeJDK(object);
    }

    public static Object unserialize(byte[] bytes) {
        if (SERIALIZE_TYPE == 0) {
            return TSerialize.unserializeJDK(bytes);
        }
        if (SERIALIZE_TYPE == 1) {
            return TSerialize.unserializeJSON(bytes);
        }
        return TSerialize.unserializeJDK(bytes);
    }

    static {
        String serializeType = TProperties.getString("framework", "SerializeType");
        if ("JSON".equalsIgnoreCase(serializeType)) {
            SERIALIZE_TYPE = 1;
        }
        Logger.simple("[SYSTEM] Cache serialize type: " + (SERIALIZE_TYPE == 0 ? "JDK" : "JSON"));
    }
}

