/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.Global;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TString;
import org.voovan.tools.hashwheeltimer.HashWheelTask;

public class TProperties {
    private static ConcurrentHashMap<File, Properties> propertiesCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, File> propertiesFile = new ConcurrentHashMap();
    private static String TIME_STAMP_NAME = "$$LMT";

    public static Properties getProperties(File file) {
        try {
            if (!propertiesCache.containsKey(file)) {
                Properties properites = new Properties();
                String content = null;
                if (!file.getPath().contains("!" + File.separator)) {
                    content = new String(TFile.loadFile(file));
                } else {
                    String filePath = file.getPath();
                    String resourcePath = filePath.substring(filePath.indexOf("!" + File.separator) + 2, filePath.length());
                    content = new String(TFile.loadResource(resourcePath));
                }
                properites.load(new StringReader(content));
                properites.setProperty(TIME_STAMP_NAME, String.valueOf(file.lastModified()));
                propertiesCache.put(file, properites);
                System.out.println("[PROPERTIES] Load Properties file: " + file.getPath());
            }
            return propertiesCache.get(file);
        }
        catch (IOException e) {
            System.out.println("Get properites file failed. File:" + file.getAbsolutePath() + "-->" + e.getMessage());
            return null;
        }
    }

    public static Properties getProperties(String fileName) {
        File file = null;
        if (!propertiesFile.containsKey(fileName)) {
            String configFileNameWithEnv = null;
            String configFileName = "";
            if (!fileName.contains(".properties")) {
                String envName = TEnv.getEnvName();
                envName = envName == null ? "" : "-" + envName;
                configFileNameWithEnv = fileName + envName + ".properties";
                configFileName = fileName + ".properties";
            }
            File configFile = TFile.getResourceFile(configFileName);
            File configFileWithEnv = TFile.getResourceFile(configFileNameWithEnv);
            if (configFileWithEnv != null) {
                file = configFileWithEnv;
            } else if (configFile != null) {
                file = configFile;
            }
            propertiesFile.put(fileName, file);
        } else {
            file = propertiesFile.get(fileName);
        }
        if (file != null) {
            return TProperties.getProperties(file);
        }
        System.out.println("Get properites file failed. File:" + file.getName());
        return null;
    }

    public static String getString(File file, String name) {
        Properties properites = TProperties.getProperties(file);
        return properites.getProperty(name);
    }

    public static int getInt(File file, String name) {
        String value = TProperties.getString(file, name);
        return Integer.valueOf(TString.isNullOrEmpty(value) ? "0" : value.trim());
    }

    public static float getFloat(File file, String name) {
        String value = TProperties.getString(file, name);
        return Float.valueOf(TString.isNullOrEmpty(value) ? "0" : value.trim()).floatValue();
    }

    public static double getDouble(File file, String name) {
        String value = TProperties.getString(file, name);
        return Double.valueOf(TString.isNullOrEmpty(value) ? "0" : value.trim());
    }

    public static boolean getBoolean(File file, String name) {
        Properties properites = TProperties.getProperties(file);
        return Boolean.valueOf(properites.getProperty(name));
    }

    public static void setString(File file, String name, String value) throws IOException {
        Properties properites = TProperties.getProperties(file);
        properites.setProperty(name, value);
        properites.store(new FileOutputStream(file), null);
    }

    public static String getString(String fileName, String name) {
        Properties properites = TProperties.getProperties(fileName);
        return properites.getProperty(name);
    }

    public static int getInt(String fileName, String name) {
        String value = TProperties.getString(fileName, name);
        return Integer.valueOf(TString.isNullOrEmpty(value) ? "0" : value.trim());
    }

    public static float getFloat(String fileName, String name) {
        String value = TProperties.getString(fileName, name);
        return Float.valueOf(TString.isNullOrEmpty(value) ? "0" : value.trim()).floatValue();
    }

    public static double getDouble(String fileName, String name) {
        String value = TProperties.getString(fileName, name);
        return Double.valueOf(TString.isNullOrEmpty(value) ? "0" : value.trim());
    }

    public static boolean getBoolean(String fileName, String name) {
        String value = TProperties.getString(fileName, name);
        return Boolean.valueOf(TString.isNullOrEmpty(value) ? "false" : value.trim());
    }

    public static void clear(String fileName) {
        Iterator iterator = ((ConcurrentHashMap.KeySetView)propertiesCache.keySet()).iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.getName().startsWith(fileName)) continue;
            iterator.remove();
        }
    }

    public void clear() {
        propertiesCache.clear();
    }

    static {
        Global.getHashWheelTimer().addTask(new HashWheelTask(){

            @Override
            public void run() {
                Iterator iterator = propertiesCache.entrySet().iterator();
                while (iterator.hasNext()) {
                    String cachedTimeStamp;
                    String lastTimeStamp;
                    Map.Entry entry = iterator.next();
                    if (!((File)entry.getKey()).exists() || !((Properties)entry.getValue()).containsKey(TIME_STAMP_NAME) || (lastTimeStamp = String.valueOf(((File)entry.getKey()).lastModified())).equals(cachedTimeStamp = ((Properties)entry.getValue()).getProperty(TIME_STAMP_NAME))) continue;
                    iterator.remove();
                }
            }
        }, 5, true);
    }
}

