/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import org.voovan.tools.DynamicAgent;
import org.voovan.tools.TFile;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.TZip;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class TEnv {
    public static Float JDK_VERSION = Float.valueOf(System.getProperty("java.vm.specification.version"));
    public static String OS_NAME = System.getProperty("os.name").toUpperCase();
    public static Thread MAIN_THREAD = TEnv.getMainThread();
    public static volatile boolean IS_SHUTDOWN = false;
    public static Instrumentation instrumentation;
    private static String ENV_NAME;

    public static String getEnvName() {
        return ENV_NAME;
    }

    public static void setEnvName(String envName) {
        ENV_NAME = envName;
    }

    public static long getCurrentPID() {
        return Long.parseLong(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static Process createSysProcess(String command, String[] env, File workDir) throws IOException {
        Runtime runTime = Runtime.getRuntime();
        if (workDir == null || workDir.exists()) {
            return runTime.exec(command, env, workDir);
        }
        return null;
    }

    public static Process createSysProcess(String command, String[] env, String workDir) throws IOException {
        return TEnv.createSysProcess(command, env, workDir == null ? null : new File(workDir));
    }

    public static boolean sleep(int sleepTime) {
        try {
            Thread.sleep(sleepTime);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static boolean sleep(TimeUnit timeUnit, int sleepTime) {
        try {
            timeUnit.sleep(sleepTime);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static StackTraceElement[] getStackElements() {
        Throwable ex = new Throwable();
        return ex.getStackTrace();
    }

    public static boolean classInCurrentStack(String clazzName, String method) {
        for (StackTraceElement stackTraceElement : TEnv.getStackElements()) {
            if (clazzName == null || !stackTraceElement.getClassName().contains(clazzName) || method != null && !stackTraceElement.getMethodName().equals(method)) continue;
            return true;
        }
        return false;
    }

    public static String getStackMessage() {
        StringBuilder stackInfo = new StringBuilder();
        Throwable ex = new Throwable();
        int row = 0;
        for (StackTraceElement stackTraceElement : ex.getStackTrace()) {
            if (row != 0) {
                stackInfo.append(stackTraceElement.toString());
                stackInfo.append("\r\n");
            }
            ++row;
        }
        return stackInfo.toString();
    }

    public static String getStackElementsMessage(StackTraceElement[] stackTraceElements) {
        StringBuilder stackInfo = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            stackInfo.append(stackTraceElement.toString());
            stackInfo.append("\r\n");
        }
        return stackInfo.toString().trim();
    }

    public static Thread[] getThreads() {
        ThreadGroup group = Thread.currentThread().getThreadGroup().getParent();
        int estimatedSize = group.activeCount() * 2;
        Thread[] slackList = new Thread[estimatedSize];
        int actualSize = group.enumerate(slackList);
        Thread[] list = new Thread[actualSize];
        System.arraycopy(slackList, 0, list, 0, actualSize);
        return list;
    }

    public static Thread getMainThread() {
        for (Thread thread : TEnv.getThreads()) {
            if (thread.getId() != 1L) continue;
            return thread;
        }
        return null;
    }

    public static List<Class> searchClassInEnv(String pattern, Class[] filters) throws IOException {
        String userDir = System.getProperty("user.dir");
        List<String> classPaths = TEnv.getClassPath();
        ArrayList<Class> clazzes = new ArrayList<Class>();
        for (String classPath : classPaths) {
            if (TString.isNullOrEmpty(classPath)) continue;
            File classPathFile = new File(classPath);
            if (classPathFile.exists() && classPathFile.isDirectory()) {
                clazzes.addAll(TEnv.getDirectorClass(classPathFile, pattern, filters));
                continue;
            }
            if (!classPathFile.exists() || !classPathFile.isFile() || !classPathFile.getName().endsWith(".jar")) continue;
            clazzes.addAll(TEnv.getJarClass(classPathFile, pattern, filters));
        }
        return clazzes;
    }

    public static List<Class> getDirectorClass(File rootfile, String pattern, Class[] filters) throws IOException {
        if (pattern != null) {
            pattern = pattern.replace(".", File.separator);
        }
        ArrayList<Class> result = new ArrayList<Class>();
        List<File> files = TFile.scanFile(rootfile, pattern);
        for (File file : files) {
            String fileName = file.getCanonicalPath();
            if (!"class".equals(TFile.getFileExtension(fileName)) || TString.regexMatch(fileName, "G\\$\\d\\.class") > 0) continue;
            fileName = fileName.replace(rootfile.getCanonicalPath() + File.separator, "");
            try {
                Class clazz = TEnv.resourceToClass(fileName);
                if (!TReflect.classChecker(clazz, filters)) continue;
                result.add(clazz);
            }
            catch (ClassNotFoundException e) {
                Logger.warn("Try to load class[" + fileName + "] failed", e);
            }
        }
        return result;
    }

    public static List<Class> getJarClass(File jarFile, String pattern, Class[] filters) throws IOException {
        if (pattern != null) {
            pattern = pattern.replace(".", File.separator);
        }
        ArrayList<Class> result = new ArrayList<Class>();
        List<JarEntry> jarEntrys = TFile.scanJar(jarFile, pattern);
        for (JarEntry jarEntry : jarEntrys) {
            String fileName = jarEntry.getName();
            if (!"class".equals(TFile.getFileExtension(fileName)) || TString.regexMatch(fileName, "\\$\\d\\.class") > 0) continue;
            try {
                Class clazz = TEnv.resourceToClass(fileName);
                if (!TReflect.classChecker(clazz, filters)) continue;
                result.add(clazz);
            }
            catch (Throwable e) {
                fileName = null;
            }
        }
        return result;
    }

    public static byte[] loadClassBytes(Class clazz) {
        Object inputStream = null;
        try {
            String classLocation = TEnv.getClassLocation(clazz);
            String classPathName = TEnv.classToResource(clazz);
            if (classLocation.endsWith("jar")) {
                return TZip.loadFileFromZip(classLocation, classPathName);
            }
            return TFile.loadFileFromSysPath(classLocation + classPathName);
        }
        catch (Exception e) {
            Logger.error("Load class bytes by " + clazz.getCanonicalName() + "error", e);
            return null;
        }
    }

    public static String getClassLocation(Class clazz) {
        if (clazz.getProtectionDomain().getCodeSource().getLocation() != null) {
            return clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getClassModifyTime(Class clazz) {
        String location = TEnv.getClassLocation(clazz);
        if (location == null) {
            return -1L;
        }
        String classNamePath = TEnv.classToResource(clazz);
        try {
            if (!location.endsWith(".jar")) {
                if (!location.endsWith(File.separator)) return -1L;
                File classFile = new File(location + classNamePath);
                if (classFile == null) return -1L;
                if (!classFile.exists()) return -1L;
                return classFile.lastModified();
            }
            try (JarFile jarFile = new JarFile(location);){
                JarEntry jarEntry = jarFile.getJarEntry(classNamePath);
                if (jarEntry != null) {
                    long l = jarEntry.getTime();
                    return l;
                }
                long l = -1L;
                return l;
            }
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public static List<String> getClassPath() {
        String[] classPaths;
        ArrayList<String> userClassPath = new ArrayList<String>();
        String javaHome = System.getProperty("java.home");
        javaHome = javaHome.replaceAll("\\/[a-zA-z0-9\\_\\$]*$", "");
        for (String classPath : classPaths = System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (classPath.startsWith(javaHome)) continue;
            userClassPath.add(classPath);
        }
        return userClassPath;
    }

    public static String classToResource(Class clazz) {
        String classNamePath = clazz.getName();
        if (clazz.isMemberClass()) {
            classNamePath = TString.fastReplaceAll(classNamePath, "\\$.*$", "");
        }
        return TString.fastReplaceAll(classNamePath, "\\.", File.separator) + ".class";
    }

    public static Class resourceToClass(String resourcePath) throws ClassNotFoundException {
        String className = null;
        if (resourcePath.startsWith(File.separator)) {
            resourcePath = TString.removePrefix(resourcePath);
        }
        className = TString.fastReplaceAll(resourcePath, "\\$.*\\.class$", ".class");
        className = TString.fastReplaceAll(className, ".class$", "");
        className = TString.fastReplaceAll(className, Matcher.quoteReplacement(File.separator), ".");
        try {
            return Class.forName(className);
        }
        catch (Exception ex) {
            throw new ClassNotFoundException("load and define class " + className + " failed");
        }
    }

    public static String getJavaHome() {
        String sysLibPath = System.getProperty("sun.boot.library.path");
        return sysLibPath.substring(0, sysLibPath.indexOf("/jre/lib"));
    }

    private static File findAgentJar() {
        List<File> agentJars = new ArrayList<File>();
        for (String classPath : System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (TString.regexMatch(classPath, "((dd[\\.\\-](\\d\\.?)*.*?)|(voovan-((framework)|(common))[\\.\\-].*?)).?jar$") == 0) continue;
            agentJars.add(new File(classPath));
        }
        if (agentJars.size() == 0) {
            agentJars = TFile.scanFile(new File(TFile.getContextPath()), "((dd[\\.\\-](\\d\\.?)*.*?)|(voovan-((framework)|(common))[\\.\\-].*?)).?jar$");
        }
        File agentJar = null;
        for (File jarFile : agentJars) {
            if (agentJar == null) {
                agentJar = jarFile;
            }
            if (agentJar.lastModified() >= jarFile.lastModified()) continue;
            agentJar = jarFile;
        }
        return agentJar;
    }

    public static Instrumentation agentAttach(String agentJarPath) throws IOException, AttachNotSupportedException, AgentLoadException, AgentInitializationException {
        if (instrumentation == null) {
            if (agentJarPath == null) {
                File agentJar = TEnv.findAgentJar();
                if (agentJar != null && agentJar.exists()) {
                    agentJarPath = agentJar.getAbsolutePath();
                    Logger.info("[System] Choose an agent jar file: " + agentJarPath);
                } else {
                    throw new FileNotFoundException("The agent jar file not found");
                }
            }
            try {
                VirtualMachine vm = VirtualMachine.attach(Long.toString(TEnv.getCurrentPID()));
                vm.loadAgent(agentJarPath);
                instrumentation = DynamicAgent.getInstrumentation();
                vm.detach();
                return instrumentation;
            }
            catch (IOException e) {
                if (e.getMessage().contains("allowAttachSelf")) {
                    e = new IOException("You should add java command arguments: -Djdk.attach.allowAttachSelf=true with java command.");
                }
                throw e;
            }
        }
        return instrumentation;
    }

    public static void wait(int waitTime, Supplier<Boolean> supplier) throws TimeoutException {
        long start = System.currentTimeMillis();
        do {
            if (!supplier.get().booleanValue()) {
                return;
            }
            TEnv.sleep(1);
        } while (System.currentTimeMillis() - start < (long)waitTime);
        throw new TimeoutException("TEnv.wait time out");
    }

    public static void wait(Supplier<Boolean> supplier) {
        try {
            TEnv.wait(Integer.MAX_VALUE, supplier);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
    }

    public static List<Object> measureTime(Supplier supplier) {
        long startTime = System.nanoTime();
        return TObject.asList(supplier.get(), System.nanoTime() - startTime);
    }

    public static long measureTime(Runnable runnable) {
        long startTime = System.nanoTime();
        runnable.run();
        return System.nanoTime() - startTime;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                IS_SHUTDOWN = true;
            }
        });
        ENV_NAME = null;
    }
}

