/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.nio.charset.Charset;

public class TByte {
    public static byte[] getBytes(short data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8)};
        return bytes;
    }

    public static byte[] getBytes(char data) {
        byte[] bytes = new byte[]{(byte)data, (byte)(data >> 8)};
        return bytes;
    }

    public static byte[] getBytes(int data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8), (byte)((data & 0xFF0000) >> 16), (byte)((data & 0xFF000000) >> 24)};
        return bytes;
    }

    public static byte[] getBytes(long data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
        return bytes;
    }

    public static byte[] getBytes(float data) {
        int intBits = Float.floatToIntBits(data);
        return TByte.getBytes(intBits);
    }

    public static byte[] getBytes(double data) {
        long intBits = Double.doubleToLongBits(data);
        return TByte.getBytes(intBits);
    }

    public static byte[] getBytes(String data, String charsetName) {
        Charset charset = Charset.forName(charsetName);
        return data.getBytes(charset);
    }

    public static byte[] getBytes(String data) {
        return TByte.getBytes(data, "UTF-8");
    }

    public static short getShort(byte[] bytes) {
        return (short)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
    }

    public static char getChar(byte[] bytes) {
        return (char)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
    }

    public static int getInt(byte[] bytes) {
        return 0xFF & bytes[0] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[2] << 16 | 0xFF000000 & bytes[3] << 24;
    }

    public static long getLong(byte[] bytes) {
        return 0xFFL & (long)bytes[0] | 0xFF00L & (long)bytes[1] << 8 | 0xFF0000L & (long)bytes[2] << 16 | 0xFF000000L & (long)bytes[3] << 24 | 0xFF00000000L & (long)bytes[4] << 32 | 0xFF0000000000L & (long)bytes[5] << 40 | 0xFF000000000000L & (long)bytes[6] << 48 | 0xFF00000000000000L & (long)bytes[7] << 56;
    }

    public static float getFloat(byte[] bytes) {
        return Float.intBitsToFloat(TByte.getInt(bytes));
    }

    public static double getDouble(byte[] bytes) {
        long l = TByte.getLong(bytes);
        System.out.println(l);
        return Double.longBitsToDouble(l);
    }

    public static String getString(byte[] bytes, String charsetName) {
        return new String(bytes, Charset.forName(charsetName));
    }

    public static String getString(byte[] bytes) {
        return TByte.getString(bytes, "UTF-8");
    }
}

