/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.voovan.tools.FastThread;

public class FastThreadLocal<T> {
    private ThreadLocal<FastThreadLocal> jdkThreadLocal = new ThreadLocal();
    private static AtomicInteger indexGenerator = new AtomicInteger(0);
    volatile int index = indexGenerator.getAndIncrement();
    private Object value;
    private Supplier supplier;

    public static <T> FastThreadLocal<T> withInitial(Supplier<T> supplier) {
        FastThreadLocal<T> fastThreadLocal = new FastThreadLocal<T>();
        fastThreadLocal.setSupplier(supplier);
        return fastThreadLocal;
    }

    public Supplier<T> getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public T get() {
        this.tryCreate();
        if (FastThread.getThread() != null) {
            FastThreadLocal fastThreadLocal = FastThread.getThread().data[this.index];
            Object t = fastThreadLocal.value;
            if (t == null && this.supplier != null) {
                fastThreadLocal.value = t = this.supplier.get();
            }
            return (T)t;
        }
        FastThreadLocal fastThreadLocal = this.jdkThreadLocal.get();
        Object t = fastThreadLocal.value;
        if (t == null && this.supplier != null) {
            fastThreadLocal.value = t = this.supplier.get();
        }
        return (T)t;
    }

    public void tryCreate() {
        if (FastThread.getThread() != null) {
            FastThreadLocal[] data = FastThread.getThread().data;
            FastThreadLocal<T> fastThreadLocal = data[this.index];
            if (fastThreadLocal == null) {
                data[this.index] = fastThreadLocal = new FastThreadLocal<T>();
            }
        } else {
            FastThreadLocal fastThreadLocal = this.jdkThreadLocal.get();
            if (fastThreadLocal == null) {
                this.jdkThreadLocal.set(new FastThreadLocal<T>());
            }
        }
    }

    public void set(T t) {
        this.tryCreate();
        if (FastThread.getThread() != null) {
            FastThread.getThread().data[this.index].value = t;
        } else {
            this.jdkThreadLocal.get().value = t;
        }
    }
}

