/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.tools;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import org.voovan.Global;
import org.voovan.tools.TFile;
import org.voovan.tools.reflect.TReflect;

public class DynamicAgent {
    private static Instrumentation instrumentation;
    private static Object lockObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void agentmain(String agentArgs, Instrumentation inst) {
        Object object = lockObject;
        synchronized (object) {
            if (instrumentation == null) {
                instrumentation = inst;
            }
        }
        if (instrumentation != null) {
            instrumentation.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader loader, String classPath, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                    String className = classPath.replaceAll("/", ".");
                    if (Global.REMOTE_CLASS_SOURCE != null && !TReflect.isSystemType(className)) {
                        return DynamicAgent.getClassBytes(className);
                    }
                    return classfileBuffer;
                }
            });
        }
    }

    public static byte[] getClassBytes(String classPath) {
        String path = classPath.replace(".", "/") + ".class";
        return TFile.loadResource(path);
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    static {
        lockObject = new Object();
    }
}

