/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network.udp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.DatagramChannel;
import java.nio.channels.spi.SelectorProvider;
import org.voovan.network.ConnectModel;
import org.voovan.network.SocketContext;
import org.voovan.network.exception.ReadMessageException;
import org.voovan.network.exception.SendMessageException;
import org.voovan.network.udp.UdpSession;
import org.voovan.tools.log.Logger;

public class UdpSocket
extends SocketContext<DatagramChannel, UdpSession> {
    private SelectorProvider provider;
    private DatagramChannel datagramChannel;
    private UdpSession session;
    private Object waitObj = new Object();

    public UdpSocket(String host, int port, int readTimeout) throws IOException {
        super(host, port, readTimeout);
    }

    public UdpSocket(String host, int port, int readTimeout, int idleInterval) throws IOException {
        super(host, port, readTimeout, idleInterval);
    }

    public UdpSocket(String host, int port, int readTimeout, int sendTimeout, int idleInterval) throws IOException {
        super(host, port, readTimeout, sendTimeout, idleInterval);
    }

    private void init() throws IOException {
        this.provider = SelectorProvider.provider();
        this.datagramChannel = this.provider.openDatagramChannel();
        this.datagramChannel.socket().setSoTimeout(this.readTimeout);
        InetSocketAddress address = new InetSocketAddress(this.host, this.port);
        this.session = new UdpSession(this, address);
        this.connectModel = ConnectModel.CLIENT;
    }

    public UdpSocket(SocketContext parentSocketContext, DatagramChannel datagramChannel, InetSocketAddress socketAddress) {
        try {
            this.provider = SelectorProvider.provider();
            this.datagramChannel = datagramChannel;
            this.copyFrom(parentSocketContext);
            this.session = new UdpSession(this, socketAddress);
            datagramChannel.configureBlocking(false);
            this.connectModel = ConnectModel.SERVER;
        }
        catch (Exception e) {
            Logger.error("Create socket channel failed", e);
        }
    }

    @Override
    public void setIdleInterval(int idleInterval) {
        this.idleInterval = idleInterval;
    }

    @Override
    public <T> void setOption(SocketOption<T> name, T value) throws IOException {
        this.datagramChannel.setOption((SocketOption)name, (Object)value);
    }

    @Override
    public DatagramChannel socketChannel() {
        return this.datagramChannel;
    }

    @Override
    public UdpSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.syncStart();
        Object object = this.waitObj;
        synchronized (object) {
            try {
                this.waitObj.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void syncStart() throws IOException {
        this.init();
        this.datagramChannel.connect(new InetSocketAddress(this.host, this.port));
        this.datagramChannel.configureBlocking(false);
        this.bindToSocketSelector(1);
    }

    @Override
    public void acceptStart() throws IOException {
        this.bindToSocketSelector(0);
    }

    public Object synchronouRead() throws ReadMessageException {
        return this.session.syncRead();
    }

    public void synchronouSend(Object obj) throws SendMessageException {
        this.session.syncSend(obj);
    }

    @Override
    public boolean isOpen() {
        if (this.datagramChannel != null) {
            return this.datagramChannel.isOpen();
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        if (this.datagramChannel != null) {
            return this.datagramChannel.isOpen();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        if (this.datagramChannel != null) {
            this.session.release();
            Object object = this.waitObj;
            synchronized (object) {
                this.waitObj.notify();
            }
            return true;
        }
        Object object = this.waitObj;
        synchronized (object) {
            this.waitObj.notify();
        }
        return true;
    }
}

