/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network.udp;

import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import org.voovan.network.IoSession;
import org.voovan.network.MessageSplitter;
import org.voovan.network.udp.UdpSocket;
import org.voovan.tools.log.Logger;

public class UdpSession
extends IoSession<UdpSocket> {
    private DatagramChannel datagramChannel;
    private InetSocketAddress inetSocketAddress;

    UdpSession(UdpSocket udpSocket, InetSocketAddress inetSocketAddress) {
        super(udpSocket);
        if (udpSocket != null) {
            this.datagramChannel = udpSocket.socketChannel();
            this.inetSocketAddress = inetSocketAddress;
            this.setIdleInterval(0);
        } else {
            Logger.error("Socket is null, please check it.");
        }
    }

    @Override
    public String localAddress() {
        if (this.datagramChannel.isOpen()) {
            return this.datagramChannel.socket().getLocalAddress().getHostAddress();
        }
        return null;
    }

    @Override
    public int loaclPort() {
        if (this.datagramChannel.isOpen()) {
            return this.datagramChannel.socket().getLocalPort();
        }
        return -1;
    }

    @Override
    public String remoteAddress() {
        if (this.datagramChannel.isOpen()) {
            return this.inetSocketAddress.getAddress().getHostAddress();
        }
        return null;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSocketAddress;
    }

    @Override
    public int remotePort() {
        if (this.datagramChannel.isOpen()) {
            return this.inetSocketAddress.getPort();
        }
        return -1;
    }

    protected DatagramChannel datagramChannel() {
        if (this.datagramChannel.isOpen()) {
            return this.datagramChannel;
        }
        return null;
    }

    @Override
    protected MessageSplitter getMessagePartition() {
        return ((UdpSocket)this.socketContext()).messageSplitter();
    }

    @Override
    public boolean isConnected() {
        return ((UdpSocket)this.socketContext()).isConnected();
    }

    @Override
    public boolean isOpen() {
        return ((UdpSocket)this.socketContext()).isOpen();
    }

    @Override
    public boolean close() {
        return ((UdpSocket)this.socketContext()).close();
    }

    @Override
    public String toString() {
        return "[" + this.localAddress() + ":" + this.loaclPort() + "] -> [" + this.remoteAddress() + ":" + this.remotePort() + "]";
    }
}

