/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network.udp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.DatagramChannel;
import java.nio.channels.spi.SelectorProvider;
import org.voovan.network.ConnectModel;
import org.voovan.network.SocketContext;
import org.voovan.network.udp.UdpSession;
import org.voovan.tools.log.Logger;

public class UdpServerSocket
extends SocketContext<DatagramChannel, UdpSession> {
    private SelectorProvider provider;
    private DatagramChannel datagramChannel;
    private Object waitObj = new Object();

    public UdpServerSocket(String host, int port, int readTimeout) throws IOException {
        super(host, port, readTimeout);
        this.init();
    }

    public UdpServerSocket(String host, int port, int readTimeout, int idleInterval) throws IOException {
        super(host, port, readTimeout, idleInterval);
        this.init();
    }

    public UdpServerSocket(String host, int port, int readTimeout, int sendTimeout, int idleInterval) throws IOException {
        super(host, port, readTimeout, sendTimeout, idleInterval);
        this.init();
    }

    private void init() throws IOException {
        this.provider = SelectorProvider.provider();
        this.datagramChannel = this.provider.openDatagramChannel();
        this.datagramChannel.socket().setSoTimeout(this.readTimeout);
        this.datagramChannel.configureBlocking(false);
        this.connectModel = ConnectModel.LISTENER;
    }

    @Override
    public void setIdleInterval(int idleInterval) {
        this.idleInterval = idleInterval;
    }

    @Override
    public <T> void setOption(SocketOption<T> name, T value) throws IOException {
        this.datagramChannel.setOption((SocketOption)name, (Object)value);
    }

    @Override
    public DatagramChannel socketChannel() {
        return this.datagramChannel;
    }

    @Override
    public UdpSession getSession() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.syncStart();
        Object object = this.waitObj;
        synchronized (object) {
            try {
                this.waitObj.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void syncStart() throws IOException {
        this.datagramChannel.bind(new InetSocketAddress(this.host, this.port));
        this.bindToSocketSelector(1);
    }

    @Override
    protected void acceptStart() throws IOException {
        throw new UnsupportedEncodingException();
    }

    @Override
    public boolean isOpen() {
        if (this.datagramChannel != null) {
            return this.datagramChannel.isOpen();
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        if (this.datagramChannel != null) {
            return this.datagramChannel.isOpen();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        if (this.datagramChannel != null) {
            try {
                this.datagramChannel.close();
                Object object = this.waitObj;
                synchronized (object) {
                    this.waitObj.notify();
                }
                return true;
            }
            catch (IOException e) {
                Logger.error("Close SocketChannel failed", e);
                return false;
            }
        }
        return true;
    }
}

