/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import org.voovan.network.ConnectModel;
import org.voovan.network.SocketContext;
import org.voovan.network.exception.ReadMessageException;
import org.voovan.network.exception.SendMessageException;
import org.voovan.network.tcp.TcpSession;
import org.voovan.tools.log.Logger;

public class TcpSocket
extends SocketContext<SocketChannel, TcpSession> {
    private SelectorProvider provider;
    private SocketChannel socketChannel;
    private TcpSession session;
    private Object waitObj = new Object();

    public TcpSocket(String host, int port, int readTimeout) throws IOException {
        super(host, port, readTimeout);
    }

    public TcpSocket(String host, int port, int readTimeout, int idleInterval) throws IOException {
        super(host, port, readTimeout, idleInterval);
    }

    public TcpSocket(String host, int port, int readTimeout, int sendTimeout, int idleInterval) throws IOException {
        super(host, port, readTimeout, sendTimeout, idleInterval);
    }

    private void init() throws IOException {
        this.provider = SelectorProvider.provider();
        this.socketChannel = this.provider.openSocketChannel();
        this.socketChannel.socket().setSoTimeout(this.readTimeout);
        this.session = new TcpSession(this);
        this.connectModel = ConnectModel.CLIENT;
    }

    public TcpSocket(SocketContext parentSocketContext, SocketChannel socketChannel) {
        try {
            this.provider = SelectorProvider.provider();
            this.host = socketChannel.socket().getLocalAddress().getHostAddress();
            this.port = socketChannel.socket().getLocalPort();
            this.socketChannel = socketChannel;
            socketChannel.configureBlocking(false);
            this.copyFrom(parentSocketContext);
            this.socketChannel().socket().setSoTimeout(this.readTimeout);
            this.session = new TcpSession(this);
            this.connectModel = ConnectModel.SERVER;
        }
        catch (IOException e) {
            Logger.error("Create socket channel failed", e);
        }
    }

    @Override
    public void setIdleInterval(int idleInterval) {
        this.idleInterval = idleInterval;
    }

    @Override
    public <T> void setOption(SocketOption<T> name, T value) throws IOException {
        this.socketChannel.setOption((SocketOption)name, (Object)value);
    }

    @Override
    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    public TcpSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.syncStart();
        Object object = this.waitObj;
        synchronized (object) {
            try {
                this.waitObj.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void syncStart() throws IOException {
        this.init();
        this.initSSL(this.session);
        this.socketChannel.connect(new InetSocketAddress(this.host, this.port));
        this.socketChannel.configureBlocking(false);
        this.bindToSocketSelector(1);
        if (this.isSynchronous) {
            this.waitConnect();
        }
    }

    @Override
    protected void acceptStart() throws IOException {
        try {
            this.initSSL(this.session);
            this.bindToSocketSelector(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isOpen() {
        if (this.socketChannel != null) {
            return this.socketChannel.isOpen();
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        try {
            return this.socketChannel.isConnected() && this.socketChannel.getRemoteAddress() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object synchronouRead() throws ReadMessageException {
        return this.session.syncRead();
    }

    public void synchronouSend(Object obj) throws SendMessageException {
        this.session.syncSend(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        if (this.socketChannel != null) {
            this.session.release();
            Object object = this.waitObj;
            synchronized (object) {
                this.waitObj.notify();
            }
            return true;
        }
        Object object = this.waitObj;
        synchronized (object) {
            this.waitObj.notify();
        }
        return true;
    }
}

